# Sistema de Gestión de Escuela de Arte

Prototipo frontend completo y funcional para un sistema de gestión de escuela de arte, desarrollado con React, React Router DOM y Chakra UI. Sistema de gestión integral que permite administrar alumnos, profesores, clases, bitácoras, pagos y notificaciones desde diferentes perfiles de usuario.

## 🚀 Características Principales

- **Frontend-Only**: Sin lógica de backend, todo funciona con datos mock
- **Datos Mock Completos**: Información completa de alumnos, profesores, clases, bitácoras, pagos y metas
- **Funcionalidad Completa**: Todos los enlaces, botones y formularios son interactivos
- **Diseño Moderno**: Interfaz limpia, minimalista y visual usando Chakra UI
- **Enrutamiento Completo**: Navegación con React Router DOM v6
- **Sistema de Temas**: Tema personalizado con paleta de colores y componentes estilizados
- **Multi-perfil**: 4 tipos de usuarios con interfaces y permisos específicos
- **Componentes Reutilizables**: Arquitectura modular con componentes compartidos

## 📦 Tecnologías

### Dependencias Principales

- **React** `^18.2.0` - Biblioteca de UI
- **React DOM** `^18.2.0` - Renderizado de React
- **React Router DOM** `^6.20.0` - Enrutamiento y navegación
- **Chakra UI** `^2.8.2` - Sistema de componentes UI
- **@chakra-ui/icons** `^2.2.4` - Iconos de Chakra UI
- **React Icons** `^5.5.0` - Biblioteca de iconos adicionales
- **Framer Motion** `^10.16.16` - Animaciones (usado por Chakra UI)
- **Emotion** `^11.11.1` - CSS-in-JS (requerido por Chakra UI)

### Dependencias de Desarrollo

- **Vite** `^5.0.8` - Build tool y dev server
- **@vitejs/plugin-react** `^4.2.1` - Plugin de React para Vite

## 📁 Estructura del Proyecto

```
ArtSchool/
├── index.html              # Punto de entrada HTML
├── package.json            # Dependencias y scripts
├── vite.config.js          # Configuración de Vite
├── README.md               # Documentación
│
└── src/
    ├── main.jsx            # Punto de entrada React con providers
    ├── App.jsx             # Configuración de rutas principales
    ├── theme.js            # Tema personalizado de Chakra UI
    │
    ├── components/         # Componentes reutilizables
    │   ├── Layout.jsx      # Layout principal con Sidebar y Topbar
    │   ├── Sidebar.jsx     # Barra de navegación lateral
    │   ├── Calendar.jsx    # Componente de calendario reutilizable
    │   └── NotificacionCard.jsx  # Tarjeta de notificaciones
    │
    ├── pages/              # Páginas de la aplicación
    │   ├── LoginPage.jsx   # Página de inicio de sesión
    │   │
    │   ├── admin/          # Módulo de Administrador
    │   │   ├── AdminDashboard.jsx
    │   │   ├── AdminLayout.jsx
    │   │   ├── adminLinks.js
    │   │   ├── GestionUsuarios.jsx
    │   │   ├── GestionProfesores.jsx
    │   │   ├── GestionAlumnos.jsx
    │   │   ├── AlumnoDetalle.jsx
    │   │   ├── GestionMaterias.jsx
    │   │   ├── AsignacionClases.jsx
    │   │   ├── CalendarioGlobal.jsx
    │   │   ├── ConsultaBitacoras.jsx
    │   │   ├── CalendarioPagos.jsx
    │   │   ├── ValidacionPagos.jsx
    │   │   └── NotificacionesMasivas.jsx
    │   │
    │   ├── profesor/       # Módulo de Profesor
    │   │   ├── ProfesorDashboard.jsx
    │   │   ├── ProfesorLayout.jsx
    │   │   ├── MisAlumnosMetas.jsx
    │   │   ├── RegistroBitacora.jsx
    │   │   ├── CalendarioProfesor.jsx
    │   │   └── NotificacionesProfesor.jsx
    │   │
    │   ├── padre/          # Módulo de Padre/Tutor
    │   │   ├── PadreDashboard.jsx
    │   │   ├── PadreLayout.jsx
    │   │   ├── ConsultaBitacorasHijo.jsx
    │   │   ├── ConsultaMetasHijo.jsx
    │   │   ├── PagosPadre.jsx
    │   │   ├── CalendarioPadre.jsx
    │   │   └── NotificacionesPadre.jsx
    │   │
    │   └── alumno/         # Módulo de Alumno
    │       ├── AlumnoDashboard.jsx
    │       ├── AlumnoLayout.jsx
    │       ├── ConsultaBitacorasAlumno.jsx
    │       ├── ConsultaMetasAlumno.jsx
    │       ├── CalendarioAlumno.jsx
    │       └── NotificacionesAlumno.jsx
    │
    └── data/
        └── mockData.js     # Datos mock centralizados
```

## 🎯 Módulos y Funcionalidades

### 🔐 Sistema de Autenticación

- **Login Mock**: Autenticación simplificada basada en nombre de usuario
- **Usuarios de Prueba**: `admin`, `profesor`, `padre`, `alumno`
- **Navegación Automática**: Redirección según tipo de usuario
- **Validación de Formulario**: Validación de campos requeridos con toasts

### 👨‍💼 Módulo de Administrador

**Rutas:**
- `/admin` - Dashboard principal
- `/admin/usuarios` - Gestión de usuarios del sistema
- `/admin/profesores` - CRUD de profesores
- `/admin/alumnos` - CRUD de alumnos
- `/admin/alumnos/:id` - Detalle de alumno
- `/admin/materias` - Gestión de materias/cursos
- `/admin/asignar-clases` - Asignación de clases a alumnos
- `/admin/calendario` - Calendario global de todas las clases
- `/admin/bitacoras` - Consulta de todas las bitácoras
- `/admin/calendario-pagos` - Calendario de pagos
- `/admin/validar-pagos` - Validación y aprobación de pagos
- `/admin/notificaciones` - Envío de notificaciones masivas

**Funcionalidades:**
- Gestión completa de usuarios, profesores y alumnos
- Asignación de clases (profesor-alumno-materia-horario)
- Visualización de calendario global
- Consulta y filtrado de bitácoras
- Validación de pagos (Aprobar/Rechazar)
- Envío de notificaciones masivas

### 👨‍🏫 Módulo de Profesor

**Rutas:**
- `/profesor` - Dashboard del profesor
- `/profesor/alumnos` - Gestión de alumnos y metas
- `/profesor/bitacora` - Registro de bitácoras (manual y con IA simulada)
- `/profesor/calendario` - Calendario de clases del profesor
- `/profesor/notificaciones` - Notificaciones recibidas

**Funcionalidades:**
- Visualización de alumnos asignados
- Gestión de metas por alumno
- Registro de bitácoras con:
  - Objetivo de la clase
  - Actividad realizada
  - Evaluación del progreso
  - Tareas asignadas
  - Documentos y evidencias (imágenes, videos, audio)
- Registro con IA simulada (generación automática de contenido)
- Calendario personalizado de clases

### 👨‍👩‍👧 Módulo de Padre/Tutor

**Rutas:**
- `/padre` - Dashboard del padre
- `/padre/bitacoras` - Consulta de bitácoras de hijos
- `/padre/metas` - Consulta de metas de hijos
- `/padre/pagos` - Gestión de pagos
- `/padre/calendario` - Calendario de clases y pagos
- `/padre/notificaciones` - Notificaciones recibidas

**Funcionalidades:**
- Consulta de bitácoras de todos los hijos
- Visualización de metas y objetivos
- Gestión de pagos (subir comprobantes)
- Calendario con clases y fechas de pago
- Notificaciones sobre el progreso de hijos

### 🎓 Módulo de Alumno

**Rutas:**
- `/alumno` - Dashboard del alumno
- `/alumno/bitacoras` - Consulta de bitácoras propias
- `/alumno/metas` - Consulta de metas personales
- `/alumno/calendario` - Calendario de clases
- `/alumno/notificaciones` - Notificaciones recibidas

**Funcionalidades:**
- Consulta de bitácoras propias con evidencias
- Visualización de metas y objetivos
- Calendario personalizado de clases
- Notificaciones sobre tareas y progreso

## 🔑 Perfiles y Permisos

### Administrador
- ✅ Acceso completo a todos los módulos
- ✅ Gestión de usuarios, profesores, alumnos y materias
- ✅ Asignación de clases
- ✅ Validación de pagos
- ✅ Consulta global de bitácoras
- ✅ Envío de notificaciones masivas

### Profesor
- ✅ Visualización de alumnos asignados
- ✅ Gestión de metas por alumno
- ✅ Registro de bitácoras (manual y con IA)
- ✅ Calendario de clases propias
- ✅ Notificaciones

### Padre/Tutor
- ✅ Consulta de bitácoras de hijos
- ✅ Consulta de metas de hijos
- ✅ Gestión de pagos
- ✅ Calendario de clases y pagos
- ✅ Notificaciones

### Alumno
- ✅ Consulta de bitácoras propias
- ✅ Consulta de metas personales
- ✅ Calendario de clases
- ✅ Notificaciones

## 💾 Sistema de Datos Mock

Todos los datos están centralizados en `src/data/mockData.js`:

### Entidades Disponibles

- **mockProfesores**: Lista de profesores con foto, especialidad y email
- **mockAlumnos**: Lista de alumnos con foto, edad, padre asociado y fecha de pago
- **mockPadres**: Lista de padres/tutores con contacto
- **mockMaterias**: Catálogo de materias/cursos disponibles
- **mockClases**: Asignaciones de clases (profesor-alumno-materia-horario)
- **mockBitacoras**: Registros de clases con:
  - Objetivo, actividad, evaluación, tarea
  - Documentos de tarea (PDFs, imágenes)
  - Evidencias (imágenes, videos, audio)
- **mockPagos**: Registros de pagos con estatus (Validado, Pendiente, Rechazado)
- **mockMetas**: Metas y objetivos por alumno

### Estructura de Datos

```javascript
// Ejemplo de estructura de bitácora
{
  id: 1,
  id_alumno: 1,
  id_profesor: 1,
  id_materia: 1,
  fecha: '2024-01-15',
  objetivo: 'Mejorar técnica de mezcla de colores',
  actividad: 'Descripción de la actividad...',
  evaluacion: 'Evaluación del progreso...',
  tarea: 'Tarea asignada...',
  documentos_tarea: [
    { id: 1, nombre: 'archivo.pdf', url: '...', tipo: 'pdf' }
  ],
  evidencias: [
    { id: 1, tipo: 'image', url: '...', thumbnail: '...' },
    { id: 2, tipo: 'video', url: '...', thumbnail: '...' }
  ]
}
```

## 🎨 Sistema de Temas

El tema personalizado está definido en `src/theme.js`:

### Paleta de Colores

- **Brand**: Azul principal (#0EA5E9) estilo TailAdmin
- **Accent**: Colores de acento (yellow, blue, green, pink, orange, purple, indigo)
- **Gray**: Escala de grises completa
- **Sidebar**: Colores específicos para la barra lateral

### Componentes Personalizados

- **Button**: Estilos con hover effects y sombras
- **Card**: Tarjetas con bordes redondeados y hover effects
- **Input/Select/Textarea**: Campos de formulario con focus states
- **Modal**: Modales con backdrop blur
- **Table**: Tablas con hover effects
- **Badge**: Badges con bordes redondeados

## 🔄 Lógica de la Aplicación

### Enrutamiento

- **React Router DOM v6**: Sistema de rutas declarativo
- **Rutas Protegidas**: Redirección basada en tipo de usuario (simulado)
- **Rutas Dinámicas**: Parámetros en URLs (`/admin/alumnos/:id`)

### Navegación

- **Sidebar**: Navegación lateral con enlaces por perfil
- **Topbar**: Barra superior con título dinámico y notificaciones
- **Layout Reutilizable**: Componente Layout usado por todos los módulos

### Estado

- **Estado Local**: Uso de `useState` para formularios y componentes
- **Sin Estado Global**: No se usa Context API o Redux (prototipo)
- **Datos Mock**: Importación directa desde `mockData.js`

### Componentes Reutilizables

- **Calendar**: Componente de calendario usado en múltiples módulos
- **Layout**: Layout base con Sidebar y Topbar
- **NotificacionCard**: Tarjeta de notificación reutilizable

## 🛠️ Instalación

```bash
# Instalar dependencias
npm install
```

## 🚀 Desarrollo

```bash
# Iniciar servidor de desarrollo
npm run dev
```

El servidor se iniciará en `http://localhost:5173` (puerto por defecto de Vite).

## 📦 Build

```bash
# Crear build de producción
npm run build

# Preview del build
npm run preview
```

## 🔐 Login

Usa cualquiera de estos usuarios para acceder:

- `admin` - Acceso como administrador
- `profesor` - Acceso como profesor
- `padre` - Acceso como padre/tutor
- `alumno` - Acceso como alumno

**Nota**: Cualquier contraseña funciona (solo es un prototipo).

## 📋 Scripts Disponibles

- `npm run dev` - Inicia el servidor de desarrollo
- `npm run build` - Crea el build de producción
- `npm run preview` - Previsualiza el build de producción

## 🎯 Características Técnicas

- **Single Page Application (SPA)**: Navegación sin recargar página
- **Component-Based Architecture**: Arquitectura basada en componentes React
- **Responsive Design**: Diseño adaptable (usando Chakra UI)
- **Modern JavaScript**: ES6+ y JSX
- **Fast Refresh**: Hot Module Replacement con Vite
- **Type Safety**: JavaScript (sin TypeScript en este prototipo)

## 📝 Notas de Desarrollo

- Este es un **prototipo frontend-only** sin backend real
- Todos los datos son mock y se resetean al recargar
- No hay persistencia de datos
- La autenticación es simulada
- Ideal para demostraciones y pruebas de concepto

## 🔮 Próximos Pasos Sugeridos

- Integración con backend (API REST)
- Sistema de autenticación real (JWT)
- Persistencia de datos (base de datos)
- Validación de formularios más robusta
- Manejo de errores global
- Estado global (Context API o Redux)
- Tests unitarios y de integración
- TypeScript para type safety

---

Desarrollado con ❤️ usando React y Chakra UI



datos de prueba
CLI-2024-001
SRV-2025-6

empresa: richie.iriarte@gmail.com
contraseña: 123

empleado: juan@gmail.com
contraseña: 123