import { Routes, Route } from 'react-router-dom';
import { Box } from '@chakra-ui/react';

// Login
import LoginPage from './pages/LoginPage';
import LoginPanel from './pages/LoginPanel';

// Root Module
import RootLayout from './pages/root/RootLayout';
import RootDashboard from './pages/root/RootDashboard';
import GestionEmpresas from './pages/root/GestionEmpresas';
import GestionAdministradores from './pages/root/GestionAdministradores';
import ControlModulos from './pages/root/ControlModulos';
import ConfiguracionFooter from './pages/root/ConfiguracionFooter';

// Admin
import AdminLayout from './pages/admin/AdminLayout';
import AdminDashboard from './pages/admin/AdminDashboard';
import GestionClientes from './pages/admin/GestionClientes';
import CatalogoServicios from './pages/admin/CatalogoServicios';
import GestionEmpleados from './pages/admin/GestionEmpleados';
import OrdenesServicio from './pages/admin/OrdenesServicio';
import ConfiguracionEmpresa from './pages/admin/ConfiguracionEmpresa';
import Reportes from './pages/admin/Reportes';

// Employee
import EmployeeLayout from './pages/employee/EmployeeLayout';
import EmployeeDashboard from './pages/employee/EmployeeDashboard';
import MisAsignaciones from './pages/employee/MisAsignaciones';
import CalendarioTrabajo from './pages/employee/CalendarioTrabajo';

// Client
import ClientLayout from './pages/client/ClientLayout';
import ClientDashboard from './pages/client/ClientDashboard';
import SolicitarServicio from './pages/client/SolicitarServicio';
import HistorialServicios from './pages/client/HistorialServicios';

function App() {
  return (
    <Routes>
      <Route path="/" element={<LoginPage />} />
      <Route path="/login" element={<LoginPage />} />
      <Route path="/kepanel" element={<LoginPanel />} />

      {/* Rutas ROOT */}
      <Route path="/root" element={<RootLayout />}>
        <Route index element={<RootDashboard />} />
        <Route path="empresas" element={<GestionEmpresas />} />
        <Route path="administradores" element={<GestionAdministradores />} />
        <Route path="modulos" element={<ControlModulos />} />
        <Route path="configuracion" element={<ConfiguracionFooter />} />
        <Route path="usuarios" element={<Box p={5}>Gestión de Usuarios Root (Pendiente)</Box>} />
      </Route>

      {/* Rutas de Admin */}
      <Route path="/admin" element={<AdminLayout />}>
        <Route index element={<AdminDashboard />} />
        <Route path="clientes" element={<GestionClientes />} />
        <Route path="servicios" element={<CatalogoServicios />} />
        <Route path="empleados" element={<GestionEmpleados />} />
        <Route path="ordenes" element={<OrdenesServicio />} />
        <Route path="configuracion" element={<ConfiguracionEmpresa />} />
        <Route path="reportes" element={<Reportes />} />
      </Route>

      {/* Rutas de Employee */}
      <Route path="/employee" element={<EmployeeLayout />}>
        <Route index element={<EmployeeDashboard />} />
        <Route path="asignaciones" element={<MisAsignaciones />} />
        <Route path="calendario" element={<CalendarioTrabajo />} />
        <Route path="perfil" element={<Box p={5}>Perfil de Empleado (Pendiente)</Box>} />
      </Route>

      {/* Rutas de Client */}
      <Route path="/client" element={<ClientLayout />}>
        <Route index element={<ClientDashboard />} />
        <Route path="solicitar" element={<SolicitarServicio />} />
        <Route path="historial" element={<HistorialServicios />} />
        <Route path="pagos" element={<Box p={5}>Pagos (Pendiente)</Box>} />
        <Route path="notificaciones" element={<Box p={5}>Notificaciones (Pendiente)</Box>} />
      </Route>
    </Routes>
  );
}

export default App;
