import { query } from './database.js';

export const EvidenceModel = {
    async getByServiceId(serviceId) {
        const res = await query('SELECT * FROM evidences WHERE contracted_service_id = $1', [serviceId]);
        return res.rows;
    },

    async create(evidence) {
        const { contracted_service_id, uploaded_by, file_url, file_type } = evidence;
        const res = await query(
            `INSERT INTO evidences (contracted_service_id, uploaded_by, file_url, file_type)
       VALUES ($1, $2, $3, $4)
       RETURNING *`,
            [contracted_service_id, uploaded_by, file_url, file_type]
        );
        return res.rows[0];
    },

    async delete(id) {
        await query('DELETE FROM evidences WHERE id = $1', [id]);
        return true;
    }
};
