import { query } from './database.js';

export const ModuleModel = {
    async getAll() {
        const res = await query('SELECT * FROM modules');
        return res.rows;
    },

    async getByCompanyId(companyId) {
        const res = await query(
            `SELECT m.*, cm.is_enabled
       FROM modules m
       LEFT JOIN company_modules cm ON m.id = cm.module_id AND cm.company_id = $1
       ORDER BY m.id`,
            [companyId]
        );
        return res.rows;
    },

    async toggleModule(companyId, moduleId, isEnabled) {
        const res = await query(
            `INSERT INTO company_modules (company_id, module_id, is_enabled)
       VALUES ($1, $2, $3)
       ON CONFLICT (company_id, module_id)
       DO UPDATE SET is_enabled = $3, enabled_at = CURRENT_TIMESTAMP
       RETURNING *`,
            [companyId, moduleId, isEnabled]
        );
        return res.rows[0];
    }
};
