import { query } from './database.js';

export const OrderModel = {
    async getAll() {
        const res = await query('SELECT * FROM contracted_services');
        return res.rows;
    },

    async getById(id) {
        const res = await query('SELECT * FROM contracted_services WHERE id = $1', [id]);
        return res.rows[0];
    },

    async getByCompanyId(companyId) {
        const res = await query('SELECT * FROM contracted_services WHERE company_id = $1', [companyId]);
        return res.rows;
    },

    async getByClientId(clientId) {
        const res = await query('SELECT * FROM contracted_services WHERE client_id = $1', [clientId]);
        return res.rows;
    },

    async getByEmployeeId(employeeId) {
        const res = await query('SELECT * FROM contracted_services WHERE employee_id = $1', [employeeId]);
        return res.rows;
    },

    async create(order) {
        const { company_id, client_id, service_catalogo_id, employee_id, service_number, service_address, request_date, deadline_date, closed_at, warranty_end_date, status, employee_report, client_rating, client_comment, finalized_by_client } = order;
        const res = await query(
            `INSERT INTO contracted_services (company_id, client_id, service_catalogo_id, employee_id, service_number, service_address, request_date, deadline_date, closed_at, warranty_end_date, status, employee_report, client_rating, client_comment, finalized_by_client)
       VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15)
       RETURNING *`,
            [company_id, client_id, service_catalogo_id, employee_id, service_number, service_address, request_date, deadline_date, closed_at, warranty_end_date, status, employee_report, client_rating, client_comment, finalized_by_client]
        );
        return res.rows[0];
    },

    async update(id, order) {
        const fields = [];
        const values = [];
        let idx = 1;

        // Añadir lógica para fechas automáticas según el estado
        if (order.status === 'FINISHED' && !order.end_date) {
            order.end_date = 'CURRENT_TIMESTAMP';
        }
        if (order.status === 'CLOSED' && !order.closed_at) {
            order.closed_at = 'CURRENT_TIMESTAMP';
        }

        for (const [key, value] of Object.entries(order)) {
            // Excluir campos que no deben ser actualizados directamente
            if (key !== 'updated_at' && key !== 'created_at' && key !== 'id') {
                // Manejar valores de fecha especiales
                if (value === 'CURRENT_TIMESTAMP') {
                    fields.push(`${key} = CURRENT_TIMESTAMP`);
                } else {
                    fields.push(`${key} = $${idx}`);
                    values.push(value);
                    idx++;
                }
            }
        }

        if (fields.length === 0) {
            return this.getById(id);
        }

        values.push(id);

        const res = await query(
            `UPDATE contracted_services SET ${fields.join(', ')}, updated_at = CURRENT_TIMESTAMP WHERE id = $${idx} RETURNING *`,
            values
        );
        return res.rows[0];
    },

    async delete(id) {
        await query('DELETE FROM contracted_services WHERE id = $1', [id]);
        return true;
    }
};
