import { query } from './database.js';

export const UserModel = {
    async getAll() {
        const res = await query('SELECT * FROM users');
        return res.rows;
    },

    async getById(id) {
        const res = await query('SELECT * FROM users WHERE id = $1', [id]);
        return res.rows[0];
    },

    async getByEmail(email) {
        try {
            const res = await query('SELECT * FROM users WHERE email = $1', [email]);
            return res.rows[0];
        } catch (error) {
            console.error('Error fetching user by email:', error);
            throw new Error('Database error');
        }
    },

    async create(user) {
        const { id, company_id, email, password_hash, role, is_active } = user;
        const res = await query(
            `INSERT INTO users (id, company_id, email, password_hash, role, is_active)
       VALUES ($1, $2, $3, $4, $5, $6)
       RETURNING *`,
            [id, company_id, email, password_hash, role, is_active]
        );
        return res.rows[0];
    },

    async update(id, user) {
        const fields = [];
        const values = [];
        let idx = 1;

        for (const [key, value] of Object.entries(user)) {
            if (key !== 'updated_at' && key !== 'created_at' && key !== 'id' && key !== 'password') {
                fields.push(`${key} = $${idx}`);
                values.push(value);
                idx++;
            }
        }
        values.push(id);

        const res = await query(
            `UPDATE users SET ${fields.join(', ')}, updated_at = CURRENT_TIMESTAMP WHERE id = $${idx} RETURNING *`,
            values
        );
        return res.rows[0];
    },

    async delete(id) {
        await query('DELETE FROM users WHERE id = $1', [id]);
        return true;
    }
};
