import { useParams } from 'react-router-dom';
import {
  Box,
  Heading,
  Avatar,
  VStack,
  HStack,
  Text,
  Badge,
  Divider,
  SimpleGrid,
  Card,
  CardBody
} from '@chakra-ui/react';
import Layout from '../../components/Layout';
import { adminLinks } from './adminLinks';
import { mockAlumnos, mockPadres, mockBitacoras, mockClases, mockMaterias, mockProfesores } from '../../data/mockData';

const AlumnoDetalle = () => {
  const { id } = useParams();
  const alumno = mockAlumnos.find(a => a.id === parseInt(id));
  const padre = alumno ? mockPadres.find(p => p.id === alumno.id_padre) : null;
  const bitacorasAlumno = alumno ? mockBitacoras.filter(b => b.id_alumno === alumno.id) : [];
  const clasesAlumno = alumno ? mockClases.filter(c => c.id_alumno === alumno.id) : [];

  if (!alumno) {
    return (
      <Layout links={adminLinks} userType="Administrador" userName="Admin User">
        <Box>
          <Heading>Alumno no encontrado</Heading>
        </Box>
      </Layout>
    );
  }

  return (
    <Layout links={adminLinks} userType="Administrador" userName="Admin User">
      <Box>
        <HStack mb={4} spacing={4}>
          <Avatar size="xl" src={alumno.foto_url} name={alumno.nombre} />
          <VStack align="start" spacing={1}>
            <Heading size="lg" color="brand.500">{alumno.nombre}</Heading>
            <Text color="gray.600">{alumno.email}</Text>
            <Badge colorScheme="brand">{alumno.edad} años</Badge>
          </VStack>
        </HStack>

        {/* Instrucciones minimalistas */}
        <Text fontSize="sm" color="gray.600" mb={6}>
          Información detallada del alumno. <strong>Revisa clases asignadas y bitácoras recientes</strong> para seguimiento.
        </Text>

        <Divider mb={6} />

        <SimpleGrid columns={{ base: 1, md: 2 }} spacing={6} mb={6}>
          <Box
            bg="rgba(255, 255, 255, 0.6)"
            backdropFilter="blur(20px) saturate(180%)"
            WebkitBackdropFilter="blur(20px) saturate(180%)"
            p={6}
            borderRadius="md"
            boxShadow="0 8px 32px 0 rgba(0, 0, 0, 0.1)"
            border="1px solid"
            borderColor="rgba(255, 255, 255, 0.3)"
          >
            <Heading size="sm" mb={4} color="brand.500">Información del Padre/Tutor</Heading>
            {padre && (
              <VStack align="start" spacing={2}>
                <Text><strong>Nombre:</strong> {padre.nombre}</Text>
                <Text><strong>Email:</strong> {padre.email}</Text>
                <Text><strong>Teléfono:</strong> {padre.telefono}</Text>
              </VStack>
            )}
          </Box>

          <Box
            bg="rgba(255, 255, 255, 0.6)"
            backdropFilter="blur(20px) saturate(180%)"
            WebkitBackdropFilter="blur(20px) saturate(180%)"
            p={6}
            borderRadius="md"
            boxShadow="0 8px 32px 0 rgba(0, 0, 0, 0.1)"
            border="1px solid"
            borderColor="rgba(255, 255, 255, 0.3)"
          >
            <Heading size="sm" mb={4} color="brand.500">Información de Pago</Heading>
            <VStack align="start" spacing={2}>
              <Text><strong>Fecha de Pago:</strong> {alumno.fecha_pago}</Text>
              <Badge colorScheme="green">Al día</Badge>
            </VStack>
          </Box>
        </SimpleGrid>

        <Box
          bg="rgba(255, 255, 255, 0.6)"
          backdropFilter="blur(20px) saturate(180%)"
          WebkitBackdropFilter="blur(20px) saturate(180%)"
          p={6}
          borderRadius="md"
          boxShadow="0 8px 32px 0 rgba(0, 0, 0, 0.1)"
          border="1px solid"
          borderColor="rgba(255, 255, 255, 0.3)"
          mb={6}
        >
          <Heading size="sm" mb={4} color="brand.500">Clases Asignadas</Heading>
          <SimpleGrid columns={{ base: 1, md: 2 }} spacing={4}>
            {clasesAlumno.map((clase) => {
              const materia = mockMaterias.find(m => m.id === clase.id_materia);
              const profesor = mockProfesores.find(p => p.id === clase.id_profesor);
              return (
                <Card key={clase.id}>
                  <CardBody>
                    <Text fontWeight="bold">{materia?.nombre}</Text>
                    <Text fontSize="sm" color="gray.600">Profesor: {profesor?.nombre}</Text>
                    <Text fontSize="sm" color="gray.600">{clase.dia_semana} {clase.hora_inicio} - {clase.hora_fin}</Text>
                  </CardBody>
                </Card>
              );
            })}
          </SimpleGrid>
        </Box>

        <Box
          bg="rgba(255, 255, 255, 0.6)"
          backdropFilter="blur(20px) saturate(180%)"
          WebkitBackdropFilter="blur(20px) saturate(180%)"
          p={6}
          borderRadius="md"
          boxShadow="0 8px 32px 0 rgba(0, 0, 0, 0.1)"
          border="1px solid"
          borderColor="rgba(255, 255, 255, 0.3)"
        >
          <Heading size="sm" mb={4} color="brand.500">Bitácoras Recientes</Heading>
          <VStack align="stretch" spacing={4}>
            {bitacorasAlumno.slice(0, 3).map((bitacora) => {
              const profesor = mockProfesores.find(p => p.id === bitacora.id_profesor);
              return (
                <Box key={bitacora.id} p={4} borderWidth="1px" borderRadius="md">
                  <HStack justify="space-between" mb={2}>
                    <Text fontWeight="bold">{bitacora.fecha}</Text>
                    <Text fontSize="sm" color="gray.600">Profesor: {profesor?.nombre}</Text>
                  </HStack>
                  <Text fontSize="sm" mb={2}><strong>Objetivo:</strong> {bitacora.objetivo}</Text>
                  <Text fontSize="sm" color="gray.600">{bitacora.actividad.substring(0, 100)}...</Text>
                </Box>
              );
            })}
          </VStack>
        </Box>
      </Box>
    </Layout>
  );
};

export default AlumnoDetalle;

