import {
  Box,
  Text
} from '@chakra-ui/react';
import Layout from '../../components/Layout';
import { adminLinks } from './adminLinks';
import Calendar from '../../components/Calendar';
import { mockClases, mockProfesores, mockAlumnos, mockMaterias, mockBitacoras } from '../../data/mockData';

const CalendarioGlobal = () => {
  // Enriquecer las clases con información completa
  const clasesEnriquecidas = mockClases.map(clase => ({
    ...clase,
    profesor: mockProfesores.find(p => p.id === clase.id_profesor),
    alumno: mockAlumnos.find(a => a.id === clase.id_alumno),
    materia: mockMaterias.find(m => m.id === clase.id_materia)
  }));

  return (
    <Layout links={adminLinks} userType="Administrador" userName="Admin User">
      <Box mb={4}>
        <Text fontSize="sm" color="gray.600" mb={6}>
          Visualiza todas las clases programadas. <strong>El calendario muestra horarios y asignaciones</strong> de todos los profesores y alumnos.
        </Text>
      </Box>
      <Calendar 
        clases={clasesEnriquecidas} 
        bitacoras={mockBitacoras}
        alumnos={mockAlumnos}
        userType="admin" 
      />
    </Layout>
  );
};

export default CalendarioGlobal;

