import {
    Box,
    Heading,
    SimpleGrid,
    Card,
    CardHeader,
    CardBody,
    Text,
    Stat,
    StatLabel,
    StatNumber,
    StatHelpText,
    StatArrow,
    Progress
} from '@chakra-ui/react';

const Reportes = () => {
    return (
        <Box>
            <Heading mb={6}>Reportes y Métricas</Heading>

            <SimpleGrid columns={{ base: 1, md: 2 }} spacing={6}>
                <Card>
                    <CardHeader>
                        <Heading size="md">Satisfacción del Cliente</Heading>
                    </CardHeader>
                    <CardBody>
                        <Stat mb={4}>
                            <StatLabel>Calificación Promedio</StatLabel>
                            <StatNumber>4.8 / 5.0</StatNumber>
                            <StatHelpText>
                                <StatArrow type="increase" />
                                0.2 puntos vs mes anterior
                            </StatHelpText>
                        </Stat>
                        <Box>
                            <Text fontSize="sm" mb={1}>5 Estrellas (85%)</Text>
                            <Progress value={85} colorScheme="green" size="sm" mb={3} />

                            <Text fontSize="sm" mb={1}>4 Estrellas (10%)</Text>
                            <Progress value={10} colorScheme="blue" size="sm" mb={3} />

                            <Text fontSize="sm" mb={1}>3 Estrellas (3%)</Text>
                            <Progress value={3} colorScheme="yellow" size="sm" mb={3} />

                            <Text fontSize="sm" mb={1}>Menos de 3 (2%)</Text>
                            <Progress value={2} colorScheme="red" size="sm" />
                        </Box>
                    </CardBody>
                </Card>

                <Card>
                    <CardHeader>
                        <Heading size="md">Eficiencia de Servicios</Heading>
                    </CardHeader>
                    <CardBody>
                        <Stat mb={4}>
                            <StatLabel>Tiempo Promedio de Cierre</StatLabel>
                            <StatNumber>2.5 Días</StatNumber>
                            <StatHelpText>
                                <StatArrow type="decrease" />
                                10% más rápido que el promedio
                            </StatHelpText>
                        </Stat>
                        <Box>
                            <Text fontSize="sm" mb={1}>A tiempo (92%)</Text>
                            <Progress value={92} colorScheme="green" size="sm" mb={3} />

                            <Text fontSize="sm" mb={1}>Con retraso leve (5%)</Text>
                            <Progress value={5} colorScheme="orange" size="sm" mb={3} />

                            <Text fontSize="sm" mb={1}>Con retraso crítico (3%)</Text>
                            <Progress value={3} colorScheme="red" size="sm" />
                        </Box>
                    </CardBody>
                </Card>
            </SimpleGrid>
        </Box>
    );
};

export default Reportes;
