import {
  Box,
  Text
} from '@chakra-ui/react';
import Layout from '../../components/Layout';
import Calendar from '../../components/Calendar';
import { mockClases, mockMaterias, mockBitacoras, mockAlumnos, mockProfesores } from '../../data/mockData';

const alumnoLinks = [
  { nombre: 'Dashboard', path: '/alumno' },
  { nombre: 'Mis Clases', path: '/alumno/clases' },
  { nombre: 'Bitácoras', path: '/alumno/bitacoras' },
  { nombre: 'Pagos', path: '/alumno/pagos' },
];

const alumnoId = 1;
const misClases = mockClases.filter(c => c.id_alumno === alumnoId);

const CalendarioAlumno = () => {
  // Enriquecer las clases con información completa
  const clasesEnriquecidas = misClases.map(clase => ({
    ...clase,
    profesor: mockProfesores.find(p => p.id === clase.id_profesor),
    alumno: mockAlumnos.find(a => a.id === clase.id_alumno),
    materia: mockMaterias.find(m => m.id === clase.id_materia)
  }));

  // Bitácoras del alumno
  const misBitacoras = mockBitacoras.filter(b => b.id_alumno === alumnoId);
  const miAlumno = mockAlumnos.find(a => a.id === alumnoId);

  return (
    <Layout links={alumnoLinks} userType="Alumno" userName="Sofía López">
      <Box mb={4}>
        <Text fontSize="sm" color="gray.600" mb={6}>
          Visualiza tus clases programadas. <strong>El calendario muestra tus horarios</strong> y las bitácoras registradas.
        </Text>
      </Box>
      <Calendar
        clases={clasesEnriquecidas}
        bitacoras={misBitacoras}
        alumnos={miAlumno ? [miAlumno] : []}
        userType="alumno"
      />
    </Layout>
  );
};

export default CalendarioAlumno;

