import {
  Box,
  Heading,
  Text,
  Card,
  CardBody,
  Badge,
  VStack
} from '@chakra-ui/react';
import Layout from '../../components/Layout';
import { mockMetas } from '../../data/mockData';

const alumnoLinks = [
  { nombre: 'Dashboard', path: '/alumno' },
  { nombre: 'Mis Clases', path: '/alumno/clases' },
  { nombre: 'Bitácoras', path: '/alumno/bitacoras' },
  { nombre: 'Pagos', path: '/alumno/pagos' },
];

const alumnoId = 1;

const ConsultaMetasAlumno = () => {
  return (
    <Layout links={alumnoLinks} userType="Alumno" userName="Sofía López">
      <Box>
        <Heading size="lg" mb={4} color="brand.500">Mis Metas y Objetivos</Heading>

        {/* Instrucciones minimalistas */}
        <Text fontSize="sm" color="gray.600" mb={6}>
          Revisa las metas establecidas por tu profesor. <strong>Estas metas guían tu progreso</strong> durante el curso.
        </Text>

        <Card>
          <CardBody>
            <VStack align="stretch" spacing={3}>
              <Badge colorScheme="brand" w="fit-content">Mis Metas</Badge>
              <Text color="gray.700" whiteSpace="pre-wrap" fontSize="lg">
                {mockMetas[alumnoId] || 'No se han establecido metas aún.'}
              </Text>
            </VStack>
          </CardBody>
        </Card>
      </Box>
    </Layout>
  );
};

export default ConsultaMetasAlumno;

