import { Outlet } from 'react-router-dom';
import Layout from '../../components/Layout';
import { clientLinks } from './clientLinks';

const ClientLayout = () => {
    const user = JSON.parse(sessionStorage.getItem('user') || '{}');

    return (
        <Layout
            links={clientLinks}
            userType="CLIENT"
            userName={user.name || 'Cliente'}
            userPhoto="https://ui-avatars.com/api/?name=Client+User&background=0D8ABC&color=fff"
        >
            <Outlet />
        </Layout>
    );
};

export default ClientLayout;
