import { Outlet } from 'react-router-dom';
import Layout from '../../components/Layout';
import { employeeLinks } from './employeeLinks';

const EmployeeLayout = () => {
    const user = JSON.parse(sessionStorage.getItem('user') || '{}');

    return (
        <Layout
            links={employeeLinks}
            userType="EMPLOYEE"
            userName={user.email || 'Empleado'}
            userPhoto="https://ui-avatars.com/api/?name=Employee+User&background=0D8ABC&color=fff"
        >
            <Outlet />
        </Layout>
    );
};

export default EmployeeLayout;
