import {
  Box,
  Text
} from '@chakra-ui/react';
import Layout from '../../components/Layout';
import Calendar from '../../components/Calendar';
import { mockClases, mockAlumnos, mockMaterias, mockBitacoras, mockProfesores } from '../../data/mockData';

const padreLinks = [
  { nombre: 'Dashboard', path: '/padre' },
  { nombre: 'Avance (Bitácoras)', path: '/padre/bitacoras' },
  { nombre: 'Metas', path: '/padre/metas' },
  { nombre: 'Pagos', path: '/padre/pagos' },
  { nombre: 'Calendario', path: '/padre/calendario' },
  { nombre: 'Notificaciones', path: '/padre/notificaciones' }
];

const padreId = 1;
const misHijos = mockAlumnos.filter(a => a.id_padre === padreId);
const misClases = mockClases.filter(c => misHijos.some(h => h.id === c.id_alumno));

const CalendarioPadre = () => {
  // Enriquecer las clases con información completa
  const clasesEnriquecidas = misClases.map(clase => ({
    ...clase,
    profesor: mockProfesores.find(p => p.id === clase.id_profesor),
    alumno: mockAlumnos.find(a => a.id === clase.id_alumno),
    materia: mockMaterias.find(m => m.id === clase.id_materia)
  }));

  // Bitácoras de los hijos
  const bitacorasHijos = mockBitacoras.filter(b => misHijos.some(h => h.id === b.id_alumno));

  return (
    <Layout links={padreLinks} userType="Padre/Tutor" userName="Roberto López">
      <Box mb={4}>
        <Text fontSize="sm" color="gray.600" mb={6}>
          Visualiza las clases de tus hijos. <strong>El calendario muestra horarios</strong> y bitácoras registradas.
        </Text>
      </Box>
      <Calendar 
        clases={clasesEnriquecidas} 
        bitacoras={bitacorasHijos}
        alumnos={misHijos}
        userType="padre" 
      />
    </Layout>
  );
};

export default CalendarioPadre;

