import { Outlet } from 'react-router-dom';
import Layout from '../../components/Layout';
import { rootLinks } from './rootLinks';

const RootLayout = () => {
    // En una implementación real, estos datos vendrían del contexto de autenticación
    const user = JSON.parse(sessionStorage.getItem('user') || '{}');

    return (
        <Layout
            links={rootLinks}
            userType="ROOT"
            userName={user.email || 'Super Usuario'}
            userPhoto="https://ui-avatars.com/api/?name=Root+User&background=0D8ABC&color=fff"
        >
            <Outlet />
        </Layout>
    );
};

export default RootLayout;
