import { defineConfig } from 'vite';
import react from '@vitejs/plugin-react';

export default defineConfig({
  plugins: [react()],
  server: {
    port: 8081,
    allowedHosts: ['keservicios.kemarketing.mx'],
    proxy: {
      '/api': {
        target: 'https://keservicios.kemarketing.mx/api',
        changeOrigin: true,
      },
    },
  },
  build: {
    chunkSizeWarningLimit: 1000,
  },
});

