# Archivos para Actualizar en Producción

## 📋 Resumen
Este documento lista todos los archivos que deben actualizarse en producción para corregir los errores de login y compatibilidad con la base de datos.

---

## 🔴 Archivos CRÍTICOS (Actualizar Inmediatamente)

### 1. **src/models/user.js**
**Razón:** Corrige el error de login al manejar dinámicamente `institution_id` vs `company_id` y campos de nombre.
**Cambios principales:**
- Método `getByEmail()`: Detecta y usa la columna correcta (`institution_id` o `company_id`)
- Método `getAll()`: Manejo dinámico de columnas
- Método `getById()`: Manejo dinámico de columnas
- Método `getAdminsByInstitutionId()`: Usa la columna correcta en WHERE
- Todos los métodos mapean ambas columnas para compatibilidad

**Ubicación en producción:** `/var/www/html/kequiz/src/models/user.js`

---

### 2. **src/models/exam.js**
**Razón:** Corrige consultas que construyen nombres de profesores/estudiantes dinámicamente.
**Cambios principales:**
- Método `getAll()`: Detecta campos de nombre disponibles antes de construir `professor_name`
- Método `getAssignments()`: Detecta campos de nombre disponibles antes de construir `student_name`
- Manejo de errores mejorado

**Ubicación en producción:** `/var/www/html/kequiz/src/models/exam.js`

---

### 3. **src/models/institution.js**
**Razón:** Corrige el error "relation 'institutions' does not exist" al manejar dinámicamente `institutions` vs `companies`.
**Cambios principales:**
- Método `getAll()`: Detecta qué tabla existe (`institutions` o `companies`) y la usa
- Método `getById()`: Fallback a `companies` si `institutions` no existe
- Método `create()`: Intenta con `institutions`, fallback a `companies`
- Método `update()`: Intenta con `institutions`, fallback a `companies`
- Método `delete()`: Intenta con `institutions`, fallback a `companies`
- Mapeo de columnas: `id_institution` vs `id` según la tabla

**Ubicación en producción:** `/var/www/html/kequiz/src/models/institution.js`

---

## 🟡 Archivo SQL (Opcional - Solo si se recrea la BD)

### 3. **sql/kequiz_production.sql**
**Razón:** Archivo SQL completo para crear la base de datos desde cero con todas las migraciones integradas.
**Cuándo usar:**
- Solo si necesitas recrear la base de datos completa
- Contiene todas las migraciones integradas
- Incluye todos los permisos para el usuario `iger`

**⚠️ ADVERTENCIA:** Este archivo contiene `DROP TABLE IF EXISTS`, por lo que eliminará todos los datos existentes.

**Ubicación:** `/var/www/html/kequiz/sql/kequiz_production.sql`

---

## ✅ Archivos que NO necesitan actualización

Los siguientes archivos ya tienen la lógica correcta y NO necesitan cambios:
- `src/models/question.js` - Ya maneja campos de nombre dinámicamente
- `src/models/institution.js` - No requiere cambios
- `src/models/specialty.js` - No requiere cambios
- Otros modelos - No requieren cambios

---

## 📝 Instrucciones de Despliegue

### Paso 1: Hacer Backup
```bash
# Backup de la base de datos
pg_dump -U iger -d kequiz_production > backup_$(date +%Y%m%d_%H%M%S).sql

# Backup de los archivos actuales
cp /var/www/html/kequiz/src/models/user.js /var/www/html/kequiz/src/models/user.js.backup
cp /var/www/html/kequiz/src/models/exam.js /var/www/html/kequiz/src/models/exam.js.backup
cp /var/www/html/kequiz/src/models/institution.js /var/www/html/kequiz/src/models/institution.js.backup
```

### Paso 2: Actualizar Archivos
```bash
# Copiar archivos actualizados
scp src/models/user.js usuario@servidor:/var/www/html/kequiz/src/models/
scp src/models/exam.js usuario@servidor:/var/www/html/kequiz/src/models/
scp src/models/institution.js usuario@servidor:/var/www/html/kequiz/src/models/
```

O si estás en el servidor:
```bash
cd /var/www/html/kequiz
# Reemplazar los archivos con las versiones actualizadas
```

### Paso 3: Reiniciar la Aplicación
```bash
# Si usas PM2
pm2 restart kequizB

# O si usas otro gestor de procesos
# Reiniciar el servicio Node.js según corresponda
```

### Paso 4: Verificar
```bash
# Verificar logs
pm2 logs kequizB --lines 50

# Probar login
# Intentar iniciar sesión y verificar que funciona correctamente
```

---

## 🔍 Verificación Post-Despliegue

1. ✅ **Login funciona:** Intentar iniciar sesión con un usuario existente
2. ✅ **Sin errores en logs:** Revisar que no aparezcan errores de columnas faltantes
3. ✅ **Consultas funcionan:** Verificar que las listas de usuarios, exámenes, etc. se muestran correctamente

---

## 📞 Soporte

Si encuentras problemas después del despliegue:
1. Revisar los logs: `pm2 logs kequizB`
2. Verificar que los archivos se copiaron correctamente
3. Verificar permisos de archivos
4. Restaurar backups si es necesario

---

## 📅 Fecha de Actualización
**Última actualización:** $(date)
**Versión:** Compatible con base de datos que usa `company_id` o `institution_id`

