# Documentación de Adaptación: KeQuiz

Este documento resume las adecuaciones técnicas realizadas para transformar el sistema **KeServicios** en la plataforma educativa **KeQuiz**.

## 1. Base de Datos (PostgreSQL)

Se realizó una transición controlada del esquema de base de datos:
- **Script Consolidado**: Se creó `sql/kequiz_production.sql` que incluye el esquema multi-tenant y las nuevas tablas académicas.
- **Nuevas Tablas**:
  - `question_bank`: Almacena preguntas con soporte para tipos Multiselección y V/F utilizando JSONB para el contenido.
  - `exams`: Configuración de evaluaciones con parámetros de tiempo y aleatorización.
  - `exam_assignments`: Gestión de la relación estudiante-examen y seguimiento de progreso.
  - `exam_logs`: Auditoría detallada para la supervisión en tiempo real (Focus lost, Tab change).

## 2. Backend (Node.js / Express)

- **Modularización**: Se refactorizó `server/index.js`, moviendo la lógica masiva a rutas modulares en `server/routes/` (`auth.js`, `users.js`, `institutions.js`, `exams.js`, `questions.js`).
- **Supervisión en Tiempo Real**: Se integró **Socket.io** para manejar eventos de exámenes en vivo.
- **Modelos**: Se crearon nuevos modelos en `src/models/` (`exam.js`, `question.js`, `institution.js`) alineados con el nuevo esquema.

## 3. Frontend (React / Vite)

- **Identidad Visual**: Se actualizó `src/theme.js` con la paleta de colores Indigo 600 y Slate 50.
- **Refactorización de Roles**:
  - `Employee` -> `Professor`
  - `Client` -> `Student`
- **Nuevos Módulos**:
  - **Exam Builder**: Interfaz para que los profesores creen exámenes seleccionando preguntas del banco.
  - **Lockdown UI**: Interfaz de aplicación de examen con detección de pérdida de foco y cambio de pestaña vía WebSockets.
  - **Live Monitor**: Tablero para profesores para supervisar incidencias de estudiantes en tiempo real.
- **Rutas**: Se actualizaron todas las rutas en `src/App.jsx` y los enlaces en los Sidebars.

## 4. Mejoras Recientes y Correcciones
- **Login Unificado**: Se centralizó el acceso de todos los roles en `LoginPage.jsx`, eliminando la dependencia de paneles separados.
- **Compatibilidad Legacy**: Se implementó una capa de mapeo extensa en `src/services/api.js` y en los modelos de base de datos para asegurar que los componentes existentes sigan funcionando durante la transición de IDs de cadena a IDs enteros.
- **Dashboard Root**: Se corrigió la visualización de estadísticas (Empresas, Usuarios) mediante el uso de alias en las consultas SQL para compatibilidad con el frontend.
- **Configuración de Producción**: Se ajustó la detección de entorno en `src/services/api.js` para soportar tanto el proxy de desarrollo como la URL final de producción `kequiz.kemarketing.mx`.

## 5. Limpieza (Cleanup)
- Se eliminaron archivos legacy de KeServicios, incluyendo scripts de migración antiguos y páginas administrativas de órdenes de servicio y catálogos técnicos (`AsignacionClases.jsx`, `OrdenesServicio.jsx`, `LoginPanel.jsx`).
- Se actualizaron los servicios de API en `src/services/api.js` para apuntar a los nuevos endpoints modulares.

---
**Fecha de Adaptación**: 05 de Enero de 2026
**Estado**: Completado y en fase de pruebas.

