# Documentación de Cambios: Implementación de Modelos de Base de Datos

## Resumen
Se ha implementado la capa de acceso a datos utilizando PostgreSQL para reemplazar el uso de datos mock en el futuro. Se han creado modelos para todas las entidades principales del sistema, permitiendo operaciones CRUD completas.

## Configuración de Conexión
**Archivo**: `src/models/database.js`
- **Host**: 172.16.215.130
- **Puerto**: 5432
- **Usuario**: iger
- **Base de Datos**: keservicios
- **Tecnología**: `pg` (node-postgres) con Pool de conexiones.

## Modelos Implementados

### 1. CompanyModel (`src/models/company.js`)
Gestiona las empresas inquilinas.
- `getAll()`: Obtiene todas las empresas.
- `getById(id)`: Obtiene una empresa por ID.
- `create(company)`: Crea una nueva empresa.
- `update(id, company)`: Actualiza datos de una empresa.
- `delete(id)`: Elimina una empresa (lógica o física).

### 2. UserModel (`src/models/user.js`)
Gestiona los usuarios del sistema (ROOT, ADMIN, EMPLOYEE, CLIENT).
- `getAll()`: Lista todos los usuarios.
- `getById(id)`: Busca usuario por ID.
- `getByEmail(email)`: Busca usuario por correo (útil para login).
- `create(user)`: Registra nuevo usuario.
- `update(id, user)`: Actualiza usuario.
- `delete(id)`: Elimina usuario.

### 3. ClientModel (`src/models/client.js`)
Gestiona los perfiles extendidos de clientes.
- `getByUserId(userId)`: Obtiene perfil de cliente por ID de usuario.
- `create(client)`: Crea perfil de cliente.
- `update(id, client)`: Actualiza perfil.

### 4. EmployeeModel (`src/models/employee.js`)
Gestiona los perfiles extendidos de empleados.
- `getByUserId(userId)`: Obtiene perfil de empleado por ID de usuario.
- `create(employee)`: Crea perfil de empleado.
- `update(id, employee)`: Actualiza perfil.

### 5. ServiceModel (`src/models/service.js`)
Gestiona el catálogo de servicios por empresa.
- `getByCompanyId(companyId)`: Obtiene servicios de una empresa.
- `create(service)`: Agrega servicio al catálogo.
- `update(id, service)`: Modifica servicio.
- `delete(id)`: Elimina servicio.

### 6. OrderModel (`src/models/order.js`)
Gestiona las órdenes de servicio (contracted_services).
- `getByCompanyId(companyId)`: Órdenes de una empresa.
- `getByClientId(clientId)`: Órdenes de un cliente.
- `getByEmployeeId(employeeId)`: Órdenes asignadas a un empleado.
- `create(order)`: Crea nueva orden.
- `update(id, order)`: Actualiza estado y detalles de la orden.

### 7. EvidenceModel (`src/models/evidence.js`)
Gestiona las evidencias multimedia.
- `getByServiceId(serviceId)`: Obtiene evidencias de una orden.
- `create(evidence)`: Sube referencia a nueva evidencia.
- `delete(id)`: Elimina evidencia.

### 8. ModuleModel (`src/models/module.js`)
Gestiona la activación de módulos por empresa.
- `getByCompanyId(companyId)`: Lista módulos y su estado para una empresa.
- `toggleModule(companyId, moduleId, isEnabled)`: Activa/desactiva un módulo.

### 9. SystemConfigModel (`src/models/systemConfig.js`)
Gestiona la configuración global del sistema.
- `getByKey(key)`: Obtiene valor de configuración.
- `set(key, value)`: Establece valor de configuración.

## Notas de Implementación
- Los modelos utilizan consultas parametrizadas para prevenir inyección SQL.
- Se utiliza un Pool de conexiones para manejar eficientemente la concurrencia.
- **Importante**: Estos modelos están diseñados para ejecutarse en un entorno de servidor (Node.js). Para integrarlos con el frontend React actual, se requiere implementar una API (REST o GraphQL) que exponga estas funciones, ya que el navegador no puede conectarse directamente a la base de datos PostgreSQL por razones de seguridad y técnicas.

## Próximos Pasos
1. Configurar servidor Express/Node.js.
2. Crear endpoints API que utilicen estos modelos.
3. Actualizar el frontend para consumir la API en lugar de `mockData.js`.
