# Documentación de Arquitectura del Sistema

## Introducción
Este documento describe la arquitectura del sistema Keservicios, detallando la estructura de carpetas, la separación de responsabilidades y la integración entre el frontend y el backend.

## Configuración de Entornos

El sistema está diseñado para alternar fácilmente entre un entorno de desarrollo local y uno de producción profesional.

### Entorno de Desarrollo (Local)
Para trabajar en local, se deben seguir estas configuraciones:

1.  **Base de Datos (`src/models/database.js`)**:
    *   Asegurarse de que el bloque `// Configuración de Pruebas` esté activo (descomentado).
    *   La IP predeterminada para el servidor local de base de datos es `172.16.168.128`.
2.  **API Client (`src/services/api.js`)**:
    *   `const isProduction = false;` debe estar forzado para que el frontend apunte a `http://localhost:8081`.
3.  **Servidor (`server/index.js`)**:
    *   La escucha se realiza en `localhost` puerto `8081`.
    *   La redirección HTTPS debe permanecer comentada.
4.  **Ejecución**:
    *   Backend: `npm run server`
    *   Frontend: `npm run dev`

### Entorno de Producción
Para el despliegue en el dominio `https://keservicios.kemarketing.mx`, se deben aplicar estos cambios:

1.  **Backend (PM2)**:
    *   Configurar `src/models/database.js` con el bloque `// Configuración de Producción` (host `127.0.0.1`).
    *   Activar el middleware de redirección HTTPS en `server/index.js`.
    *   Cambiar el host de escucha a `0.0.0.0`.
    *   Comando de inicio: `PORT=8081 pm2 start server/index.js --name "backend-keservicios"`
2.  **Frontend (Nginx)**:
    *   Configurar `src/services/api.js` con `const isProduction = true;`.
    *   Generar build: `npm run build`.
    *   Nginx debe servir la carpeta `dist/` y actuar como proxy inverso para la ruta `/api` hacia `http://localhost:8081`.

---

## Estructura del Proyecto

La estructura del proyecto se ha organizado para separar claramente el frontend del backend, facilitando el mantenimiento y la escalabilidad.

### Directorios Principales

- **/src**: Contiene el código fuente de la aplicación.
  - **/components**: Componentes reutilizables de React.
  - **/pages**: Vistas y páginas de la aplicación.
  - **/models**: Modelos de datos y lógica de acceso a la base de datos (Backend).
  - **/services**: Lógica de negocio y comunicación con la API.
  - **/utils**: Funciones utilitarias y helpers.
  - **/assets**: Recursos estáticos como imágenes y estilos.

- **/Documentacion**: Contiene la documentación del proyecto.
  - `documentacion.md`: Este archivo.
  - `cambioBaseDeDatos.md`: Documentación específica de los cambios en la base de datos.

## Arquitectura Frontend-Backend

### Frontend (React + Vite)
El frontend es una aplicación de una sola página (SPA) construida con React y Vite. Se encarga de la interfaz de usuario y la interacción con el usuario.

- **Componentes**: Construidos con Chakra UI para una interfaz moderna y responsiva.
- **Enrutamiento**: React Router DOM maneja la navegación entre páginas.
- **Estado**: Gestión del estado local y global (contexto o librerías de estado si es necesario).

### Backend (Node.js + PostgreSQL)
El backend maneja la lógica de negocio y la persistencia de datos.

- **Modelos**: Ubicados en `src/models`, encapsulan las consultas SQL y la interacción directa con la base de datos PostgreSQL.
- **Conexión**: `src/models/database.js` gestiona la conexión a la base de datos utilizando `pg` (node-postgres).

### Módulo de "Solicitar Servicio"
- **Filtrado por Empresa**: El cliente ahora solo visualiza los servicios que su empresa asignada (inquilina) ofrece, filtrados por `company_id`.
- **Dirección**: Se incluye un campo para especificar la dirección del servicio.

### Registro de Pagos
- **Referencia de Pago**: Se agregó un campo obligatorio para ingresar la referencia bancaria/folio del pago.
- **Estado de Pago**:
    - `PENDING`: Estado inicial.
    - `REVIEW`: Cuando el cliente sube el comprobante.
    - `REJECTED`: Si el admin rechaza el pago (se habilita botón "Modificar Comprobante").
    - `ACCEPTED`: Pago validado.

### Panel Administrativo (Dashboard)
- **Confirmación de Solicitudes**: Alerta visual para solicitudes nuevas sin asignar.
- **Detección de Conflictos**: Al asignar un empleado, el sistema valida si ya tiene órdenes activas en el mismo rango de fechas `(StartA <= EndB) and (EndA >= StartB)`. Muestra una advertencia permitiendo confirmar o cancelar.

## Flujo de Datos

1. **Usuario**: Interactúa con la interfaz de usuario (Frontend).
2. **Frontend**: Realiza solicitudes a la API (simulada o real) para obtener o enviar datos.
3. **API/Backend**: Procesa las solicitudes, valida datos y utiliza los modelos para interactuar con la base de datos.
4. **Base de Datos**: Almacena y recupera la información solicitada.
5. **Respuesta**: El backend envía la respuesta al frontend, que actualiza la interfaz de usuario.

## Cambios Recientes

- Se han creado modelos para `Company`, `User`, `Client`, `Employee`, `Service`, `Order`, `Evidence`, `Module` y `SystemConfig`.
- Se ha configurado la conexión a la base de datos PostgreSQL.
- Se ha documentado la nueva estructura y los modelos implementados.
- **[2024-05-21]** Implementación de campo `email` en tabla `clients` y soporte en frontend/backend.
- **[2024-05-21]** Implementación de campo `is_active` en tabla `clients` y corrección de lógica de actualización.
- **[2024-05-21]** Inclusión de campo `fiscal_address` en formulario de gestión de clientes.
- **[2025-01-03]** Implementación de subida de logos para empresas con almacenamiento dinámico (`uploads/{id}`).
- **[2025-01-03]** Generación y configuración de `favicon.ico` transparente basado en el logo de la empresa.
- **[2025-01-03]** Mejora en `CalendarioTrabajo.jsx`: inclusión de vista mensual (cuadrícula Lun-Dom), selector de vistas y **modal de detalles completo** (gestión de estatus y evidencias).
- **[2025-01-03]** Nueva página `PerfilEmpleado.jsx`: exclusiva para cambio de contraseña con validación estricta.
- **[2025-01-03]** Sistema de Notificaciones: Implementación de tabla `notifications`, endpoints de API, y lógica de triggers. UI integrada en el Layout.
- **[2025-01-03]** Gestión de fotografías de empleados: Implementación de carga de fotos en `GestionEmpleados.jsx` con validación de dimensiones (160px a 900px) y visualización en el dashboard de clientes.
- **[2025-01-03]** Mejora en `Reportes.jsx`: Inclusión de gráfico de áreas para visualizar la evolución de servicios por tipo durante el año en curso.
- **[2025-01-03]** Reportes Gerenciales (Root): Implementación de panel de estadísticas por empresa con cálculo de almacenamiento real en disco.
- **[2025-01-03]** Gestión de Límites: Implementación de límites de clientes y empleados por empresa, configurables por el usuario Root desde la gestión de empresas.

## Próximos Pasos
- Implementar una API RESTful o GraphQL para exponer los modelos al frontend.
- Migrar la lógica de negocio del frontend al backend donde sea apropiado.
- Implementar pruebas unitarias y de integración para asegurar la robustez del sistema.
