# Implementación del Backend (API REST)

## Resumen
Se ha implementado un servidor Express.js básico para exponer los modelos de base de datos a través de una API RESTful. Esto permite que el frontend interactúe con la base de datos PostgreSQL real.

## Cambios Realizados

### 1. Dependencias
Se instalaron las siguientes dependencias:
- `express`: Framework web para Node.js.
- `cors`: Middleware para permitir peticiones desde el frontend (Cross-Origin Resource Sharing).
- `dotenv`: Para manejo de variables de entorno (preparación).

### 2. Servidor (`server/index.js`)
Se creó el punto de entrada del servidor que configura Express y define los endpoints de la API.

#### Endpoints Implementados:

- **GET /api/companies**: Obtiene todas las empresas.
- **GET /api/companies/:id**: Obtiene una empresa por ID.
- **GET /api/users**: Obtiene todos los usuarios.
- **POST /api/users**: Crea un nuevo usuario.
- **GET /api/clients**: Obtiene todos los clientes.
- **GET /api/employees**: Obtiene todos los empleados.
- **GET /api/services**: Obtiene todos los servicios.
- **GET /api/companies/:companyId/services**: Obtiene servicios de una empresa específica.
- **GET /api/orders**: Obtiene todas las órdenes de servicio.
- **POST /api/orders**: Crea una nueva orden.
- **GET /api/config/:key**: Obtiene una configuración del sistema por clave.

### 3. Scripts
Se añadió el script `"server": "node server/index.js"` al `package.json` para ejecutar el backend.

## Cómo Ejecutar

1. **Iniciar Base de Datos**: Asegurarse de que PostgreSQL esté corriendo y accesible.
2. **Iniciar Backend**:
   ```bash
   npm run server
   ```
   El servidor escuchará en el puerto 3000 (http://localhost:3000).
3. **Iniciar Frontend**:
   ```bash
   npm run dev
   ```
   El frontend correrá en el puerto 5173.

## Próximos Pasos

1. **Consumir API en Frontend**: Modificar los componentes de React para hacer fetch a estos endpoints en lugar de usar `mockData.js`.
2. **Autenticación**: Implementar login real y protección de rutas (JWT).
3. **Validación**: Añadir validación de datos en los endpoints POST/PUT.
4. **Manejo de Errores**: Mejorar el manejo de errores y respuestas HTTP.
