# Preparación del Repositorio - KeQuiz

## 📋 Instrucciones para Subir el Proyecto a GitHub

### Paso 1: Eliminar Git Actual (si existe)

```bash
# Eliminar el directorio .git existente
rm -rf .git
```

### Paso 2: Inicializar Nuevo Repositorio Git

```bash
# Inicializar repositorio
git init

# Agregar el remoto
git remote add origin https://github.com/igerfv/kequiz.git
```

### Paso 3: Verificar Archivos a Ignorar

El archivo `.gitignore` ya está configurado para ignorar:
- `node_modules/`
- `dist/`
- `.env` y archivos de configuración local
- `logs/`
- `uploads/`
- Archivos de backup
- Archivos del sistema operativo

### Paso 4: Agregar Archivos al Repositorio

```bash
# Agregar todos los archivos
git add .

# Verificar qué se va a subir (opcional)
git status

# Hacer el primer commit
git commit -m "Initial commit: KeQuiz - Sistema de Evaluaciones"
```

### Paso 5: Subir al Repositorio

```bash
# Cambiar a la rama main (si es necesario)
git branch -M main

# Subir al repositorio
git push -u origin main
```

## ⚠️ Archivos que NO se Subirán (por .gitignore)

- `node_modules/` - Dependencias (se instalan con `npm install`)
- `dist/` - Build de producción (se genera con `npm run build`)
- `.env` - Variables de entorno (usar `.env.example` como plantilla)
- `logs/` - Archivos de log
- `uploads/` - Archivos subidos por usuarios
- Archivos de backup SQL comprimidos

## 📝 Archivos Importantes que SÍ se Subirán

- ✅ Todo el código fuente (`src/`, `server/`)
- ✅ Archivos SQL de producción y migraciones (`sql/`)
- ✅ Scripts de utilidad (`scripts/`)
- ✅ Configuración de Vite (`vite.config.js`)
- ✅ `package.json` y `package-lock.json`
- ✅ `.env.example` (plantilla de configuración)
- ✅ Documentación (`Documentacion/`, `README.md`)
- ✅ Archivos de configuración del proyecto

## 🔐 Seguridad

**IMPORTANTE**: Antes de subir, verifica que:
- ❌ No hay contraseñas hardcodeadas en el código
- ❌ No hay archivos `.env` con credenciales reales
- ❌ No hay tokens o API keys expuestos
- ✅ El archivo `.env.example` está actualizado

## 📦 Después de Clonar

Cuando alguien clone el repositorio:

```bash
# 1. Instalar dependencias
npm install

# 2. Copiar archivo de ejemplo de variables de entorno
cp .env.example .env

# 3. Editar .env con las credenciales correctas
nano .env  # o usar tu editor preferido

# 4. Ejecutar el SQL de producción
psql -U iger -d kequiz -f sql/kequiz_production.sql

# 5. Iniciar el servidor
npm run server

# 6. En otra terminal, iniciar el frontend
npm run dev
```

## 🚀 Comandos Completos (Copy-Paste)

```bash
# Eliminar git actual
rm -rf .git

# Inicializar nuevo repositorio
git init
git remote add origin https://github.com/igerfv/kequiz.git

# Agregar archivos
git add .

# Commit inicial
git commit -m "Initial commit: KeQuiz - Sistema de Evaluaciones"

# Subir al repositorio
git branch -M main
git push -u origin main
```

