# Sistema de Evaluaciones para Personal Especializado (KeQuiz)

Sistema integral de gestión escolar fullstack desarrollado con **React** (Frontend), **Node.js/Express** (Backend) y **PostgreSQL** (Base de Datos). Diseñado para administrar escuelas de arte, incluyendo gestión de alumnos, profesores, clientes, empleados, exámenes, bitácoras y pagos.

## 🚀 Características Principales

*   **Arquitectura Fullstack**: Separación clara entre cliente (Vite/React) y servidor (Express).
*   **Base de Datos Relacional**: Persistencia de datos robusta utilizando PostgreSQL.
*   **Autenticación Segura**: Sistema de login basado en JWT (JSON Web Tokens) con roles diferenciados.
*   **Roles de Usuario**: Soporte para múltiples perfiles:
    *   **Root/Admin**: Control total del sistema.
    *   **Profesor**: Gestión de alumnos, clases y exámenes.
    *   **Alumno**: Acceso a bitácoras, exámenes y progreso.
    *   **Padre/Tutor**: Monitoreo de hijos y pagos.
    *   **Cliente/Empleado**: Módulos específicos para gestión corporativa.
*   **Exámenes en Tiempo Real**: Funcionalidad de exámenes con monitoreo en vivo (Socket.io) para detectar cambios de pestaña o pérdida de foco.
*   **Gestión de Archivos**: Subida de evidencias (fotos, videos) y logos institucionales.
*   **Interfaz Moderna**: UI construida con **Chakra UI** para un diseño responsivo y accesible.

## 📦 Tecnologías

### Frontend
*   **React** `^18.2.0`
*   **Vite** `^5.0.8`
*   **Chakra UI** `^2.8.2`
*   **React Router DOM** `^6.20.0`
*   **Socket.io Client** `^4.8.3`

### Backend
*   **Node.js** & **Express** `^5.2.1`
*   **PostgreSQL** (`pg`)
*   **Socket.io** (Websockets para tiempo real)
*   **JWT** (Autenticación)
*   **Multer** (Carga de archivos)
*   **Bcryptjs** (Hashing de contraseñas)

## 📁 Estructura del Proyecto

```
/
├── server/                 # Lógica del Backend (Express)
│   ├── index.js            # Punto de entrada del servidor
│   ├── routes/             # Definición de rutas API
│   └── utils/              # Utilidades del servidor (upload, etc.)
│
├── src/                    # Código Fuente del Frontend (React)
│   ├── components/         # Componentes reutilizables UI
│   ├── models/             # Modelos de base de datos (compartidos/usados por backend)
│   ├── pages/              # Vistas por rol (admin, student, professor, etc.)
│   ├── services/           # Cliente API frontend
│   └── utils/              # Utilidades frontend
│
├── sql/                    # Scripts SQL y migraciones
├── public/                 # Assets estáticos
└── scripts/                # Scripts de mantenimiento y verificación
```

## 🛠️ Instalación y Configuración

1.  **Requisitos Previos**:
    *   Node.js (v18+)
    *   PostgreSQL

2.  **Configuración de Variables de Entorno**:
    Crea un archivo `.env` en la raíz con las siguientes variables:
    ```env
    DB_USER=tu_usuario
    DB_HOST=localhost
    DB_DATABASE=kequiz_db
    DB_PASSWORD=tu_password
    DB_PORT=5432
    JWT_SECRET=tu_secreto_super_seguro
    PORT=3000
    ```

3.  **Instalar Dependencias**:
    ```bash
    npm install
    ```

## 🚀 Ejecución

El proyecto requiere ejecutar tanto el backend como el frontend.

### 1. Iniciar Servidor (Backend)
```bash
npm run server
```
El servidor escuchará en el puerto definido (por defecto `3000` o `8081`).

### 2. Iniciar Cliente (Frontend)
 En una terminal separada:
```bash
npm run dev
```
La aplicación web estará disponible en `http://localhost:5173`.

## 🔐 Módulos del Sistema

### Administración (`/admin`)
*   Dashboard general.
*   Gestión de usuarios, profesores y alumnos.
*   Configuración de la empresa/institución.
*   Asignación de clases y materias.

### Profesor (`/professor`)
*   Creación y gestión de exámenes.
*   Monitoreo de exámenes en vivo (Live Monitor).
*   Bitácoras de clase.

### Estudiante (`/student`)
*   Realización de exámenes.
*   Consulta de historial y calificaciones.

### Funcionalidades Especiales
*   **Live Monitor**: Los profesores pueden ver el estado de los alumnos en tiempo real durante un examen (si están activos, si cambiaron de pestaña, etc.) usando WebSockets.
*   **Configuración Institucional**: Personalización de logo y textos a través del panel de admin.

## 📝 Scripts de Mantenimiento

En la carpeta `scripts/` encontrarás utilidades para:
*   `migrateData.js`: Migración de datos inicial.
*   `verify_database.js`: Verificación de integridad de la base de datos.
*   `backup_database.sh`: Generación de respaldos.

---
Desarrollado para **KeMarketing**.