/*
 Navicat Premium Data Transfer

 Source Server         : Posgres VM
 Source Server Type    : PostgreSQL
 Source Server Version : 170006 (170006)
 Source Host           : 172.16.168.128:5432
 Source Catalog        : kequiz
 Source Schema         : public

 Target Server Type    : PostgreSQL
 Target Server Version : 170006 (170006)
 File Encoding         : 65001

 Date: 09/01/2026 15:33:57
*/


-- ----------------------------
-- Sequence structure for exam_assignments_id_assignment_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."exam_assignments_id_assignment_seq";
CREATE SEQUENCE "public"."exam_assignments_id_assignment_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."exam_assignments_id_assignment_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for exam_logs_id_log_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."exam_logs_id_log_seq";
CREATE SEQUENCE "public"."exam_logs_id_log_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."exam_logs_id_log_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for exam_questions_id_exam_question_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."exam_questions_id_exam_question_seq";
CREATE SEQUENCE "public"."exam_questions_id_exam_question_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."exam_questions_id_exam_question_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for exam_responses_id_response_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."exam_responses_id_response_seq";
CREATE SEQUENCE "public"."exam_responses_id_response_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."exam_responses_id_response_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for exams_id_exam_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."exams_id_exam_seq";
CREATE SEQUENCE "public"."exams_id_exam_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."exams_id_exam_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for institutions_id_institution_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."institutions_id_institution_seq";
CREATE SEQUENCE "public"."institutions_id_institution_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."institutions_id_institution_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for modules_id_module_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."modules_id_module_seq";
CREATE SEQUENCE "public"."modules_id_module_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."modules_id_module_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for notifications_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."notifications_id_seq";
CREATE SEQUENCE "public"."notifications_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."notifications_id_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for question_bank_id_question_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."question_bank_id_question_seq";
CREATE SEQUENCE "public"."question_bank_id_question_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."question_bank_id_question_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for roles_id_role_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."roles_id_role_seq";
CREATE SEQUENCE "public"."roles_id_role_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."roles_id_role_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for users_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."users_id_seq";
CREATE SEQUENCE "public"."users_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."users_id_seq" OWNER TO "iger";

-- ----------------------------
-- Table structure for exam_assignments
-- ----------------------------
DROP TABLE IF EXISTS "public"."exam_assignments";
CREATE TABLE "public"."exam_assignments" (
  "id_assignment" int4 NOT NULL DEFAULT nextval('exam_assignments_id_assignment_seq'::regclass),
  "exam_id" int4 NOT NULL,
  "student_id" int4 NOT NULL,
  "status" varchar(50) COLLATE "pg_catalog"."default" DEFAULT 'PENDING'::character varying,
  "score" numeric(5,2),
  "started_at" timestamp(6),
  "finished_at" timestamp(6),
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "scheduled_at" timestamp(6),
  "scheduled_end_at" timestamp(6),
  "completed_at" timestamp(6),
  "attempt_number" int4 DEFAULT 1
)
;
ALTER TABLE "public"."exam_assignments" OWNER TO "iger";

-- ----------------------------
-- Records of exam_assignments
-- ----------------------------
BEGIN;
INSERT INTO "public"."exam_assignments" ("id_assignment", "exam_id", "student_id", "status", "score", "started_at", "finished_at", "created_at", "updated_at", "scheduled_at", "scheduled_end_at", "completed_at", "attempt_number") VALUES (8, 3, 6, 'COMPLETED', 5.00, '2026-01-06 12:02:12.65', NULL, '2026-01-06 11:52:51.002726', '2026-01-06 11:52:51.002726', '2026-01-06 11:54:00', NULL, '2026-01-06 12:02:32.465', 1);
INSERT INTO "public"."exam_assignments" ("id_assignment", "exam_id", "student_id", "status", "score", "started_at", "finished_at", "created_at", "updated_at", "scheduled_at", "scheduled_end_at", "completed_at", "attempt_number") VALUES (9, 3, 6, 'COMPLETED', 5.00, '2026-01-06 12:06:51.672', NULL, '2026-01-06 12:04:01.888015', '2026-01-06 12:04:01.888015', '2026-01-06 12:06:00', NULL, '2026-01-06 12:07:05.642', 2);
INSERT INTO "public"."exam_assignments" ("id_assignment", "exam_id", "student_id", "status", "score", "started_at", "finished_at", "created_at", "updated_at", "scheduled_at", "scheduled_end_at", "completed_at", "attempt_number") VALUES (10, 3, 6, 'COMPLETED', 10.00, '2026-01-06 12:13:55.927', NULL, '2026-01-06 12:10:21.439305', '2026-01-06 12:10:21.439305', '2026-01-06 12:12:00', NULL, '2026-01-06 12:15:36.774', 3);
INSERT INTO "public"."exam_assignments" ("id_assignment", "exam_id", "student_id", "status", "score", "started_at", "finished_at", "created_at", "updated_at", "scheduled_at", "scheduled_end_at", "completed_at", "attempt_number") VALUES (11, 4, 6, 'COMPLETED', 6.67, '2026-01-06 13:42:30.653', NULL, '2026-01-06 13:41:50.406759', '2026-01-06 13:41:50.406759', '2026-01-06 13:42:00', NULL, '2026-01-06 13:43:38.912', 1);
INSERT INTO "public"."exam_assignments" ("id_assignment", "exam_id", "student_id", "status", "score", "started_at", "finished_at", "created_at", "updated_at", "scheduled_at", "scheduled_end_at", "completed_at", "attempt_number") VALUES (12, 5, 6, 'COMPLETED', 10.00, '2026-01-06 23:16:49.222', NULL, '2026-01-06 23:14:49.756009', '2026-01-06 23:14:49.756009', '2026-01-06 23:16:00', NULL, '2026-01-06 23:17:48.681', 1);
INSERT INTO "public"."exam_assignments" ("id_assignment", "exam_id", "student_id", "status", "score", "started_at", "finished_at", "created_at", "updated_at", "scheduled_at", "scheduled_end_at", "completed_at", "attempt_number") VALUES (13, 5, 6, 'COMPLETED', 6.67, '2026-01-06 23:29:12.377', NULL, '2026-01-06 23:27:20.617259', '2026-01-06 23:27:20.617259', '2026-01-06 23:29:00', NULL, '2026-01-06 23:31:14.65', 2);
INSERT INTO "public"."exam_assignments" ("id_assignment", "exam_id", "student_id", "status", "score", "started_at", "finished_at", "created_at", "updated_at", "scheduled_at", "scheduled_end_at", "completed_at", "attempt_number") VALUES (14, 6, 14, 'COMPLETED', 6.67, '2026-01-09 01:08:41.008', NULL, '2026-01-09 01:06:46.666558', '2026-01-09 01:06:46.666558', '2026-01-09 01:08:00', NULL, '2026-01-09 01:08:58.704', 1);
COMMIT;

-- ----------------------------
-- Table structure for exam_logs
-- ----------------------------
DROP TABLE IF EXISTS "public"."exam_logs";
CREATE TABLE "public"."exam_logs" (
  "id_log" int4 NOT NULL DEFAULT nextval('exam_logs_id_log_seq'::regclass),
  "assignment_id" int4 NOT NULL,
  "event_type" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "event_data" jsonb,
  "timestamp" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."exam_logs" OWNER TO "iger";

-- ----------------------------
-- Records of exam_logs
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for exam_questions
-- ----------------------------
DROP TABLE IF EXISTS "public"."exam_questions";
CREATE TABLE "public"."exam_questions" (
  "id_exam_question" int4 NOT NULL DEFAULT nextval('exam_questions_id_exam_question_seq'::regclass),
  "exam_id" int4,
  "question_id" int4,
  "order_index" int4 DEFAULT 0
)
;
ALTER TABLE "public"."exam_questions" OWNER TO "iger";

-- ----------------------------
-- Records of exam_questions
-- ----------------------------
BEGIN;
INSERT INTO "public"."exam_questions" ("id_exam_question", "exam_id", "question_id", "order_index") VALUES (6, 3, 1, 0);
INSERT INTO "public"."exam_questions" ("id_exam_question", "exam_id", "question_id", "order_index") VALUES (7, 3, 3, 1);
INSERT INTO "public"."exam_questions" ("id_exam_question", "exam_id", "question_id", "order_index") VALUES (8, 4, 1, 0);
INSERT INTO "public"."exam_questions" ("id_exam_question", "exam_id", "question_id", "order_index") VALUES (9, 4, 3, 1);
INSERT INTO "public"."exam_questions" ("id_exam_question", "exam_id", "question_id", "order_index") VALUES (10, 4, 2, 2);
INSERT INTO "public"."exam_questions" ("id_exam_question", "exam_id", "question_id", "order_index") VALUES (11, 5, 1, 0);
INSERT INTO "public"."exam_questions" ("id_exam_question", "exam_id", "question_id", "order_index") VALUES (12, 5, 3, 1);
INSERT INTO "public"."exam_questions" ("id_exam_question", "exam_id", "question_id", "order_index") VALUES (13, 5, 2, 2);
INSERT INTO "public"."exam_questions" ("id_exam_question", "exam_id", "question_id", "order_index") VALUES (14, 6, 6, 0);
INSERT INTO "public"."exam_questions" ("id_exam_question", "exam_id", "question_id", "order_index") VALUES (15, 6, 4, 1);
INSERT INTO "public"."exam_questions" ("id_exam_question", "exam_id", "question_id", "order_index") VALUES (16, 6, 5, 2);
COMMIT;

-- ----------------------------
-- Table structure for exam_responses
-- ----------------------------
DROP TABLE IF EXISTS "public"."exam_responses";
CREATE TABLE "public"."exam_responses" (
  "id_response" int4 NOT NULL DEFAULT nextval('exam_responses_id_response_seq'::regclass),
  "assignment_id" int4,
  "question_id" int4,
  "student_answer" text COLLATE "pg_catalog"."default",
  "is_correct" bool,
  "points_earned" numeric(5,2) DEFAULT 0,
  "feedback" text COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "public"."exam_responses" OWNER TO "iger";

-- ----------------------------
-- Records of exam_responses
-- ----------------------------
BEGIN;
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1039, 8, 1, '1', 't', 1.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1043, 8, 3, '', 'f', 0.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1044, 9, 1, '1', 't', 1.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1047, 9, 3, '3', 'f', 0.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1056, 10, 1, '1', 't', 1.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1059, 10, 3, '4', 't', 1.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1064, 11, 1, '1', 't', 1.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1070, 11, 3, '3', 'f', 0.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1075, 11, 2, 'pesada', 't', 1.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1076, 12, 1, '1', 't', 1.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1082, 12, 3, '4', 't', 1.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1085, 12, 2, 'fuerza de atraccipin


', 't', 1.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1090, 13, 1, '1', 't', 1.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1093, 13, 3, '4', 't', 1.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1098, 13, 2, '', NULL, 0.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1099, 14, 6, '0', 't', 1.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1102, 14, 4, '1', 'f', 0.00, NULL);
INSERT INTO "public"."exam_responses" ("id_response", "assignment_id", "question_id", "student_answer", "is_correct", "points_earned", "feedback") VALUES (1105, 14, 5, '1', 't', 1.00, NULL);
COMMIT;

-- ----------------------------
-- Table structure for exams
-- ----------------------------
DROP TABLE IF EXISTS "public"."exams";
CREATE TABLE "public"."exams" (
  "id_exam" int4 NOT NULL DEFAULT nextval('exams_id_exam_seq'::regclass),
  "institution_id" int4 NOT NULL,
  "professor_id" int4 NOT NULL,
  "title" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "description" text COLLATE "pg_catalog"."default",
  "settings" jsonb,
  "is_active" bool DEFAULT true,
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "scheduled_at" timestamp(6),
  "scheduled_end_at" timestamp(6),
  "tolerance_minutes" int4 DEFAULT 15
)
;
ALTER TABLE "public"."exams" OWNER TO "iger";

-- ----------------------------
-- Records of exams
-- ----------------------------
BEGIN;
INSERT INTO "public"."exams" ("id_exam", "institution_id", "professor_id", "title", "description", "settings", "is_active", "created_at", "updated_at", "scheduled_at", "scheduled_end_at", "tolerance_minutes") VALUES (3, 1, 4, 'prueba 1', 'uno', '{"randomization": true, "timer_minutes": 2}', 't', '2026-01-05 22:24:50.136737', '2026-01-05 22:25:00.841368', NULL, NULL, 15);
INSERT INTO "public"."exams" ("id_exam", "institution_id", "professor_id", "title", "description", "settings", "is_active", "created_at", "updated_at", "scheduled_at", "scheduled_end_at", "tolerance_minutes") VALUES (4, 1, 4, 'prueba 2', 'La nat rerpuyeba', '{"randomization": true, "timer_minutes": 1}', 't', '2026-01-06 13:40:53.138788', '2026-01-06 13:40:53.138788', NULL, NULL, 15);
INSERT INTO "public"."exams" ("id_exam", "institution_id", "professor_id", "title", "description", "settings", "is_active", "created_at", "updated_at", "scheduled_at", "scheduled_end_at", "tolerance_minutes") VALUES (5, 1, 4, 'prueba 3', 'Es una prueba 3', '{"randomization": true, "timer_minutes": 2}', 't', '2026-01-06 23:14:00.46618', '2026-01-06 23:14:00.46618', NULL, NULL, 15);
INSERT INTO "public"."exams" ("id_exam", "institution_id", "professor_id", "title", "description", "settings", "is_active", "created_at", "updated_at", "scheduled_at", "scheduled_end_at", "tolerance_minutes") VALUES (6, 2, 13, 'Prueba 2', 'Prueba dos', '{"randomization": true, "timer_minutes": 3}', 't', '2026-01-09 01:03:53.354171', '2026-01-09 01:03:53.354171', NULL, NULL, 15);
COMMIT;

-- ----------------------------
-- Table structure for institution_modules
-- ----------------------------
DROP TABLE IF EXISTS "public"."institution_modules";
CREATE TABLE "public"."institution_modules" (
  "institution_id" int4 NOT NULL,
  "module_id" int4 NOT NULL,
  "is_enabled" bool DEFAULT true,
  "settings" jsonb
)
;
ALTER TABLE "public"."institution_modules" OWNER TO "iger";

-- ----------------------------
-- Records of institution_modules
-- ----------------------------
BEGIN;
INSERT INTO "public"."institution_modules" ("institution_id", "module_id", "is_enabled", "settings") VALUES (1, 1, 't', NULL);
INSERT INTO "public"."institution_modules" ("institution_id", "module_id", "is_enabled", "settings") VALUES (1, 2, 't', NULL);
INSERT INTO "public"."institution_modules" ("institution_id", "module_id", "is_enabled", "settings") VALUES (1, 3, 't', NULL);
INSERT INTO "public"."institution_modules" ("institution_id", "module_id", "is_enabled", "settings") VALUES (1, 4, 't', NULL);
INSERT INTO "public"."institution_modules" ("institution_id", "module_id", "is_enabled", "settings") VALUES (2, 2, 't', NULL);
INSERT INTO "public"."institution_modules" ("institution_id", "module_id", "is_enabled", "settings") VALUES (2, 3, 't', NULL);
INSERT INTO "public"."institution_modules" ("institution_id", "module_id", "is_enabled", "settings") VALUES (2, 4, 't', NULL);
INSERT INTO "public"."institution_modules" ("institution_id", "module_id", "is_enabled", "settings") VALUES (2, 1, 't', NULL);
COMMIT;

-- ----------------------------
-- Table structure for institutions
-- ----------------------------
DROP TABLE IF EXISTS "public"."institutions";
CREATE TABLE "public"."institutions" (
  "id_institution" int4 NOT NULL DEFAULT nextval('institutions_id_institution_seq'::regclass),
  "name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "rfc" varchar(20) COLLATE "pg_catalog"."default",
  "phone" varchar(50) COLLATE "pg_catalog"."default",
  "email" varchar(255) COLLATE "pg_catalog"."default",
  "fiscal_address" text COLLATE "pg_catalog"."default",
  "admin_user_id" int4,
  "logo_url" varchar(500) COLLATE "pg_catalog"."default",
  "tagline" varchar(500) COLLATE "pg_catalog"."default",
  "exam_footer" text COLLATE "pg_catalog"."default",
  "executive_contact" jsonb,
  "max_teachers" int4 DEFAULT 0,
  "max_students" int4 DEFAULT 0,
  "max_exams" int4 DEFAULT 0,
  "is_active" bool DEFAULT true,
  "settings" jsonb,
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "street" varchar(255) COLLATE "pg_catalog"."default",
  "exterior_number" varchar(50) COLLATE "pg_catalog"."default",
  "neighborhood" varchar(255) COLLATE "pg_catalog"."default",
  "municipality" varchar(255) COLLATE "pg_catalog"."default",
  "state" varchar(255) COLLATE "pg_catalog"."default",
  "postal_code" varchar(20) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "public"."institutions" OWNER TO "iger";

-- ----------------------------
-- Records of institutions
-- ----------------------------
BEGIN;
INSERT INTO "public"."institutions" ("id_institution", "name", "rfc", "phone", "email", "fiscal_address", "admin_user_id", "logo_url", "tagline", "exam_footer", "executive_contact", "max_teachers", "max_students", "max_exams", "is_active", "settings", "created_at", "updated_at", "street", "exterior_number", "neighborhood", "municipality", "state", "postal_code") VALUES (1, 'Sompo Seguros SA de CV', 'SOM123456RB9', '4444444444', 'contacto@sompo.com', NULL, NULL, NULL, NULL, NULL, NULL, 5, 50, 100, 't', NULL, '2026-01-05 12:33:47.354143', '2026-01-05 15:08:50.235887', 'san', '12', 'con', 'on', 'on', '02140');
INSERT INTO "public"."institutions" ("id_institution", "name", "rfc", "phone", "email", "fiscal_address", "admin_user_id", "logo_url", "tagline", "exam_footer", "executive_contact", "max_teachers", "max_students", "max_exams", "is_active", "settings", "created_at", "updated_at", "street", "exterior_number", "neighborhood", "municipality", "state", "postal_code") VALUES (2, 'Keel Intelligents.com', '', '5555555555', 'admin@demo.com', NULL, NULL, 'https://via.placeholder.com/150', NULL, NULL, NULL, 5, 10, 0, 't', NULL, '2026-01-08 19:27:54.757905', '2026-01-08 19:27:54.757905', '', '', '', '', '', '');
COMMIT;

-- ----------------------------
-- Table structure for modules
-- ----------------------------
DROP TABLE IF EXISTS "public"."modules";
CREATE TABLE "public"."modules" (
  "id_module" int4 NOT NULL DEFAULT nextval('modules_id_module_seq'::regclass),
  "code" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "name" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "description" text COLLATE "pg_catalog"."default",
  "is_active" bool DEFAULT true
)
;
ALTER TABLE "public"."modules" OWNER TO "iger";

-- ----------------------------
-- Records of modules
-- ----------------------------
BEGIN;
INSERT INTO "public"."modules" ("id_module", "code", "name", "description", "is_active") VALUES (1, 'EXAM_BUILDER', 'Constructor de Exámenes', 'Permite a los profesores crear exámenes personalizados', 't');
INSERT INTO "public"."modules" ("id_module", "code", "name", "description", "is_active") VALUES (2, 'LIVE_MONITOR', 'Monitor en Vivo', 'Supervisión en tiempo real de los estudiantes durante el examen', 't');
INSERT INTO "public"."modules" ("id_module", "code", "name", "description", "is_active") VALUES (3, 'QUESTION_BANK', 'Banco de Preguntas', 'Gestión centralizada de preguntas por categoría', 't');
INSERT INTO "public"."modules" ("id_module", "code", "name", "description", "is_active") VALUES (4, 'REPORTING', 'Reportes Avanzados', 'Estadísticas detalladas de rendimiento por estudiante e institución', 't');
COMMIT;

-- ----------------------------
-- Table structure for notifications
-- ----------------------------
DROP TABLE IF EXISTS "public"."notifications";
CREATE TABLE "public"."notifications" (
  "id" int4 NOT NULL DEFAULT nextval('notifications_id_seq'::regclass),
  "user_id" int4 NOT NULL,
  "type" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "title" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "message" text COLLATE "pg_catalog"."default",
  "is_read" bool DEFAULT false,
  "related_service_id" int4,
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."notifications" OWNER TO "iger";

-- ----------------------------
-- Records of notifications
-- ----------------------------
BEGIN;
INSERT INTO "public"."notifications" ("id", "user_id", "type", "title", "message", "is_read", "related_service_id", "created_at") VALUES (1, 6, 'EXAM_ASSIGNED', 'Nuevo examen asignado', 'Se te ha asignado el examen "prueba 1". Período de aplicación: por definir.', 't', 3, '2026-01-05 23:48:47.259103');
INSERT INTO "public"."notifications" ("id", "user_id", "type", "title", "message", "is_read", "related_service_id", "created_at") VALUES (2, 6, 'EXAM_ASSIGNED', 'Nuevo examen asignado', 'Se te ha asignado el examen "prueba 1". Período de aplicación: el 1/5/2026, 11:51:00 PM.', 't', 3, '2026-01-05 23:49:49.702227');
INSERT INTO "public"."notifications" ("id", "user_id", "type", "title", "message", "is_read", "related_service_id", "created_at") VALUES (3, 6, 'EXAM_ASSIGNED', 'Nuevo examen asignado', 'Se te ha asignado el examen "prueba 1". Período de aplicación: por definir.', 't', 3, '2026-01-06 00:39:43.807409');
INSERT INTO "public"."notifications" ("id", "user_id", "type", "title", "message", "is_read", "related_service_id", "created_at") VALUES (4, 6, 'EXAM_ASSIGNED', 'Nuevo examen asignado', 'Se te ha asignado el examen "prueba 1". Período de aplicación: el 1/6/2026, 12:41:00 AM.', 't', 3, '2026-01-06 00:40:04.54883');
INSERT INTO "public"."notifications" ("id", "user_id", "type", "title", "message", "is_read", "related_service_id", "created_at") VALUES (5, 6, 'EXAM_ASSIGNED', 'Nuevo examen asignado', 'Se te ha asignado el examen "prueba 1". Período de aplicación: el 1/6/2026, 11:54:00 AM.', 't', 3, '2026-01-06 11:52:51.044128');
INSERT INTO "public"."notifications" ("id", "user_id", "type", "title", "message", "is_read", "related_service_id", "created_at") VALUES (6, 6, 'EXAM_ASSIGNED', 'Nuevo examen asignado', 'Se te ha asignado el examen "prueba 1". Período de aplicación: por definir.', 't', 3, '2026-01-06 12:04:01.892863');
INSERT INTO "public"."notifications" ("id", "user_id", "type", "title", "message", "is_read", "related_service_id", "created_at") VALUES (7, 6, 'EXAM_ASSIGNED', 'Nuevo examen asignado', 'Se te ha asignado el examen "prueba 1". Período de aplicación: el 1/6/2026, 12:06:00 PM.', 't', 3, '2026-01-06 12:04:16.680765');
INSERT INTO "public"."notifications" ("id", "user_id", "type", "title", "message", "is_read", "related_service_id", "created_at") VALUES (8, 6, 'EXAM_ASSIGNED', 'Nuevo examen asignado', 'Se te ha asignado el examen "prueba 1". Período de aplicación: el 1/6/2026, 12:06:00 PM.', 't', 3, '2026-01-06 12:04:20.890143');
INSERT INTO "public"."notifications" ("id", "user_id", "type", "title", "message", "is_read", "related_service_id", "created_at") VALUES (9, 6, 'EXAM_ASSIGNED', 'Nuevo examen asignado', 'Se te ha asignado el examen "prueba 1". Período de aplicación: el 1/6/2026, 12:12:00 PM.', 't', 3, '2026-01-06 12:10:21.44322');
INSERT INTO "public"."notifications" ("id", "user_id", "type", "title", "message", "is_read", "related_service_id", "created_at") VALUES (10, 6, 'EXAM_ASSIGNED', 'Nuevo examen asignado', 'Se te ha asignado el examen "prueba 2". Período de aplicación: el 1/6/2026, 1:42:00 PM.', 't', 4, '2026-01-06 13:41:50.415115');
INSERT INTO "public"."notifications" ("id", "user_id", "type", "title", "message", "is_read", "related_service_id", "created_at") VALUES (11, 6, 'EXAM_ASSIGNED', 'Nuevo examen asignado', 'Se te ha asignado el examen "prueba 3". Período de aplicación: el 1/6/2026, 11:16:00 PM.', 't', 5, '2026-01-06 23:14:49.762531');
INSERT INTO "public"."notifications" ("id", "user_id", "type", "title", "message", "is_read", "related_service_id", "created_at") VALUES (12, 6, 'EXAM_ASSIGNED', 'Nuevo examen asignado', 'Se te ha asignado el examen "prueba 3". Período de aplicación: el 1/6/2026, 11:29:00 PM.', 't', 5, '2026-01-06 23:27:20.618828');
INSERT INTO "public"."notifications" ("id", "user_id", "type", "title", "message", "is_read", "related_service_id", "created_at") VALUES (13, 14, 'EXAM_ASSIGNED', 'Nuevo examen asignado', 'Se te ha asignado el examen "Prueba 2". Período de aplicación: el 1/9/2026, 1:08:00 AM.', 't', 6, '2026-01-09 01:06:46.688023');
COMMIT;

-- ----------------------------
-- Table structure for question_bank
-- ----------------------------
DROP TABLE IF EXISTS "public"."question_bank";
CREATE TABLE "public"."question_bank" (
  "id_question" int4 NOT NULL DEFAULT nextval('question_bank_id_question_seq'::regclass),
  "institution_id" int4 NOT NULL,
  "professor_id" int4 NOT NULL,
  "category" varchar(100) COLLATE "pg_catalog"."default",
  "type" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "content" jsonb NOT NULL,
  "correct_answer" text COLLATE "pg_catalog"."default" NOT NULL,
  "is_active" bool DEFAULT true,
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."question_bank" OWNER TO "iger";

-- ----------------------------
-- Records of question_bank
-- ----------------------------
BEGIN;
INSERT INTO "public"."question_bank" ("id_question", "institution_id", "professor_id", "category", "type", "content", "correct_answer", "is_active", "created_at", "updated_at") VALUES (1, 1, 4, 'Administración', 'MULTIPLE_CHOICE', '{"options": ["1", "2", "4", "22"], "question": "2 + 2 es igual a", "media_url": ""}', '2', 't', '2026-01-05 16:13:00.213201', '2026-01-05 16:13:00.213201');
INSERT INTO "public"."question_bank" ("id_question", "institution_id", "professor_id", "category", "type", "content", "correct_answer", "is_active", "created_at", "updated_at") VALUES (2, 1, 4, 'Física', 'OPEN', '{"options": ["", "", "", ""], "question": "Que es la gravedad", "media_url": ""}', 'Es la fuerza de atracción entre cuerpos', 't', '2026-01-05 16:14:17.32676', '2026-01-05 16:14:17.32676');
INSERT INTO "public"."question_bank" ("id_question", "institution_id", "professor_id", "category", "type", "content", "correct_answer", "is_active", "created_at", "updated_at") VALUES (3, 1, 4, 'Biologia', 'MULTIPLE_CHOICE', '{"options": ["uno", "dos", "tres", "cutro", "cinco"], "question": "¿Cuáles son las fases de la metamorfosis de una mariposa?", "media_url": ""}', 'cinco', 't', '2026-01-05 22:02:14.134753', '2026-01-05 22:02:14.134753');
INSERT INTO "public"."question_bank" ("id_question", "institution_id", "professor_id", "category", "type", "content", "correct_answer", "is_active", "created_at", "updated_at") VALUES (4, 2, 13, 'Física', 'MULTIPLE_CHOICE', '{"options": ["uno", "dos", "tres", "cuatro", "cinco"], "question": "Prueba 1", "media_url": ""}', 'uno', 't', '2026-01-08 21:13:02.659647', '2026-01-09 00:07:42.96751');
INSERT INTO "public"."question_bank" ("id_question", "institution_id", "professor_id", "category", "type", "content", "correct_answer", "is_active", "created_at", "updated_at") VALUES (5, 2, 13, 'Mate', 'MULTIPLE_CHOICE', '{"options": ["1", "2", "33", "4", "5"], "question": "2+2", "media_url": ""}', '2', 't', '2026-01-09 00:37:08.036572', '2026-01-09 00:37:08.036572');
INSERT INTO "public"."question_bank" ("id_question", "institution_id", "professor_id", "category", "type", "content", "correct_answer", "is_active", "created_at", "updated_at") VALUES (6, 2, 13, 'Biologia', 'TRUE_FALSE', '{"options": ["Verdadero", "Falso"], "question": "Existe la luna", "media_url": ""}', 'Verdadero', 't', '2026-01-09 00:53:03.119582', '2026-01-09 00:53:03.119582');
INSERT INTO "public"."question_bank" ("id_question", "institution_id", "professor_id", "category", "type", "content", "correct_answer", "is_active", "created_at", "updated_at") VALUES (7, 2, 13, 'Historia', 'OPEN', '{"options": [], "question": "¿Qué número sigue de 1?", "media_url": ""}', 'dos', 't', '2026-01-09 01:58:05.912269', '2026-01-09 01:58:38.755075');
COMMIT;

-- ----------------------------
-- Table structure for roles
-- ----------------------------
DROP TABLE IF EXISTS "public"."roles";
CREATE TABLE "public"."roles" (
  "id_role" int4 NOT NULL DEFAULT nextval('roles_id_role_seq'::regclass),
  "code" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "name" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "description" text COLLATE "pg_catalog"."default",
  "is_active" bool DEFAULT true,
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."roles" OWNER TO "iger";

-- ----------------------------
-- Records of roles
-- ----------------------------
BEGIN;
INSERT INTO "public"."roles" ("id_role", "code", "name", "description", "is_active", "created_at", "updated_at") VALUES (1, 'ROOT', 'Root', 'Superusuario del sistema', 't', '2026-01-05 12:33:47.353453', '2026-01-05 12:33:47.353453');
INSERT INTO "public"."roles" ("id_role", "code", "name", "description", "is_active", "created_at", "updated_at") VALUES (2, 'ADMIN', 'Admin', 'Administrador de institución', 't', '2026-01-05 12:33:47.353453', '2026-01-05 12:33:47.353453');
INSERT INTO "public"."roles" ("id_role", "code", "name", "description", "is_active", "created_at", "updated_at") VALUES (3, 'PROFESOR', 'Profesor', 'Profesor que crea exámenes', 't', '2026-01-05 12:33:47.353453', '2026-01-05 12:33:47.353453');
INSERT INTO "public"."roles" ("id_role", "code", "name", "description", "is_active", "created_at", "updated_at") VALUES (4, 'ESTUDIANTE', 'Estudiante', 'Estudiante que toma exámenes', 't', '2026-01-05 12:33:47.353453', '2026-01-05 12:33:47.353453');
COMMIT;

-- ----------------------------
-- Table structure for system_config
-- ----------------------------
DROP TABLE IF EXISTS "public"."system_config";
CREATE TABLE "public"."system_config" (
  "config_key" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "config_value" text COLLATE "pg_catalog"."default",
  "description" text COLLATE "pg_catalog"."default",
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."system_config" OWNER TO "iger";

-- ----------------------------
-- Records of system_config
-- ----------------------------
BEGIN;
INSERT INTO "public"."system_config" ("config_key", "config_value", "description", "updated_at") VALUES ('SITE_NAME', 'KeQuiz', 'Nombre de la plataforma', '2026-01-05 12:33:47.363174');
INSERT INTO "public"."system_config" ("config_key", "config_value", "description", "updated_at") VALUES ('ALLOW_REGISTRATION', 'false', 'Permitir registro público de estudiantes', '2026-01-05 12:33:47.363174');
INSERT INTO "public"."system_config" ("config_key", "config_value", "description", "updated_at") VALUES ('MAINTENANCE_MODE', 'false', 'Activar modo mantenimiento', '2026-01-05 12:33:47.363174');
INSERT INTO "public"."system_config" ("config_key", "config_value", "description", "updated_at") VALUES ('footer_text', '© 2026 Kesoftware', NULL, '2026-01-05 15:10:50.049393');
INSERT INTO "public"."system_config" ("config_key", "config_value", "description", "updated_at") VALUES ('footer_link_url', 'https://kequiz.kemarketing.mx', NULL, '2026-01-05 15:10:50.051327');
INSERT INTO "public"."system_config" ("config_key", "config_value", "description", "updated_at") VALUES ('footer_link_text', 'Contacto', NULL, '2026-01-05 15:10:50.053386');
COMMIT;

-- ----------------------------
-- Table structure for users
-- ----------------------------
DROP TABLE IF EXISTS "public"."users";
CREATE TABLE "public"."users" (
  "id" int4 NOT NULL DEFAULT nextval('users_id_seq'::regclass),
  "email" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "password_hash" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "role" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "institution_id" int4,
  "is_active" bool DEFAULT true,
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "photo_url" varchar(500) COLLATE "pg_catalog"."default",
  "phone" varchar(50) COLLATE "pg_catalog"."default",
  "specialty" varchar(255) COLLATE "pg_catalog"."default",
  "client_number" varchar(50) COLLATE "pg_catalog"."default",
  "curp" varchar(18) COLLATE "pg_catalog"."default",
  "first_name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "last_name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "second_last_name" varchar(255) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "public"."users" OWNER TO "iger";

-- ----------------------------
-- Records of users
-- ----------------------------
BEGIN;
INSERT INTO "public"."users" ("id", "email", "password_hash", "role", "institution_id", "is_active", "created_at", "updated_at", "photo_url", "phone", "specialty", "client_number", "curp", "first_name", "last_name", "second_last_name") VALUES (2, 'victoria.perez@sompo.com.mx', '$2b$10$Ee8eU3/G1SJfnpgaF0HyJuahzEZUxwCM7jy/Qhu9ndOQSNWTe0KeK', 'ADMIN', 1, 't', '2026-01-05 12:33:47.354405', '2026-01-05 12:33:47.354405', NULL, NULL, NULL, NULL, NULL, 'Usuario', 'Sin Apellido', NULL);
INSERT INTO "public"."users" ("id", "email", "password_hash", "role", "institution_id", "is_active", "created_at", "updated_at", "photo_url", "phone", "specialty", "client_number", "curp", "first_name", "last_name", "second_last_name") VALUES (3, 'iger@gmail.com', '$2b$10$AgqeIO333uEUGMU0MJmbU.Bv9qyX7vsFedBgeDEbtTVEklcVS1lxu', 'ROOT', NULL, 't', '2026-01-05 15:15:50.923049', '2026-01-05 15:15:50.923049', NULL, NULL, NULL, NULL, NULL, 'Usuario', 'Sin Apellido', NULL);
INSERT INTO "public"."users" ("id", "email", "password_hash", "role", "institution_id", "is_active", "created_at", "updated_at", "photo_url", "phone", "specialty", "client_number", "curp", "first_name", "last_name", "second_last_name") VALUES (6, 'nataly@gmail.com', '$2b$10$aatBZENEGNHj62BpWTem7euPeEGAJ4u84HMx06Rc6RNScJyfIYd5e', 'ESTUDIANTE', 1, 't', '2026-01-05 19:16:27.368317', '2026-01-05 21:22:29.599977', '/uploads/common/photo-1767669749597-354745914.jpg', '5555555555', NULL, 'EST-2026-1', NULL, 'Nataly', 'Mendoza', 'Melo');
INSERT INTO "public"."users" ("id", "email", "password_hash", "role", "institution_id", "is_active", "created_at", "updated_at", "photo_url", "phone", "specialty", "client_number", "curp", "first_name", "last_name", "second_last_name") VALUES (5, 'noe@gmail.com', '$2b$10$iDz2IEsImjQU0FP8spY6MON0.Qa0Rq6mQD9HuxGd/yIp4dt8ioUha', 'PROFESOR', 1, 't', '2026-01-05 15:44:17.834764', '2026-01-05 21:57:15.888819', '/uploads/common/photo-1767671835858-514841714.jpg', '4444444444', 'Matemáticas', NULL, NULL, 'Noe', 'tapua', NULL);
INSERT INTO "public"."users" ("id", "email", "password_hash", "role", "institution_id", "is_active", "created_at", "updated_at", "photo_url", "phone", "specialty", "client_number", "curp", "first_name", "last_name", "second_last_name") VALUES (4, 'fer@gmail.com', '$2b$10$/sGTswtwFJuVKPfFgoMzp.V1viO0I48.YfsT6Np5LElSd5c1xy2bK', 'PROFESOR', 1, 't', '2026-01-05 15:35:11.884824', '2026-01-05 22:00:40.161934', '/uploads/common/photo-1767648911872-908630219.jpg', '5555555555', 'Tecnología', NULL, NULL, 'Fernando', 'susano', NULL);
INSERT INTO "public"."users" ("id", "email", "password_hash", "role", "institution_id", "is_active", "created_at", "updated_at", "photo_url", "phone", "specialty", "client_number", "curp", "first_name", "last_name", "second_last_name") VALUES (1, 'hola@kemarketing.mx', '$2b$10$6cL/FnLGTLeM.a5nRqangeA0LMWu6vISQIyyF2A5TgGqoCqCA7kJa', 'ROOT', NULL, 't', '2026-01-05 12:33:47.354405', '2026-01-05 15:09:32.67852', NULL, NULL, NULL, NULL, NULL, 'Usuario', 'Sin Apellido', NULL);
INSERT INTO "public"."users" ("id", "email", "password_hash", "role", "institution_id", "is_active", "created_at", "updated_at", "photo_url", "phone", "specialty", "client_number", "curp", "first_name", "last_name", "second_last_name") VALUES (7, 'admin@demo.com', '$2b$10$3fRxXtfYwbxPS2uDMFG6TetBxC1EwQVm3KgcQ.2OTetY.BweMwcKW', 'ADMIN', 2, 't', '2026-01-08 19:28:12.967432', '2026-01-08 19:28:23.011948', NULL, NULL, NULL, NULL, NULL, 'Usuario', 'Sin Apellido', NULL);
INSERT INTO "public"."users" ("id", "email", "password_hash", "role", "institution_id", "is_active", "created_at", "updated_at", "photo_url", "phone", "specialty", "client_number", "curp", "first_name", "last_name", "second_last_name") VALUES (13, 'fer@demo.com', '$2b$10$Q28kAea44hgerDxMmglD7.3clNCXFyJkx.x1ys.c6k8a7Jope4AgO', 'PROFESOR', 2, 't', '2026-01-09 00:04:34.383964', '2026-01-09 00:18:36.896951', '/uploads/common/photo-1767938674448-33163590.jpg', '5555555555', 'Pedagogía', NULL, NULL, 'Fernando', 'Susano', NULL);
INSERT INTO "public"."users" ("id", "email", "password_hash", "role", "institution_id", "is_active", "created_at", "updated_at", "photo_url", "phone", "specialty", "client_number", "curp", "first_name", "last_name", "second_last_name") VALUES (14, 'meli@demo.com', '$2b$10$FdHjncYad9SqTS1QfNlKpOzF9PeTtAe3lvpRe8U5Tb/cVqjzTodnm', 'ESTUDIANTE', 2, 't', '2026-01-09 00:05:37.375374', '2026-01-09 00:33:54.901105', '/uploads/common/photo-1767938737425-623073262.jpg', '1111111111', NULL, 'EST-2026-1', NULL, 'Melissa', 'Melo', NULL);
COMMIT;

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."exam_assignments_id_assignment_seq"
OWNED BY "public"."exam_assignments"."id_assignment";
SELECT setval('"public"."exam_assignments_id_assignment_seq"', 14, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."exam_logs_id_log_seq"
OWNED BY "public"."exam_logs"."id_log";
SELECT setval('"public"."exam_logs_id_log_seq"', 1, false);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."exam_questions_id_exam_question_seq"
OWNED BY "public"."exam_questions"."id_exam_question";
SELECT setval('"public"."exam_questions_id_exam_question_seq"', 16, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."exam_responses_id_response_seq"
OWNED BY "public"."exam_responses"."id_response";
SELECT setval('"public"."exam_responses_id_response_seq"', 1110, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."exams_id_exam_seq"
OWNED BY "public"."exams"."id_exam";
SELECT setval('"public"."exams_id_exam_seq"', 6, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
SELECT setval('"public"."institutions_id_institution_seq"', 2, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."modules_id_module_seq"
OWNED BY "public"."modules"."id_module";
SELECT setval('"public"."modules_id_module_seq"', 4, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."notifications_id_seq"
OWNED BY "public"."notifications"."id";
SELECT setval('"public"."notifications_id_seq"', 13, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."question_bank_id_question_seq"
OWNED BY "public"."question_bank"."id_question";
SELECT setval('"public"."question_bank_id_question_seq"', 7, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
SELECT setval('"public"."roles_id_role_seq"', 4, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
SELECT setval('"public"."users_id_seq"', 14, true);

-- ----------------------------
-- Indexes structure for table exam_assignments
-- ----------------------------
CREATE INDEX "idx_exam_assignments_student" ON "public"."exam_assignments" USING btree (
  "student_id" "pg_catalog"."int4_ops" ASC NULLS LAST
);

-- ----------------------------
-- Primary Key structure for table exam_assignments
-- ----------------------------
ALTER TABLE "public"."exam_assignments" ADD CONSTRAINT "exam_assignments_pkey" PRIMARY KEY ("id_assignment");

-- ----------------------------
-- Indexes structure for table exam_logs
-- ----------------------------
CREATE INDEX "idx_exam_logs_assignment" ON "public"."exam_logs" USING btree (
  "assignment_id" "pg_catalog"."int4_ops" ASC NULLS LAST
);

-- ----------------------------
-- Primary Key structure for table exam_logs
-- ----------------------------
ALTER TABLE "public"."exam_logs" ADD CONSTRAINT "exam_logs_pkey" PRIMARY KEY ("id_log");

-- ----------------------------
-- Primary Key structure for table exam_questions
-- ----------------------------
ALTER TABLE "public"."exam_questions" ADD CONSTRAINT "exam_questions_pkey" PRIMARY KEY ("id_exam_question");

-- ----------------------------
-- Uniques structure for table exam_responses
-- ----------------------------
ALTER TABLE "public"."exam_responses" ADD CONSTRAINT "unique_assignment_question" UNIQUE ("assignment_id", "question_id");

-- ----------------------------
-- Primary Key structure for table exam_responses
-- ----------------------------
ALTER TABLE "public"."exam_responses" ADD CONSTRAINT "exam_responses_pkey" PRIMARY KEY ("id_response");

-- ----------------------------
-- Indexes structure for table exams
-- ----------------------------
CREATE INDEX "idx_exams_institution" ON "public"."exams" USING btree (
  "institution_id" "pg_catalog"."int4_ops" ASC NULLS LAST
);

-- ----------------------------
-- Primary Key structure for table exams
-- ----------------------------
ALTER TABLE "public"."exams" ADD CONSTRAINT "exams_pkey" PRIMARY KEY ("id_exam");

-- ----------------------------
-- Primary Key structure for table institution_modules
-- ----------------------------
ALTER TABLE "public"."institution_modules" ADD CONSTRAINT "institution_modules_pkey" PRIMARY KEY ("institution_id", "module_id");

-- ----------------------------
-- Primary Key structure for table institutions
-- ----------------------------
ALTER TABLE "public"."institutions" ADD CONSTRAINT "institutions_pkey" PRIMARY KEY ("id_institution");

-- ----------------------------
-- Uniques structure for table modules
-- ----------------------------
ALTER TABLE "public"."modules" ADD CONSTRAINT "modules_code_key" UNIQUE ("code");

-- ----------------------------
-- Primary Key structure for table modules
-- ----------------------------
ALTER TABLE "public"."modules" ADD CONSTRAINT "modules_pkey" PRIMARY KEY ("id_module");

-- ----------------------------
-- Indexes structure for table notifications
-- ----------------------------
CREATE INDEX "idx_notifications_is_read" ON "public"."notifications" USING btree (
  "is_read" "pg_catalog"."bool_ops" ASC NULLS LAST
);
CREATE INDEX "idx_notifications_user" ON "public"."notifications" USING btree (
  "user_id" "pg_catalog"."int4_ops" ASC NULLS LAST
);

-- ----------------------------
-- Primary Key structure for table notifications
-- ----------------------------
ALTER TABLE "public"."notifications" ADD CONSTRAINT "notifications_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Indexes structure for table question_bank
-- ----------------------------
CREATE INDEX "idx_question_bank_institution" ON "public"."question_bank" USING btree (
  "institution_id" "pg_catalog"."int4_ops" ASC NULLS LAST
);

-- ----------------------------
-- Primary Key structure for table question_bank
-- ----------------------------
ALTER TABLE "public"."question_bank" ADD CONSTRAINT "question_bank_pkey" PRIMARY KEY ("id_question");

-- ----------------------------
-- Uniques structure for table roles
-- ----------------------------
ALTER TABLE "public"."roles" ADD CONSTRAINT "roles_code_key" UNIQUE ("code");

-- ----------------------------
-- Primary Key structure for table roles
-- ----------------------------
ALTER TABLE "public"."roles" ADD CONSTRAINT "roles_pkey" PRIMARY KEY ("id_role");

-- ----------------------------
-- Primary Key structure for table system_config
-- ----------------------------
ALTER TABLE "public"."system_config" ADD CONSTRAINT "system_config_pkey" PRIMARY KEY ("config_key");

-- ----------------------------
-- Indexes structure for table users
-- ----------------------------
CREATE INDEX "idx_users_email" ON "public"."users" USING btree (
  "email" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);
CREATE INDEX "idx_users_first_name" ON "public"."users" USING btree (
  "first_name" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);
CREATE INDEX "idx_users_institution_id" ON "public"."users" USING btree (
  "institution_id" "pg_catalog"."int4_ops" ASC NULLS LAST
);
CREATE INDEX "idx_users_last_name" ON "public"."users" USING btree (
  "last_name" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);

-- ----------------------------
-- Uniques structure for table users
-- ----------------------------
ALTER TABLE "public"."users" ADD CONSTRAINT "users_email_key" UNIQUE ("email");

-- ----------------------------
-- Primary Key structure for table users
-- ----------------------------
ALTER TABLE "public"."users" ADD CONSTRAINT "users_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Foreign Keys structure for table exam_assignments
-- ----------------------------
ALTER TABLE "public"."exam_assignments" ADD CONSTRAINT "exam_assignments_exam_id_fkey" FOREIGN KEY ("exam_id") REFERENCES "public"."exams" ("id_exam") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."exam_assignments" ADD CONSTRAINT "exam_assignments_student_id_fkey" FOREIGN KEY ("student_id") REFERENCES "public"."users" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table exam_logs
-- ----------------------------
ALTER TABLE "public"."exam_logs" ADD CONSTRAINT "exam_logs_assignment_id_fkey" FOREIGN KEY ("assignment_id") REFERENCES "public"."exam_assignments" ("id_assignment") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table exam_questions
-- ----------------------------
ALTER TABLE "public"."exam_questions" ADD CONSTRAINT "exam_questions_exam_id_fkey" FOREIGN KEY ("exam_id") REFERENCES "public"."exams" ("id_exam") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."exam_questions" ADD CONSTRAINT "exam_questions_question_id_fkey" FOREIGN KEY ("question_id") REFERENCES "public"."question_bank" ("id_question") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table exam_responses
-- ----------------------------
ALTER TABLE "public"."exam_responses" ADD CONSTRAINT "exam_responses_assignment_id_fkey" FOREIGN KEY ("assignment_id") REFERENCES "public"."exam_assignments" ("id_assignment") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."exam_responses" ADD CONSTRAINT "exam_responses_question_id_fkey" FOREIGN KEY ("question_id") REFERENCES "public"."question_bank" ("id_question") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table exams
-- ----------------------------
ALTER TABLE "public"."exams" ADD CONSTRAINT "exams_institution_id_fkey" FOREIGN KEY ("institution_id") REFERENCES "public"."institutions" ("id_institution") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."exams" ADD CONSTRAINT "exams_professor_id_fkey" FOREIGN KEY ("professor_id") REFERENCES "public"."users" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table institution_modules
-- ----------------------------
ALTER TABLE "public"."institution_modules" ADD CONSTRAINT "institution_modules_institution_id_fkey" FOREIGN KEY ("institution_id") REFERENCES "public"."institutions" ("id_institution") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."institution_modules" ADD CONSTRAINT "institution_modules_module_id_fkey" FOREIGN KEY ("module_id") REFERENCES "public"."modules" ("id_module") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table notifications
-- ----------------------------
ALTER TABLE "public"."notifications" ADD CONSTRAINT "notifications_user_id_fkey" FOREIGN KEY ("user_id") REFERENCES "public"."users" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table question_bank
-- ----------------------------
ALTER TABLE "public"."question_bank" ADD CONSTRAINT "question_bank_institution_id_fkey" FOREIGN KEY ("institution_id") REFERENCES "public"."institutions" ("id_institution") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."question_bank" ADD CONSTRAINT "question_bank_professor_id_fkey" FOREIGN KEY ("professor_id") REFERENCES "public"."users" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table users
-- ----------------------------
ALTER TABLE "public"."users" ADD CONSTRAINT "users_institution_id_fkey" FOREIGN KEY ("institution_id") REFERENCES "public"."institutions" ("id_institution") ON DELETE SET NULL ON UPDATE NO ACTION;
