# Scripts de Backup y Restauración - KeQuiz

## Descripción

Estos scripts permiten crear y restaurar backups completos de la base de datos PostgreSQL de KeQuiz.

---

## 📦 Script de Backup: `backup_database.sh`

### Uso Básico
```bash
./scripts/backup_database.sh
```

### Características
- Crea backup completo de la base de datos
- Genera archivo con timestamp: `backup_YYYYMMDD_HHMMSS.sql`
- Comprime automáticamente el backup (`.gz`)
- Guarda en `/var/www/html/kequiz/` por defecto

### Configuración
Puedes modificar las variables de entorno antes de ejecutar:
```bash
DB_HOST=127.0.0.1 \
DB_PORT=5432 \
DB_NAME=kequiz \
DB_USER=iger \
BACKUP_DIR=/var/www/html/kequiz \
./scripts/backup_database.sh
```

### Ejemplo de Salida
```
Creando backup de la base de datos...
Base de datos: kequiz
Usuario: iger
Archivo: /var/www/html/kequiz/backup_20250109_223000.sql
✓ Backup creado exitosamente: /var/www/html/kequiz/backup_20250109_223000.sql
Comprimiendo backup...
✓ Backup comprimido: /var/www/html/kequiz/backup_20250109_223000.sql.gz
-rw-r--r-- 1 user user 2.5M Jan  9 22:30 backup_20250109_223000.sql.gz
```

---

## 🔄 Script de Restauración: `restore_database.sh`

### Uso Básico

#### Opción 1: Especificar archivo directamente
```bash
./scripts/restore_database.sh backup_20250109_223000.sql.gz
```

#### Opción 2: Listar backups disponibles
```bash
./scripts/restore_database.sh --list
```

#### Opción 3: Selección interactiva
```bash
./scripts/restore_database.sh
# El script mostrará los backups disponibles y pedirá que selecciones uno
```

### Opciones Disponibles
```bash
-f, --file FILE    # Especificar archivo de backup a restaurar
-l, --list         # Listar backups disponibles
-h, --help         # Mostrar ayuda
```

### Características
- ✅ Lista backups disponibles automáticamente
- ✅ Descomprime automáticamente si el backup está comprimido (`.gz`)
- ✅ Solicita confirmación antes de restaurar (protección contra errores)
- ✅ Crea la base de datos si no existe
- ✅ Verifica que la restauración fue exitosa
- ✅ Limpia archivos temporales automáticamente

### Proceso de Restauración

1. **Selección de backup**: El script lista los backups disponibles o usa el especificado
2. **Confirmación**: Pide confirmación escribiendo "SI" (protección)
3. **Verificación de BD**: Crea la base de datos si no existe
4. **Restauración**: Ejecuta el SQL del backup
5. **Verificación**: Cuenta las tablas para confirmar éxito

### Ejemplo de Uso

```bash
# Listar backups
$ ./scripts/restore_database.sh --list
Backups disponibles en /var/www/html/kequiz:

  1. backup_20250109_223000.sql.gz - 2.5M - 2025-01-09 22:30:00
  2. backup_20250109_120000.sql.gz - 2.3M - 2025-01-09 12:00:00

# Restaurar un backup específico
$ ./scripts/restore_database.sh backup_20250109_223000.sql.gz

⚠ ADVERTENCIA: Esta operación eliminará todos los datos actuales de la base de datos
Base de datos: kequiz
Archivo: /var/www/html/kequiz/backup_20250109_223000.sql.gz

¿Estás seguro de que deseas continuar? (escribe 'SI' para confirmar): SI

Restaurando base de datos...
Esto puede tardar varios minutos dependiendo del tamaño del backup...
Verificando/Creando base de datos...
✓ Base de datos restaurada exitosamente
✓ Archivo temporal eliminado

Verificando restauración...
✓ Restauración verificada: 14 tablas encontradas
```

---

## 🔐 Seguridad

### Variables de Entorno para Contraseña

Para evitar ingresar la contraseña manualmente, puedes usar:

```bash
# Opción 1: Variable de entorno
export PGPASSWORD='tu_contraseña'
./scripts/backup_database.sh

# Opción 2: Archivo .pgpass
# Crear archivo ~/.pgpass con formato:
# hostname:port:database:username:password
# Ejemplo:
# 127.0.0.1:5432:kequiz:iger:tu_contraseña
chmod 600 ~/.pgpass
```

---

## 📋 Comandos Rápidos

### Backup
```bash
# Backup simple
./scripts/backup_database.sh

# Backup con configuración personalizada
DB_HOST=192.168.1.100 DB_NAME=kequiz_prod ./scripts/backup_database.sh
```

### Restauración
```bash
# Restaurar backup específico
./scripts/restore_database.sh backup_20250109_223000.sql.gz

# Listar backups
./scripts/restore_database.sh --list

# Restauración interactiva
./scripts/restore_database.sh
```

---

## ⚠️ Advertencias Importantes

1. **La restauración elimina todos los datos actuales** de la base de datos
2. **Siempre haz backup antes de restaurar** si hay datos importantes
3. **Verifica el archivo de backup** antes de restaurar
4. **El script pide confirmación** escribiendo "SI" para evitar errores accidentales

---

## 🐛 Solución de Problemas

### Error: "psql: FATAL: password authentication failed"
- Verifica las credenciales del usuario
- Usa `PGPASSWORD` o archivo `.pgpass`

### Error: "No se encontraron backups"
- Verifica que el directorio `/var/www/html/kequiz` existe
- Verifica que hay archivos `backup_*.sql` o `backup_*.sql.gz`

### Error: "relation does not exist" durante restauración
- Esto puede ser normal si el backup tiene comandos `DROP TABLE IF EXISTS`
- Verifica que el backup se creó correctamente

### El script no encuentra el archivo
- Usa ruta absoluta: `/var/www/html/kequiz/backup.sql`
- O verifica que el archivo está en el directorio de backups

---

## 📝 Notas

- Los backups se comprimen automáticamente para ahorrar espacio
- Los archivos temporales se eliminan automáticamente después de restaurar
- El script verifica que la restauración fue exitosa contando las tablas
- Compatible con backups comprimidos (`.gz`) y sin comprimir (`.sql`)

