# Script de Verificación de Base de Datos

## Descripción

Este script valida el estado de la base de datos de KeQuiz y genera un reporte detallado de inconsistencias, tablas faltantes, columnas faltantes, índices, constraints y problemas de integridad de datos.

## Uso

### Ejecutar desde npm:
```bash
npm run verify-db
```

### Ejecutar directamente:
```bash
node scripts/verify_database.js
```

## Qué Verifica

### 1. **Tablas**
- Verifica que todas las tablas esperadas existan
- Detecta tablas alternativas (ej: `companies` vs `institutions`)
- Identifica tablas inesperadas

### 2. **Columnas**
- Verifica que todas las columnas esperadas existan en cada tabla
- Detecta columnas alternativas (ej: `max_students` vs `max_clients`)
- Identifica columnas faltantes o adicionales

### 3. **Índices**
- Verifica índices de optimización
- Verifica índices únicos
- Identifica índices faltantes

### 4. **Constraints**
- Verifica constraints únicos
- Verifica índices únicos parciales (phone, curp)

### 5. **Foreign Keys**
- Verifica relaciones entre tablas
- Identifica foreign keys faltantes

### 6. **Integridad de Datos**
- Verifica usuarios con institution_id inválido
- Detecta emails duplicados
- Identifica referencias rotas

## Estructura Esperada

El script verifica contra la siguiente estructura:

### Tablas Principales:
- `institutions` (o `companies` como alternativa)
- `users`
- `roles`
- `question_bank`
- `exams`
- `exam_assignments`
- `exam_questions`
- `exam_responses`
- `exam_logs`
- `notifications`
- `system_config`
- `modules`
- `institution_modules`
- `specialties`

### Columnas Especiales:
- **Users**: `first_name`, `last_name`, `second_last_name` (o `name` como alternativa)
- **Institutions**: `max_students`, `max_teachers` (o `max_clients`, `max_employees` como alternativa)
- **Users**: `institution_id` (o `company_id` como alternativa)

## Salida

El script genera:

1. **Salida en consola**: Muestra errores, advertencias e información en tiempo real
2. **Archivo de reporte**: Guardado en `logs/database_verification_YYYY-MM-DDTHH-MM-SS.txt`

### Niveles de Severidad:

- **❌ ERROR**: Problemas críticos que deben corregirse
- **⚠️ WARNING**: Advertencias que deberían revisarse
- **ℹ️ INFO**: Información sobre el estado de la base de datos

## Ejemplo de Salida

```
Iniciando verificación de base de datos...

ℹ️ [INFO] Verificando tablas...
ℹ️ [INFO] Tablas encontradas: 14
✓ Tabla 'users' existe
✓ Tabla 'institutions' existe
⚠️ [WARNING] Tabla 'institutions' no existe, pero se encontró 'companies' (tabla alternativa)
❌ [ERROR] Tabla esperada 'specialties' no existe
...
```

## Código de Salida

- `0`: Verificación exitosa (sin errores)
- `1`: Se encontraron errores

## Uso en Producción

Para ejecutar en producción:

```bash
# En el servidor
cd /var/www/html/kequiz
npm run verify-db

# O directamente
node scripts/verify_database.js
```

El reporte se guardará en `/var/www/html/kequiz/logs/database_verification_*.txt`

## Solución de Problemas

### Error: "Cannot find module '../src/models/database.js'"
- Verifica que estés ejecutando desde la raíz del proyecto
- Verifica que el archivo `src/models/database.js` exista

### Error de conexión a la base de datos
- Verifica las variables de entorno (`.env`)
- Verifica que la base de datos esté accesible
- Verifica credenciales de conexión

## Personalización

Para agregar más verificaciones, edita `scripts/verify_database.js` y agrega métodos adicionales a la clase `DatabaseVerifier`.

