#!/bin/bash

# Script de Backup de Base de Datos - KeQuiz
# 
# Este script crea un backup completo de la base de datos PostgreSQL
# 
# Uso: ./scripts/backup_database.sh
# O: bash scripts/backup_database.sh

# Configuración (ajustar según tu entorno)
DB_HOST="${DB_HOST:-127.0.0.1}"
DB_PORT="${DB_PORT:-5432}"
DB_NAME="${DB_NAME:-kequiz}"
DB_USER="${DB_USER:-iger}"
BACKUP_DIR="${BACKUP_DIR:-/var/www/html/kequiz}"
BACKUP_FILE="${BACKUP_DIR}/backup_$(date +%Y%m%d_%H%M%S).sql"

# Crear directorio de backup si no existe
mkdir -p "$BACKUP_DIR"

# Crear backup
echo "Creando backup de la base de datos..."
echo "Base de datos: $DB_NAME"
echo "Usuario: $DB_USER"
echo "Archivo: $BACKUP_FILE"

pg_dump -h "$DB_HOST" -p "$DB_PORT" -U "$DB_USER" -d "$DB_NAME" \
    --format=plain \
    --no-owner \
    --no-privileges \
    --clean \
    --if-exists \
    --file="$BACKUP_FILE"

if [ $? -eq 0 ]; then
    echo "✓ Backup creado exitosamente: $BACKUP_FILE"
    
    # Comprimir el backup (opcional)
    echo "Comprimiendo backup..."
    gzip "$BACKUP_FILE"
    echo "✓ Backup comprimido: ${BACKUP_FILE}.gz"
    
    # Mostrar tamaño del archivo
    ls -lh "${BACKUP_FILE}.gz"
else
    echo "✗ Error al crear el backup"
    exit 1
fi

