import pool from '../src/models/database.js';

async function cleanExamAssignments() {
    const client = await pool.connect();
    try {
        await client.query('BEGIN');
        
        console.log('🧹 Limpiando respuestas de exámenes...');
        const deleteResponses = await client.query('DELETE FROM exam_responses');
        console.log(`   ✓ Eliminadas ${deleteResponses.rowCount} respuestas`);
        
        console.log('🧹 Limpiando asignaciones de exámenes...');
        const deleteAssignments = await client.query('DELETE FROM exam_assignments');
        console.log(`   ✓ Eliminadas ${deleteAssignments.rowCount} asignaciones`);
        
        await client.query('COMMIT');
        console.log('\n✅ Limpieza completada exitosamente');
    } catch (error) {
        await client.query('ROLLBACK');
        console.error('❌ Error durante la limpieza:', error);
        throw error;
    } finally {
        client.release();
        process.exit(0);
    }
}

cleanExamAssignments();




