#!/bin/bash

# Script de Limpieza del Proyecto - KeQuiz
# 
# Este script elimina archivos de configuración y prepara el proyecto
# para subirlo a un nuevo repositorio Git
# 
# Uso: bash scripts/limpiar_proyecto.sh

echo "🧹 Limpiando proyecto para nuevo repositorio..."
echo ""

# Colores
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m'

# 1. Eliminar directorio .git
if [ -d ".git" ]; then
    echo -e "${YELLOW}Eliminando directorio .git...${NC}"
    rm -rf .git
    echo -e "${GREEN}✓ Directorio .git eliminado${NC}"
else
    echo -e "${GREEN}✓ No existe directorio .git${NC}"
fi

# 2. Eliminar archivos .DS_Store
echo ""
echo -e "${YELLOW}Eliminando archivos .DS_Store...${NC}"
find . -name ".DS_Store" -type f -delete 2>/dev/null
echo -e "${GREEN}✓ Archivos .DS_Store eliminados${NC}"

# 3. Eliminar archivos temporales
echo ""
echo -e "${YELLOW}Eliminando archivos temporales...${NC}"
find . -name "*.tmp" -type f -delete 2>/dev/null
find . -name "*.temp" -type f -delete 2>/dev/null
find . -name "*.swp" -type f -delete 2>/dev/null
find . -name "*.swo" -type f -delete 2>/dev/null
find . -name "*~" -type f -delete 2>/dev/null
echo -e "${GREEN}✓ Archivos temporales eliminados${NC}"

# 4. Verificar que .gitignore existe
if [ ! -f ".gitignore" ]; then
    echo -e "${RED}✗ Archivo .gitignore no encontrado${NC}"
    echo "   Por favor, crea el archivo .gitignore antes de continuar"
    exit 1
else
    echo -e "${GREEN}✓ Archivo .gitignore encontrado${NC}"
fi

# 5. Verificar que .env.example existe
if [ ! -f ".env.example" ]; then
    echo -e "${YELLOW}⚠ Archivo .env.example no encontrado${NC}"
    echo "   Se recomienda crear este archivo como plantilla"
else
    echo -e "${GREEN}✓ Archivo .env.example encontrado${NC}"
fi

# 6. Mostrar resumen
echo ""
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo -e "${GREEN}✓ Limpieza completada${NC}"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo ""
echo "Próximos pasos:"
echo "  1. Revisa el archivo PREPARAR_REPOSITORIO.md"
echo "  2. Ejecuta: git init"
echo "  3. Ejecuta: git remote add origin https://github.com/igerfv/kequiz.git"
echo "  4. Ejecuta: git add ."
echo "  5. Ejecuta: git commit -m 'Initial commit'"
echo "  6. Ejecuta: git push -u origin main"
echo ""

