import fs from 'fs';
import path from 'path';
import { fileURLToPath } from 'url';
import pool from '../src/models/database.js';

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

const migrate = async () => {
    try {
        const sqlPath = path.join(__dirname, '../inicio.sql');
        const sql = fs.readFileSync(sqlPath, 'utf8');

        console.log('Ejecutando script de migración...');
        await pool.query(sql);
        console.log('✅ Migración completada exitosamente.');
    } catch (err) {
        console.error('❌ Error durante la migración:', err);
    } finally {
        await pool.end();
    }
};

migrate();
