
import pool from '../src/models/database.js';

async function repair() {
    try {
        console.log('--- REPARANDO TABLA USERS ---');
        
        // 1. Agregar columnas si no existen
        await pool.query(`
            ALTER TABLE users 
            ADD COLUMN IF NOT EXISTS name VARCHAR(255),
            ADD COLUMN IF NOT EXISTS phone VARCHAR(50),
            ADD COLUMN IF NOT EXISTS specialty VARCHAR(255),
            ADD COLUMN IF NOT EXISTS client_number VARCHAR(50);
        `);
        console.log('Columnas name, phone, specialty, client_number aseguradas.');

        // 2. Verificar columnas actuales
        const res = await pool.query(`
            SELECT column_name, data_type 
            FROM information_schema.columns 
            WHERE table_name = 'users'
        `);
        console.log('Estructura actual de la tabla users:');
        console.table(res.rows);

    } catch (err) {
        console.error('Error reparando tabla:', err.message);
    } finally {
        await pool.end();
    }
}

repair();






