import bcrypt from 'bcryptjs';
import pool from '../src/models/database.js';

async function verifyRootLogin() {
    const client = await pool.connect();
    try {
        // Buscar usuario root
        const email = 'hola@kemarketing.mx';
        const result = await client.query(
            'SELECT id, email, password_hash, role, is_active FROM users WHERE LOWER(TRIM(email)) = $1',
            [email.toLowerCase().trim()]
        );

        if (result.rows.length === 0) {
            console.log('❌ Usuario root no encontrado en la base de datos');
            console.log(`Buscando: ${email}`);
            return;
        }

        const user = result.rows[0];
        console.log('✅ Usuario root encontrado:');
        console.log(`   ID: ${user.id}`);
        console.log(`   Email: ${user.email}`);
        console.log(`   Role: ${user.role}`);
        console.log(`   Is Active: ${user.is_active}`);
        console.log(`   Has password_hash: ${!!user.password_hash}`);

        if (!user.password_hash) {
            console.log('\n⚠️  El usuario no tiene password_hash. Generando uno nuevo...');
            const testPassword = 'demo123';
            const salt = await bcrypt.genSalt(10);
            const hash = await bcrypt.hash(testPassword, salt);
            
            await client.query(
                'UPDATE users SET password_hash = $1 WHERE id = $2',
                [hash, user.id]
            );
            
            console.log(`✅ Password_hash generado. Contraseña: ${testPassword}`);
            console.log(`   Hash: ${hash}`);
        } else {
            console.log(`\n📝 Password_hash actual: ${user.password_hash.substring(0, 20)}...`);
            
            // Probar contraseñas comunes
            const commonPasswords = ['demo123', 'admin123', 'root123', 'password', '123456'];
            console.log('\n🔍 Probando contraseñas comunes:');
            
            for (const pwd of commonPasswords) {
                const match = await bcrypt.compare(pwd, user.password_hash);
                if (match) {
                    console.log(`   ✅ Contraseña encontrada: "${pwd}"`);
                    break;
                } else {
                    console.log(`   ❌ No coincide: "${pwd}"`);
                }
            }
        }

        // Verificar MASTER_PASSWORD
        const masterPass = process.env.MASTER_PASSWORD;
        if (masterPass) {
            console.log(`\n🔑 MASTER_PASSWORD configurado: ${masterPass.substring(0, 3)}...`);
            console.log('   ✅ Los usuarios ROOT pueden usar esta contraseña para login');
        } else {
            console.log('\n⚠️  MASTER_PASSWORD no está configurado en .env');
            console.log('   Agrega MASTER_PASSWORD=tu_contraseña en tu archivo .env');
        }

    } catch (error) {
        console.error('❌ Error:', error.message);
    } finally {
        client.release();
        await pool.end();
    }
}

verifyRootLogin();


