import express from 'express';
import bcrypt from 'bcryptjs';
import jwt from 'jsonwebtoken';
import { UserModel } from '../../src/models/user.js';
import { InstitutionModel } from '../../src/models/institution.js';

const router = express.Router();
const JWT_SECRET = process.env.JWT_SECRET || 'supersecretkey';

router.post('/login', async (req, res) => {
    const { email, password } = req.body;
    if (!email || !password) {
        return res.status(400).json({ error: 'Email and password required' });
    }
    
    // Normalizar email (trim y lowercase)
    const normalizedEmail = (email || '').trim().toLowerCase();
    
    try {
        console.log(`[AUTH] Login attempt for email: ${normalizedEmail}`);
        console.log(`[AUTH] MASTER_PASSWORD configured: ${!!process.env.MASTER_PASSWORD}`);
        
        const user = await UserModel.getByEmail(normalizedEmail);
        
        if (!user) {
            console.log(`[AUTH] User not found: ${normalizedEmail}`);
            return res.status(401).json({ error: 'Invalid credentials' });
        }

        console.log(`[AUTH] User found: ${user.email}, Role: ${user.role}, Has password_hash: ${!!user.password_hash}`);

        // Verificar si el usuario está activo
        if (user.is_active === false) {
            console.log(`[AUTH] User is inactive: ${normalizedEmail}`);
            return res.status(403).json({ error: 'User account is inactive' });
        }

        // Validar contraseña
        let isValidPassword = false;
        const masterPass = process.env.MASTER_PASSWORD;
        const userRole = (user.role || '').toUpperCase();
        
        // Verificar contraseña maestra para usuarios ROOT
        if (masterPass && userRole === 'ROOT' && password === masterPass) {
            console.log(`[AUTH] Master password accepted for ROOT user: ${normalizedEmail}`);
            isValidPassword = true;
        }
        
        // Si no es contraseña maestra, verificar hash
        if (!isValidPassword) {
            if (!user.password_hash) {
                console.log(`[AUTH] User has no password_hash: ${normalizedEmail}`);
                return res.status(401).json({ error: 'Invalid credentials' });
            }
            
            try {
                isValidPassword = await bcrypt.compare(password, user.password_hash);
                console.log(`[AUTH] Password comparison result: ${isValidPassword}`);
            } catch (bcryptError) {
                console.error(`[AUTH] Bcrypt error:`, bcryptError);
                return res.status(401).json({ error: 'Invalid credentials' });
            }
        }

        if (!isValidPassword) {
            console.log(`[AUTH] Invalid password for user: ${normalizedEmail}`);
            return res.status(401).json({ error: 'Invalid credentials' });
        }

        // Comprobar si la institución está activa
        if (user.institution_id) {
            const institution = await InstitutionModel.getById(user.institution_id);
            if (institution && !institution.is_active) {
                console.log(`[AUTH] Institution is inactive: ${user.institution_id}`);
                return res.status(403).json({ error: 'Institution is inactive' });
            }
        }

        const role = userRole;
        const token = jwt.sign({
            id: user.id,
            email: user.email,
            role: role,
            institution_id: user.institution_id
        }, JWT_SECRET, { expiresIn: '8h' });

        console.log(`[AUTH] Login successful for: ${normalizedEmail}, Role: ${role}`);

        res.json({
            token,
            user: {
                id: user.id,
                user_id: user.id,
                email: user.email,
                role: role,
                name: user.name,
                institution_id: user.institution_id,
                company_id: user.institution_id,
                photo_url: user.photo_url
            }
        });
    } catch (error) {
        console.error('[AUTH] Login error:', error);
        res.status(500).json({ error: 'Internal server error' });
    }
});

export default router;

