import express from 'express';
import { SystemConfigModel } from '../../src/models/systemConfig.js';

const router = express.Router();

router.get('/', async (req, res) => {
    try {
        const config = await SystemConfigModel.getAll();
        res.json(config);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
});

router.get('/:key', async (req, res) => {
    try {
        const config = await SystemConfigModel.getByKey(req.params.key);
        res.json(config);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
});

router.put('/:key', async (req, res) => {
    try {
        const { config_value, description } = req.body;
        const config = await SystemConfigModel.set(req.params.key, config_value, description);
        res.json(config);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
});

export default router;






