import express from 'express';
import { NotificationModel } from '../../src/models/notification.js';

const router = express.Router();

router.get('/', async (req, res) => {
    try {
        const notifications = await NotificationModel.getByUserId(req.user.id);
        res.json(notifications);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
});

router.get('/unread-count', async (req, res) => {
    try {
        const count = await NotificationModel.getUnreadCount(req.user.id);
        res.json({ count });
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
});

router.put('/:id/read', async (req, res) => {
    try {
        const notification = await NotificationModel.markAsRead(req.params.id);
        res.json(notification);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
});

router.put('/read-all', async (req, res) => {
    try {
        await NotificationModel.markAllAsRead(req.user.id);
        res.json({ success: true });
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
});

export default router;






