import pool from '../../src/models/database.js';

export const createNotification = async ({ userId, type, title, message, relatedId = null }) => {
    try {
        const res = await pool.query(
            `INSERT INTO notifications (user_id, type, title, message, related_service_id)
             VALUES ($1, $2, $3, $4, $5) RETURNING *`,
            [userId, type, title, message, relatedId]
        );
        return res.rows[0];
    } catch (error) {
        console.error('Error creating notification:', error);
        throw error;
    }
};

export const notifyExamAssigned = async (studentId, examId, scheduledAt = null, scheduledEndAt = null) => {
    try {
        const examRes = await pool.query('SELECT title FROM exams WHERE id_exam = $1', [examId]);
        const exam = examRes.rows[0];
        
        if (!exam) return;

        let dateStr = '';
        if (scheduledAt && scheduledEndAt) {
            dateStr = `del ${new Date(scheduledAt).toLocaleString()} al ${new Date(scheduledEndAt).toLocaleString()}`;
        } else if (scheduledAt) {
            dateStr = `el ${new Date(scheduledAt).toLocaleString()}`;
        } else {
            dateStr = 'por definir';
        }

        await createNotification({
            userId: studentId,
            type: 'EXAM_ASSIGNED',
            title: 'Nuevo examen asignado',
            message: `Se te ha asignado el examen "${exam.title}". Período de aplicación: ${dateStr}.`,
            relatedId: examId
        });
    } catch (error) {
        console.error('Error notifying student:', error);
    }
};

