-- =====================================================
-- Script para Eliminar Todas las Tablas (Keservicios)
-- Precaución: Esto eliminará TODOS los datos.
-- =====================================================

-- Desactivar triggers temporalmente para evitar errores de integridad (opcional en PostgreSQL con CASCADE)
-- SET session_replication_role = 'replica';

DROP TABLE IF EXISTS "public"."notifications" CASCADE;
DROP TABLE IF EXISTS "public"."evidences" CASCADE;
DROP TABLE IF EXISTS "public"."contracted_services" CASCADE;
DROP TABLE IF EXISTS "public"."company_modules" CASCADE;
DROP TABLE IF EXISTS "public"."services_catalogo" CASCADE; -- Nombre correcto detectado previamente
DROP TABLE IF EXISTS "public"."services_catalog" CASCADE;  -- Por si acaso existe la versión anterior
DROP TABLE IF EXISTS "public"."employees" CASCADE;
DROP TABLE IF EXISTS "public"."clients" CASCADE;
DROP TABLE IF EXISTS "public"."users" CASCADE;
DROP TABLE IF EXISTS "public"."modules" CASCADE;
DROP TABLE IF EXISTS "public"."system_config" CASCADE;
DROP TABLE IF EXISTS "public"."companies" CASCADE;

-- Reiniciar secuencias si es necesario
-- DO $$ 
-- DECLARE 
--     r RECORD;
-- BEGIN
--     FOR r IN (SELECT tablename FROM pg_tables WHERE schemaname = 'public') LOOP
--         EXECUTE 'TRUNCATE TABLE ' || quote_ident(r.tablename) || ' CASCADE';
--     END LOOP;
-- END $$;

-- SET session_replication_role = 'origin';
