-- KeQuiz Database Dump
-- Generado el: 2026-01-10T00:11:01.896Z
-- Fuente: 172.16.168.128

SET client_min_messages TO WARNING;
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', 'public', false);

-- Table: exam_assignments
DROP TABLE IF EXISTS "exam_assignments" CASCADE;
CREATE TABLE "exam_assignments" (
  "id_assignment" integer NOT NULL DEFAULT nextval('exam_assignments_id_assignment_seq'::regclass),
  "exam_id" integer NOT NULL,
  "student_id" integer NOT NULL,
  "attempt_number" integer DEFAULT 1,
  "status" character varying(50) DEFAULT 'PENDING'::character varying,
  "score" numeric,
  "scheduled_at" timestamp without time zone,
  "scheduled_end_at" timestamp without time zone,
  "started_at" timestamp without time zone,
  "finished_at" timestamp without time zone,
  "completed_at" timestamp without time zone,
  "created_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);

-- Table: exam_logs
DROP TABLE IF EXISTS "exam_logs" CASCADE;
CREATE TABLE "exam_logs" (
  "id_log" integer NOT NULL DEFAULT nextval('exam_logs_id_log_seq'::regclass),
  "assignment_id" integer NOT NULL,
  "event_type" character varying(50) NOT NULL,
  "event_data" jsonb,
  "timestamp" timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);

-- Table: exam_questions
DROP TABLE IF EXISTS "exam_questions" CASCADE;
CREATE TABLE "exam_questions" (
  "exam_id" integer NOT NULL,
  "question_id" integer NOT NULL,
  "order_index" integer NOT NULL DEFAULT 0
);

-- Table: exam_responses
DROP TABLE IF EXISTS "exam_responses" CASCADE;
CREATE TABLE "exam_responses" (
  "id_response" integer NOT NULL DEFAULT nextval('exam_responses_id_response_seq'::regclass),
  "assignment_id" integer NOT NULL,
  "question_id" integer NOT NULL,
  "student_answer" text,
  "is_correct" boolean,
  "points_earned" numeric DEFAULT 0,
  "feedback" text,
  "created_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);

-- Table: exams
DROP TABLE IF EXISTS "exams" CASCADE;
CREATE TABLE "exams" (
  "id_exam" integer NOT NULL DEFAULT nextval('exams_id_exam_seq'::regclass),
  "institution_id" integer NOT NULL,
  "professor_id" integer NOT NULL,
  "title" character varying(255) NOT NULL,
  "description" text,
  "settings" jsonb,
  "tolerance_minutes" integer DEFAULT 15,
  "is_active" boolean DEFAULT true,
  "created_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);

-- Table: institution_modules
DROP TABLE IF EXISTS "institution_modules" CASCADE;
CREATE TABLE "institution_modules" (
  "institution_id" integer NOT NULL,
  "module_id" integer NOT NULL,
  "is_enabled" boolean DEFAULT true,
  "settings" jsonb
);

-- Table: institutions
DROP TABLE IF EXISTS "institutions" CASCADE;
CREATE TABLE "institutions" (
  "id_institution" integer NOT NULL DEFAULT nextval('institutions_id_institution_seq'::regclass),
  "name" character varying(255) NOT NULL,
  "rfc" character varying(20),
  "phone" character varying(50),
  "email" character varying(255),
  "fiscal_address" text,
  "admin_user_id" integer,
  "logo_url" character varying(500),
  "tagline" character varying(500),
  "exam_footer" text,
  "executive_contact" jsonb,
  "street" character varying(255),
  "exterior_number" character varying(50),
  "neighborhood" character varying(255),
  "municipality" character varying(255),
  "state" character varying(255),
  "postal_code" character varying(20),
  "max_teachers" integer DEFAULT 0,
  "max_students" integer DEFAULT 0,
  "max_exams" integer DEFAULT 0,
  "is_active" boolean DEFAULT true,
  "settings" jsonb,
  "created_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);

-- Table: modules
DROP TABLE IF EXISTS "modules" CASCADE;
CREATE TABLE "modules" (
  "id_module" integer NOT NULL DEFAULT nextval('modules_id_module_seq'::regclass),
  "code" character varying(50) NOT NULL,
  "name" character varying(100) NOT NULL,
  "description" text,
  "is_active" boolean DEFAULT true
);

-- Table: notifications
DROP TABLE IF EXISTS "notifications" CASCADE;
CREATE TABLE "notifications" (
  "id" integer NOT NULL DEFAULT nextval('notifications_id_seq'::regclass),
  "user_id" integer NOT NULL,
  "type" character varying(50) NOT NULL,
  "title" character varying(255) NOT NULL,
  "message" text,
  "is_read" boolean DEFAULT false,
  "related_service_id" integer,
  "created_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);

-- Table: question_bank
DROP TABLE IF EXISTS "question_bank" CASCADE;
CREATE TABLE "question_bank" (
  "id_question" integer NOT NULL DEFAULT nextval('question_bank_id_question_seq'::regclass),
  "institution_id" integer NOT NULL,
  "professor_id" integer NOT NULL,
  "category" character varying(100),
  "type" character varying(50) NOT NULL,
  "content" jsonb NOT NULL,
  "correct_answer" text NOT NULL,
  "is_active" boolean DEFAULT true,
  "created_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);

-- Table: roles
DROP TABLE IF EXISTS "roles" CASCADE;
CREATE TABLE "roles" (
  "id_role" integer NOT NULL DEFAULT nextval('roles_id_role_seq'::regclass),
  "code" character varying(50) NOT NULL,
  "name" character varying(100) NOT NULL,
  "description" text,
  "is_active" boolean DEFAULT true,
  "created_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);

-- Table: specialties
DROP TABLE IF EXISTS "specialties" CASCADE;
CREATE TABLE "specialties" (
  "id_specialty" integer NOT NULL DEFAULT nextval('specialties_id_specialty_seq'::regclass),
  "institution_id" integer NOT NULL,
  "name" character varying(255) NOT NULL,
  "description" text,
  "is_active" boolean DEFAULT true,
  "created_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);

-- Table: system_config
DROP TABLE IF EXISTS "system_config" CASCADE;
CREATE TABLE "system_config" (
  "config_key" character varying(100) NOT NULL,
  "config_value" text,
  "description" text,
  "updated_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);

-- Table: users
DROP TABLE IF EXISTS "users" CASCADE;
CREATE TABLE "users" (
  "id" integer NOT NULL DEFAULT nextval('users_id_seq'::regclass),
  "first_name" character varying(255) NOT NULL,
  "last_name" character varying(255) NOT NULL,
  "second_last_name" character varying(255),
  "email" character varying(255) NOT NULL,
  "password_hash" character varying(255) NOT NULL,
  "role" character varying(50) NOT NULL,
  "phone" character varying(50),
  "specialty" character varying(255),
  "client_number" character varying(50),
  "curp" character varying(18),
  "institution_id" integer,
  "photo_url" character varying(500),
  "is_active" boolean DEFAULT true,
  "created_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);

-- Primary Keys
ALTER TABLE ONLY "institutions" ADD CONSTRAINT "institutions_pkey" PRIMARY KEY ("id_institution");
ALTER TABLE ONLY "roles" ADD CONSTRAINT "roles_pkey" PRIMARY KEY ("id_role");
ALTER TABLE ONLY "users" ADD CONSTRAINT "users_pkey" PRIMARY KEY ("id");
ALTER TABLE ONLY "question_bank" ADD CONSTRAINT "question_bank_pkey" PRIMARY KEY ("id_question");
ALTER TABLE ONLY "exams" ADD CONSTRAINT "exams_pkey" PRIMARY KEY ("id_exam");
ALTER TABLE ONLY "exam_assignments" ADD CONSTRAINT "exam_assignments_pkey" PRIMARY KEY ("id_assignment");
ALTER TABLE ONLY "exam_questions" ADD CONSTRAINT "exam_questions_pkey" PRIMARY KEY ("exam_id");
ALTER TABLE ONLY "exam_questions" ADD CONSTRAINT "exam_questions_pkey" PRIMARY KEY ("question_id");
ALTER TABLE ONLY "exam_responses" ADD CONSTRAINT "exam_responses_pkey" PRIMARY KEY ("id_response");
ALTER TABLE ONLY "exam_logs" ADD CONSTRAINT "exam_logs_pkey" PRIMARY KEY ("id_log");
ALTER TABLE ONLY "notifications" ADD CONSTRAINT "notifications_pkey" PRIMARY KEY ("id");
ALTER TABLE ONLY "system_config" ADD CONSTRAINT "system_config_pkey" PRIMARY KEY ("config_key");
ALTER TABLE ONLY "modules" ADD CONSTRAINT "modules_pkey" PRIMARY KEY ("id_module");
ALTER TABLE ONLY "institution_modules" ADD CONSTRAINT "institution_modules_pkey" PRIMARY KEY ("institution_id");
ALTER TABLE ONLY "institution_modules" ADD CONSTRAINT "institution_modules_pkey" PRIMARY KEY ("module_id");
ALTER TABLE ONLY "specialties" ADD CONSTRAINT "specialties_pkey" PRIMARY KEY ("id_specialty");

-- Foreign Keys
ALTER TABLE ONLY "users" ADD CONSTRAINT "users_institution_id_fkey" FOREIGN KEY ("institution_id") REFERENCES "institutions"("id_institution") ON DELETE CASCADE;
ALTER TABLE ONLY "question_bank" ADD CONSTRAINT "question_bank_institution_id_fkey" FOREIGN KEY ("institution_id") REFERENCES "institutions"("id_institution") ON DELETE CASCADE;
ALTER TABLE ONLY "question_bank" ADD CONSTRAINT "question_bank_professor_id_fkey" FOREIGN KEY ("professor_id") REFERENCES "users"("id") ON DELETE CASCADE;
ALTER TABLE ONLY "exams" ADD CONSTRAINT "exams_institution_id_fkey" FOREIGN KEY ("institution_id") REFERENCES "institutions"("id_institution") ON DELETE CASCADE;
ALTER TABLE ONLY "exams" ADD CONSTRAINT "exams_professor_id_fkey" FOREIGN KEY ("professor_id") REFERENCES "users"("id") ON DELETE CASCADE;
ALTER TABLE ONLY "exam_assignments" ADD CONSTRAINT "exam_assignments_exam_id_fkey" FOREIGN KEY ("exam_id") REFERENCES "exams"("id_exam") ON DELETE CASCADE;
ALTER TABLE ONLY "exam_assignments" ADD CONSTRAINT "exam_assignments_student_id_fkey" FOREIGN KEY ("student_id") REFERENCES "users"("id") ON DELETE CASCADE;
ALTER TABLE ONLY "exam_questions" ADD CONSTRAINT "exam_questions_exam_id_fkey" FOREIGN KEY ("exam_id") REFERENCES "exams"("id_exam") ON DELETE CASCADE;
ALTER TABLE ONLY "exam_questions" ADD CONSTRAINT "exam_questions_question_id_fkey" FOREIGN KEY ("question_id") REFERENCES "question_bank"("id_question") ON DELETE CASCADE;
ALTER TABLE ONLY "exam_responses" ADD CONSTRAINT "exam_responses_assignment_id_fkey" FOREIGN KEY ("assignment_id") REFERENCES "exam_assignments"("id_assignment") ON DELETE CASCADE;
ALTER TABLE ONLY "exam_responses" ADD CONSTRAINT "exam_responses_question_id_fkey" FOREIGN KEY ("question_id") REFERENCES "question_bank"("id_question") ON DELETE CASCADE;
ALTER TABLE ONLY "exam_logs" ADD CONSTRAINT "exam_logs_assignment_id_fkey" FOREIGN KEY ("assignment_id") REFERENCES "exam_assignments"("id_assignment") ON DELETE CASCADE;
ALTER TABLE ONLY "notifications" ADD CONSTRAINT "notifications_user_id_fkey" FOREIGN KEY ("user_id") REFERENCES "users"("id") ON DELETE CASCADE;
ALTER TABLE ONLY "institution_modules" ADD CONSTRAINT "institution_modules_institution_id_fkey" FOREIGN KEY ("institution_id") REFERENCES "institutions"("id_institution") ON DELETE CASCADE;
ALTER TABLE ONLY "institution_modules" ADD CONSTRAINT "institution_modules_module_id_fkey" FOREIGN KEY ("module_id") REFERENCES "modules"("id_module") ON DELETE CASCADE;
ALTER TABLE ONLY "specialties" ADD CONSTRAINT "specialties_institution_id_fkey" FOREIGN KEY ("institution_id") REFERENCES "institutions"("id_institution") ON DELETE CASCADE;

-- Indexes
CREATE INDEX idx_users_email ON public.users USING btree (email);
CREATE INDEX idx_users_institution_id ON public.users USING btree (institution_id);
CREATE INDEX idx_users_first_name ON public.users USING btree (first_name);
CREATE INDEX idx_users_last_name ON public.users USING btree (last_name);
CREATE UNIQUE INDEX users_phone_key ON public.users USING btree (phone) WHERE (phone IS NOT NULL);
CREATE UNIQUE INDEX users_curp_key ON public.users USING btree (curp) WHERE (curp IS NOT NULL);
CREATE INDEX idx_question_bank_institution ON public.question_bank USING btree (institution_id);
CREATE INDEX idx_question_bank_professor ON public.question_bank USING btree (professor_id);
CREATE INDEX idx_question_bank_category ON public.question_bank USING btree (category);
CREATE INDEX idx_exams_institution ON public.exams USING btree (institution_id);
CREATE INDEX idx_exam_assignments_student ON public.exam_assignments USING btree (student_id);
CREATE INDEX idx_exam_assignments_exam ON public.exam_assignments USING btree (exam_id);
CREATE INDEX idx_exam_assignments_status ON public.exam_assignments USING btree (status);
CREATE INDEX idx_exam_assignments_exam_student_attempt ON public.exam_assignments USING btree (exam_id, student_id, attempt_number DESC);
CREATE INDEX idx_exam_assignments_scheduled ON public.exam_assignments USING btree (scheduled_at) WHERE (scheduled_at IS NOT NULL);
CREATE INDEX idx_exam_questions_exam ON public.exam_questions USING btree (exam_id);
CREATE INDEX idx_exam_questions_question ON public.exam_questions USING btree (question_id);
CREATE INDEX idx_exam_responses_assignment ON public.exam_responses USING btree (assignment_id);
CREATE INDEX idx_exam_responses_question ON public.exam_responses USING btree (question_id);
CREATE INDEX idx_exam_logs_assignment ON public.exam_logs USING btree (assignment_id);
CREATE INDEX idx_notifications_user ON public.notifications USING btree (user_id);
CREATE INDEX idx_notifications_is_read ON public.notifications USING btree (is_read);
CREATE INDEX idx_specialties_institution ON public.specialties USING btree (institution_id);
CREATE INDEX idx_specialties_active ON public.specialties USING btree (is_active);
