/*
  Migración: Agregar constraints UNIQUE a CURP y teléfono
  Fecha: 2025-01-XX
  Descripción: 
    - Agrega constraint UNIQUE a phone (teléfono)
    - Agrega constraint UNIQUE a curp
    - Limpia duplicados antes de agregar los constraints
*/

-- 1. Limpiar duplicados de teléfono (mantener el más reciente)
UPDATE "public"."users" u1
SET phone = NULL
WHERE phone IS NOT NULL 
  AND EXISTS (
    SELECT 1 
    FROM "public"."users" u2 
    WHERE u2.phone = u1.phone 
      AND u2.id != u1.id 
      AND u2.created_at > u1.created_at
  );

-- 2. Limpiar duplicados de CURP (mantener el más reciente)
UPDATE "public"."users" u1
SET curp = NULL
WHERE curp IS NOT NULL 
  AND EXISTS (
    SELECT 1 
    FROM "public"."users" u2 
    WHERE u2.curp = u1.curp 
      AND u2.id != u1.id 
      AND u2.created_at > u1.created_at
  );

-- 3. Agregar constraint UNIQUE a phone si no existe
-- Nota: En PostgreSQL, UNIQUE permite múltiples NULL, así que esto es seguro
DO $$
BEGIN
    IF NOT EXISTS (
        SELECT 1 
        FROM pg_indexes 
        WHERE schemaname = 'public' 
        AND tablename = 'users' 
        AND indexname = 'users_phone_key'
    ) THEN
        -- Crear índice único parcial que excluye NULLs
        CREATE UNIQUE INDEX "users_phone_key" ON "public"."users" ("phone") 
        WHERE "phone" IS NOT NULL;
        RAISE NOTICE 'Índice único users_phone_key creado';
    ELSE
        RAISE NOTICE 'Índice único users_phone_key ya existe';
    END IF;
END $$;

-- 4. Agregar constraint UNIQUE a curp si no existe
-- Nota: En PostgreSQL, UNIQUE permite múltiples NULL, así que esto es seguro
DO $$
BEGIN
    IF NOT EXISTS (
        SELECT 1 
        FROM pg_indexes 
        WHERE schemaname = 'public' 
        AND tablename = 'users' 
        AND indexname = 'users_curp_key'
    ) THEN
        -- Crear índice único parcial que excluye NULLs
        CREATE UNIQUE INDEX "users_curp_key" ON "public"."users" ("curp") 
        WHERE "curp" IS NOT NULL;
        RAISE NOTICE 'Índice único users_curp_key creado';
    ELSE
        RAISE NOTICE 'Índice único users_curp_key ya existe';
    END IF;
END $$;

