/*
  Migración: Separar campo 'name' en first_name, last_name, second_last_name
  Fecha: 2025-01-XX
  Descripción: 
    - Agrega campos first_name, last_name, second_last_name
    - Migra datos existentes del campo 'name' a los nuevos campos
    - Hace first_name y last_name NOT NULL
    - Elimina el campo 'name' antiguo
*/

-- 1. Agregar los nuevos campos (temporalmente nullable para migración)
ALTER TABLE "public"."users" 
ADD COLUMN IF NOT EXISTS "first_name" varchar(255),
ADD COLUMN IF NOT EXISTS "last_name" varchar(255),
ADD COLUMN IF NOT EXISTS "second_last_name" varchar(255);

-- 2. Migrar datos existentes del campo 'name' a los nuevos campos
-- Intentar dividir el nombre completo en partes
UPDATE "public"."users"
SET 
    "first_name" = CASE 
        WHEN "name" IS NOT NULL AND "name" != '' THEN
            -- Tomar la primera palabra como nombre
            SPLIT_PART(TRIM("name"), ' ', 1)
        ELSE NULL
    END,
    "last_name" = CASE 
        WHEN "name" IS NOT NULL AND "name" != '' AND array_length(string_to_array(TRIM("name"), ' '), 1) >= 2 THEN
            -- Tomar la segunda palabra como primer apellido
            SPLIT_PART(TRIM("name"), ' ', 2)
        ELSE NULL
    END,
    "second_last_name" = CASE 
        WHEN "name" IS NOT NULL AND "name" != '' AND array_length(string_to_array(TRIM("name"), ' '), 1) > 2 THEN
            -- Tomar el resto como segundo apellido
            array_to_string((string_to_array(TRIM("name"), ' '))[3:], ' ')
        ELSE NULL
    END
WHERE "name" IS NOT NULL AND "name" != '';

-- 3. Para registros sin nombre, establecer valores por defecto
UPDATE "public"."users"
SET 
    "first_name" = COALESCE("first_name", 'Usuario'),
    "last_name" = COALESCE("last_name", 'Sin Apellido')
WHERE "first_name" IS NULL OR "last_name" IS NULL;

-- 4. Hacer los campos obligatorios
ALTER TABLE "public"."users" 
ALTER COLUMN "first_name" SET NOT NULL,
ALTER COLUMN "last_name" SET NOT NULL;

-- 5. Eliminar el campo 'name' antiguo
ALTER TABLE "public"."users" DROP COLUMN IF EXISTS "name";

-- 6. Crear índice para búsquedas por nombre si es necesario
CREATE INDEX IF NOT EXISTS "idx_users_first_name" ON "public"."users" ("first_name");
CREATE INDEX IF NOT EXISTS "idx_users_last_name" ON "public"."users" ("last_name");


