/*
 Migración del esquema de producción de KeQuiz
 Agrega tablas y columnas faltantes sin perder datos existentes
*/

-- 1. Agregar columna tolerance_minutes a exams si no existe
DO $$ 
BEGIN
    IF NOT EXISTS (
        SELECT 1 FROM information_schema.columns 
        WHERE table_schema = 'public' 
        AND table_name = 'exams' 
        AND column_name = 'tolerance_minutes'
    ) THEN
        ALTER TABLE "public"."exams" ADD COLUMN "tolerance_minutes" int4 DEFAULT 15;
    END IF;
END $$;

-- 2. Agregar columnas faltantes a exam_assignments
DO $$ 
BEGIN
    -- attempt_number
    IF NOT EXISTS (
        SELECT 1 FROM information_schema.columns 
        WHERE table_schema = 'public' 
        AND table_name = 'exam_assignments' 
        AND column_name = 'attempt_number'
    ) THEN
        ALTER TABLE "public"."exam_assignments" ADD COLUMN "attempt_number" int4 DEFAULT 1;
        -- Actualizar registros existentes
        UPDATE "public"."exam_assignments" SET "attempt_number" = 1 WHERE "attempt_number" IS NULL;
    END IF;

    -- scheduled_at
    IF NOT EXISTS (
        SELECT 1 FROM information_schema.columns 
        WHERE table_schema = 'public' 
        AND table_name = 'exam_assignments' 
        AND column_name = 'scheduled_at'
    ) THEN
        ALTER TABLE "public"."exam_assignments" ADD COLUMN "scheduled_at" timestamp(6);
    END IF;

    -- scheduled_end_at
    IF NOT EXISTS (
        SELECT 1 FROM information_schema.columns 
        WHERE table_schema = 'public' 
        AND table_name = 'exam_assignments' 
        AND column_name = 'scheduled_end_at'
    ) THEN
        ALTER TABLE "public"."exam_assignments" ADD COLUMN "scheduled_end_at" timestamp(6);
    END IF;

    -- completed_at (mantener finished_at también por compatibilidad)
    IF NOT EXISTS (
        SELECT 1 FROM information_schema.columns 
        WHERE table_schema = 'public' 
        AND table_name = 'exam_assignments' 
        AND column_name = 'completed_at'
    ) THEN
        ALTER TABLE "public"."exam_assignments" ADD COLUMN "completed_at" timestamp(6);
        -- Copiar datos de finished_at a completed_at si existe
        UPDATE "public"."exam_assignments" 
        SET "completed_at" = "finished_at" 
        WHERE "finished_at" IS NOT NULL AND "completed_at" IS NULL;
    END IF;

    -- Actualizar status si es necesario (ACTIVE -> IN_PROGRESS, FINISHED -> COMPLETED)
    UPDATE "public"."exam_assignments" 
    SET "status" = 'IN_PROGRESS' 
    WHERE "status" = 'ACTIVE';

    UPDATE "public"."exam_assignments" 
    SET "status" = 'COMPLETED' 
    WHERE "status" = 'FINISHED';
END $$;

-- 3. Crear tabla exam_questions si no existe
CREATE TABLE IF NOT EXISTS "public"."exam_questions" (
  "exam_id" int4 NOT NULL,
  "question_id" int4 NOT NULL,
  "order_index" int4 NOT NULL DEFAULT 0,
  PRIMARY KEY ("exam_id", "question_id"),
  FOREIGN KEY ("exam_id") REFERENCES "public"."exams" ("id_exam") ON DELETE CASCADE,
  FOREIGN KEY ("question_id") REFERENCES "public"."question_bank" ("id_question") ON DELETE CASCADE
);

-- 4. Crear tabla exam_responses si no existe
CREATE TABLE IF NOT EXISTS "public"."exam_responses" (
  "id_response" SERIAL PRIMARY KEY,
  "assignment_id" int4 NOT NULL,
  "question_id" int4 NOT NULL,
  "student_answer" text,
  "is_correct" bool,
  "points_earned" numeric(5,2) DEFAULT 0,
  "feedback" text,
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY ("assignment_id") REFERENCES "public"."exam_assignments" ("id_assignment") ON DELETE CASCADE,
  FOREIGN KEY ("question_id") REFERENCES "public"."question_bank" ("id_question") ON DELETE CASCADE,
  UNIQUE ("assignment_id", "question_id")
);

-- 5. Crear índices si no existen
CREATE INDEX IF NOT EXISTS "idx_exam_assignments_exam" ON "public"."exam_assignments" ("exam_id");
CREATE INDEX IF NOT EXISTS "idx_exam_assignments_status" ON "public"."exam_assignments" ("status");
CREATE INDEX IF NOT EXISTS "idx_exam_questions_exam" ON "public"."exam_questions" ("exam_id");
CREATE INDEX IF NOT EXISTS "idx_exam_questions_question" ON "public"."exam_questions" ("question_id");
CREATE INDEX IF NOT EXISTS "idx_exam_responses_assignment" ON "public"."exam_responses" ("assignment_id");
CREATE INDEX IF NOT EXISTS "idx_exam_responses_question" ON "public"."exam_responses" ("question_id");


