/*
 Navicat Premium Data Transfer

 Source Server         : Poatgres VM
 Source Server Type    : PostgreSQL
 Source Server Version : 170006 (170006)
 Source Host           : 172.16.215.130:5432
 Source Catalog        : keservicios
 Source Schema         : public

 Target Server Type    : PostgreSQL
 Target Server Version : 170006 (170006)
 File Encoding         : 65001

 Date: 11/12/2025 02:11:16
*/


-- ----------------------------
-- Type structure for service_status
-- ----------------------------
DROP TYPE IF EXISTS "public"."service_status";
CREATE TYPE "public"."service_status" AS ENUM (
  'PENDING',
  'IN_PROGRESS',
  'FINISHED',
  'CANCELLED',
  'CERRADO_ADMIN'
);
ALTER TYPE "public"."service_status" OWNER TO "iger";

-- ----------------------------
-- Type structure for user_role
-- ----------------------------
DROP TYPE IF EXISTS "public"."user_role";
CREATE TYPE "public"."user_role" AS ENUM (
  'ADMIN',
  'EMPLOYEE',
  'CLIENT',
  'ROOT'
);
ALTER TYPE "public"."user_role" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for companies_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."companies_id_seq";
CREATE SEQUENCE "public"."companies_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."companies_id_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for evidences_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."evidences_id_seq";
CREATE SEQUENCE "public"."evidences_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."evidences_id_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for modules_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."modules_id_seq";
CREATE SEQUENCE "public"."modules_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."modules_id_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for services_catalogo_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."services_catalogo_id_seq";
CREATE SEQUENCE "public"."services_catalogo_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."services_catalogo_id_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for system_config_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."system_config_id_seq";
CREATE SEQUENCE "public"."system_config_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."system_config_id_seq" OWNER TO "iger";

-- ----------------------------
-- Table structure for clients
-- ----------------------------
DROP TABLE IF EXISTS "public"."clients";
CREATE TABLE "public"."clients" (
  "user_id" uuid NOT NULL,
  "client_number" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "phone" varchar(50) COLLATE "pg_catalog"."default",
  "fiscal_name" varchar(255) COLLATE "pg_catalog"."default",
  "rfc" varchar(20) COLLATE "pg_catalog"."default",
  "fiscal_address" text COLLATE "pg_catalog"."default",
  "alternate_address" text COLLATE "pg_catalog"."default",
  "address" text COLLATE "pg_catalog"."default",
  "company_id" int4,
  "allow_access_without_service" bool DEFAULT false
)
;
ALTER TABLE "public"."clients" OWNER TO "iger";

-- ----------------------------
-- Records of clients
-- ----------------------------
BEGIN;
INSERT INTO "public"."clients" ("user_id", "client_number", "name", "phone", "fiscal_name", "rfc", "fiscal_address", "alternate_address", "address", "company_id", "allow_access_without_service") VALUES ('0740e396-630b-4b83-996b-edc48d911470', 'CLI-001', 'Juan Perez', '555-123-4567', NULL, NULL, NULL, NULL, 'Calle Falsa 123', 1, 'f');
COMMIT;

-- ----------------------------
-- Table structure for companies
-- ----------------------------
DROP TABLE IF EXISTS "public"."companies";
CREATE TABLE "public"."companies" (
  "id" int4 NOT NULL DEFAULT nextval('companies_id_seq'::regclass),
  "name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "schema_name" varchar(50) COLLATE "pg_catalog"."default",
  "is_active" bool DEFAULT true,
  "created_at" timestamp(6) DEFAULT now(),
  "logo_url" varchar(255) COLLATE "pg_catalog"."default",
  "slogan" varchar(255) COLLATE "pg_catalog"."default",
  "service_completion_message" text COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "public"."companies" OWNER TO "iger";

-- ----------------------------
-- Records of companies
-- ----------------------------
BEGIN;
INSERT INTO "public"."companies" ("id", "name", "schema_name", "is_active", "created_at", "logo_url", "slogan", "service_completion_message") VALUES (1, 'Default Company', NULL, 't', '2025-12-09 01:15:22.336292', NULL, NULL, NULL);
COMMIT;

-- ----------------------------
-- Table structure for company_modules
-- ----------------------------
DROP TABLE IF EXISTS "public"."company_modules";
CREATE TABLE "public"."company_modules" (
  "company_id" int4 NOT NULL,
  "module_id" int4 NOT NULL,
  "is_enabled" bool DEFAULT true
)
;
ALTER TABLE "public"."company_modules" OWNER TO "iger";

-- ----------------------------
-- Records of company_modules
-- ----------------------------
BEGIN;
INSERT INTO "public"."company_modules" ("company_id", "module_id", "is_enabled") VALUES (1, 1, 't');
INSERT INTO "public"."company_modules" ("company_id", "module_id", "is_enabled") VALUES (1, 2, 't');
INSERT INTO "public"."company_modules" ("company_id", "module_id", "is_enabled") VALUES (1, 3, 't');
INSERT INTO "public"."company_modules" ("company_id", "module_id", "is_enabled") VALUES (1, 4, 't');
INSERT INTO "public"."company_modules" ("company_id", "module_id", "is_enabled") VALUES (1, 5, 't');
COMMIT;

-- ----------------------------
-- Table structure for contracted_services
-- ----------------------------
DROP TABLE IF EXISTS "public"."contracted_services";
CREATE TABLE "public"."contracted_services" (
  "id" uuid NOT NULL DEFAULT gen_random_uuid(),
  "service_number" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "client_id" uuid NOT NULL,
  "service_catalogo_id" int4 NOT NULL,
  "employee_id" uuid,
  "service_address" text COLLATE "pg_catalog"."default" NOT NULL,
  "request_date" timestamp(6) DEFAULT now(),
  "deadline_date" timestamp(6) NOT NULL,
  "status" "public"."service_status" DEFAULT 'PENDING'::service_status,
  "employee_report" text COLLATE "pg_catalog"."default",
  "closed_at" timestamp(6),
  "client_rating" int4,
  "client_comment" text COLLATE "pg_catalog"."default",
  "finalized_by_client" bool DEFAULT false,
  "company_id" int4,
  "warranty_end_date" timestamp(6),
  "payment_reference" varchar(100),
  "payment_status" varchar(20) DEFAULT 'PENDING'::character varying,
  "payment_proof_url" text COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "public"."contracted_services" OWNER TO "iger";

-- ----------------------------
-- Records of contracted_services
-- ----------------------------
BEGIN;
INSERT INTO "public"."contracted_services" ("id", "service_number", "client_id", "service_catalogo_id", "employee_id", "service_address", "request_date", "deadline_date", "status", "employee_report", "closed_at", "client_rating", "client_comment", "finalized_by_client", "company_id", "warranty_end_date") VALUES ('91fbbeb6-d3b3-4b26-a257-5f7d9ef94009', 'SRV-2025-9929', '0740e396-630b-4b83-996b-edc48d911470', 1, NULL, 'Calle Falsa 123', '2025-12-08 00:07:49.929', '2025-12-10 00:07:49.929', 'PENDING', NULL, NULL, NULL, NULL, 'f', 1, NULL);
COMMIT;

-- ----------------------------
-- Table structure for employees
-- ----------------------------
DROP TABLE IF EXISTS "public"."employees";
CREATE TABLE "public"."employees" (
  "user_id" uuid NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "phone" varchar(50) COLLATE "pg_catalog"."default",
  "area" varchar(100) COLLATE "pg_catalog"."default",
  "is_active" bool DEFAULT true,
  "company_id" int4
)
;
ALTER TABLE "public"."employees" OWNER TO "iger";

-- ----------------------------
-- Records of employees
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for evidences
-- ----------------------------
DROP TABLE IF EXISTS "public"."evidences";
CREATE TABLE "public"."evidences" (
  "id" int4 NOT NULL DEFAULT nextval('evidences_id_seq'::regclass),
  "contracted_service_id" uuid NOT NULL,
  "uploaded_by" uuid NOT NULL,
  "file_url" text COLLATE "pg_catalog"."default" NOT NULL,
  "file_type" varchar(50) COLLATE "pg_catalog"."default",
  "uploaded_at" timestamp(6) DEFAULT now()
)
;
ALTER TABLE "public"."evidences" OWNER TO "iger";

-- ----------------------------
-- Records of evidences
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for modules
-- ----------------------------
DROP TABLE IF EXISTS "public"."modules";
CREATE TABLE "public"."modules" (
  "id" int4 NOT NULL DEFAULT nextval('modules_id_seq'::regclass),
  "name" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "description" text COLLATE "pg_catalog"."default",
  "route_path" varchar(255) COLLATE "pg_catalog"."default",
  "icon" varchar(50) COLLATE "pg_catalog"."default",
  "is_active" bool DEFAULT true,
  "created_at" timestamp(6) DEFAULT now()
)
;
ALTER TABLE "public"."modules" OWNER TO "iger";

-- ----------------------------
-- Records of modules
-- ----------------------------
BEGIN;
INSERT INTO "public"."modules" ("id", "name", "description", "route_path", "icon", "is_active", "created_at") VALUES (1, 'Gestión de Clientes', 'Administración de clientes', '/admin/clients', 'FiUsers', 't', '2025-12-09 13:50:42.638344');
INSERT INTO "public"."modules" ("id", "name", "description", "route_path", "icon", "is_active", "created_at") VALUES (2, 'Catálogo de Servicios', 'Gestión del catálogo de servicios', '/admin/services', 'FiList', 't', '2025-12-09 13:50:42.638344');
INSERT INTO "public"."modules" ("id", "name", "description", "route_path", "icon", "is_active", "created_at") VALUES (3, 'Órdenes de Servicio', 'Gestión de órdenes de servicio', '/admin/orders', 'FiFileText', 't', '2025-12-09 13:50:42.638344');
INSERT INTO "public"."modules" ("id", "name", "description", "route_path", "icon", "is_active", "created_at") VALUES (4, 'Monitor de Servicios', 'Calendario de servicios', '/admin/dashboard', 'FiCalendar', 't', '2025-12-09 13:50:42.638344');
INSERT INTO "public"."modules" ("id", "name", "description", "route_path", "icon", "is_active", "created_at") VALUES (5, 'Gestión de Empleados', 'Administración de empleados', '/admin/employees', 'FiBriefcase', 't', '2025-12-09 13:50:42.638344');
COMMIT;

-- ----------------------------
-- Table structure for services_catalogo
-- ----------------------------
DROP TABLE IF EXISTS "public"."services_catalogo";
CREATE TABLE "public"."services_catalogo" (
  "id" int4 NOT NULL DEFAULT nextval('services_catalogo_id_seq'::regclass),
  "name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "description" text COLLATE "pg_catalog"."default",
  "max_time_hours" int4 NOT NULL,
  "category" varchar(100) COLLATE "pg_catalog"."default",
  "is_active" bool DEFAULT true,
  "company_id" int4,
  "has_warranty" bool DEFAULT false,
  "warranty_months" int4 DEFAULT 0,
  "warranty_exceptions" text COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "public"."services_catalogo" OWNER TO "iger";

-- ----------------------------
-- Records of services_catalogo
-- ----------------------------
BEGIN;
INSERT INTO "public"."services_catalogo" ("id", "name", "description", "max_time_hours", "category", "is_active", "company_id", "has_warranty", "warranty_months", "warranty_exceptions") VALUES (1, 'Mantenimiento Preventivo', 'Limpieza y ajuste general', 48, 'Mantenimiento', 't', 1, 'f', 0, NULL);
COMMIT;

-- ----------------------------
-- Table structure for system_config
-- ----------------------------
DROP TABLE IF EXISTS "public"."system_config";
CREATE TABLE "public"."system_config" (
  "id" int4 NOT NULL DEFAULT nextval('system_config_id_seq'::regclass),
  "config_key" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "config_value" text COLLATE "pg_catalog"."default",
  "created_at" timestamp(6) DEFAULT now(),
  "updated_at" timestamp(6) DEFAULT now()
)
;
ALTER TABLE "public"."system_config" OWNER TO "iger";

-- ----------------------------
-- Records of system_config
-- ----------------------------
BEGIN;
INSERT INTO "public"."system_config" ("id", "config_key", "config_value", "created_at", "updated_at") VALUES (1, 'footer_text', '© 2025 KeServicios - Todos los derechos reservados', '2025-12-09 14:12:14.337428', '2025-12-09 14:12:14.337428');
INSERT INTO "public"."system_config" ("id", "config_key", "config_value", "created_at", "updated_at") VALUES (2, 'footer_link_text', 'Política de Privacidad', '2025-12-09 14:12:14.337428', '2025-12-09 14:12:14.337428');
INSERT INTO "public"."system_config" ("id", "config_key", "config_value", "created_at", "updated_at") VALUES (3, 'footer_link_url', 'https://ejemplo.com/privacidad', '2025-12-09 14:12:14.337428', '2025-12-09 14:12:14.337428');
COMMIT;

-- ----------------------------
-- Table structure for users
-- ----------------------------
DROP TABLE IF EXISTS "public"."users";
CREATE TABLE "public"."users" (
  "id" uuid NOT NULL DEFAULT gen_random_uuid(),
  "email" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "password_hash" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "role" "public"."user_role" NOT NULL,
  "created_at" timestamp(6) DEFAULT now(),
  "is_active" bool DEFAULT true,
  "company_id" int4
)
;
ALTER TABLE "public"."users" OWNER TO "iger";

-- ----------------------------
-- Records of users
-- ----------------------------
BEGIN;
INSERT INTO "public"."users" ("id", "email", "password_hash", "role", "created_at", "is_active", "company_id") VALUES ('e818065d-3be7-4b67-923f-f79157573911', 'admin@keservicios.com', '$2b$10$idOc3w5q98izHnubzdLAaOXy5fvywj.OQkbdK3azkuMZqdQpNjd06', 'ADMIN', '2025-12-08 00:05:03.454699', 't', 1);
INSERT INTO "public"."users" ("id", "email", "password_hash", "role", "created_at", "is_active", "company_id") VALUES ('0740e396-630b-4b83-996b-edc48d911470', 'cliente@test.com', '$2b$10$wExOHeQ5YuxzPPVbJVNP9.hM9GpAK55us2ffdAcGsE6YQXCwp57R6', 'CLIENT', '2025-12-08 00:07:42.867813', 't', 1);
INSERT INTO "public"."users" ("id", "email", "password_hash", "role", "created_at", "is_active", "company_id") VALUES ('c0d16ca8-4cae-4687-8056-6cee3c970703', 'root@keservicios.com', '$2b$10$3MlCr82dzoyPmrSXF2P/ZONa1.pIqU4ctmAW1dpuOQzJ1ccWAwfuW', 'ROOT', '2025-12-09 13:45:15.533164', 't', NULL);
COMMIT;

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."companies_id_seq"
OWNED BY "public"."companies"."id";
SELECT setval('"public"."companies_id_seq"', 1, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."evidences_id_seq"
OWNED BY "public"."evidences"."id";
SELECT setval('"public"."evidences_id_seq"', 1, false);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."modules_id_seq"
OWNED BY "public"."modules"."id";
SELECT setval('"public"."modules_id_seq"', 5, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."services_catalogo_id_seq"
OWNED BY "public"."services_catalogo"."id";
SELECT setval('"public"."services_catalogo_id_seq"', 1, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."system_config_id_seq"
OWNED BY "public"."system_config"."id";
SELECT setval('"public"."system_config_id_seq"', 3, true);

-- ----------------------------
-- Uniques structure for table clients
-- ----------------------------
ALTER TABLE "public"."clients" ADD CONSTRAINT "clients_client_number_key" UNIQUE ("client_number");

-- ----------------------------
-- Primary Key structure for table clients
-- ----------------------------
ALTER TABLE "public"."clients" ADD CONSTRAINT "clients_pkey" PRIMARY KEY ("user_id");

-- ----------------------------
-- Primary Key structure for table companies
-- ----------------------------
ALTER TABLE "public"."companies" ADD CONSTRAINT "companies_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table company_modules
-- ----------------------------
ALTER TABLE "public"."company_modules" ADD CONSTRAINT "company_modules_pkey" PRIMARY KEY ("company_id", "module_id");

-- ----------------------------
-- Indexes structure for table contracted_services
-- ----------------------------
CREATE INDEX "idx_contracted_services_client" ON "public"."contracted_services" USING btree (
  "client_id" "pg_catalog"."uuid_ops" ASC NULLS LAST
);
CREATE INDEX "idx_contracted_services_deadline" ON "public"."contracted_services" USING btree (
  "deadline_date" "pg_catalog"."timestamp_ops" ASC NULLS LAST
);
CREATE INDEX "idx_contracted_services_employee" ON "public"."contracted_services" USING btree (
  "employee_id" "pg_catalog"."uuid_ops" ASC NULLS LAST
);

-- ----------------------------
-- Uniques structure for table contracted_services
-- ----------------------------
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_service_number_key" UNIQUE ("service_number");

-- ----------------------------
-- Checks structure for table contracted_services
-- ----------------------------
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_client_rating_check" CHECK (client_rating >= 1 AND client_rating <= 5);

-- ----------------------------
-- Primary Key structure for table contracted_services
-- ----------------------------
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table employees
-- ----------------------------
ALTER TABLE "public"."employees" ADD CONSTRAINT "employees_pkey" PRIMARY KEY ("user_id");

-- ----------------------------
-- Primary Key structure for table evidences
-- ----------------------------
ALTER TABLE "public"."evidences" ADD CONSTRAINT "evidences_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Uniques structure for table modules
-- ----------------------------
ALTER TABLE "public"."modules" ADD CONSTRAINT "modules_name_key" UNIQUE ("name");

-- ----------------------------
-- Primary Key structure for table modules
-- ----------------------------
ALTER TABLE "public"."modules" ADD CONSTRAINT "modules_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table services_catalogo
-- ----------------------------
ALTER TABLE "public"."services_catalogo" ADD CONSTRAINT "services_catalogo_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Uniques structure for table system_config
-- ----------------------------
ALTER TABLE "public"."system_config" ADD CONSTRAINT "system_config_config_key_key" UNIQUE ("config_key");

-- ----------------------------
-- Primary Key structure for table system_config
-- ----------------------------
ALTER TABLE "public"."system_config" ADD CONSTRAINT "system_config_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Uniques structure for table users
-- ----------------------------
ALTER TABLE "public"."users" ADD CONSTRAINT "users_email_key" UNIQUE ("email");

-- ----------------------------
-- Primary Key structure for table users
-- ----------------------------
ALTER TABLE "public"."users" ADD CONSTRAINT "users_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Foreign Keys structure for table clients
-- ----------------------------
ALTER TABLE "public"."clients" ADD CONSTRAINT "clients_company_id_fkey" FOREIGN KEY ("company_id") REFERENCES "public"."companies" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."clients" ADD CONSTRAINT "clients_user_id_fkey" FOREIGN KEY ("user_id") REFERENCES "public"."users" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table company_modules
-- ----------------------------
ALTER TABLE "public"."company_modules" ADD CONSTRAINT "company_modules_company_id_fkey" FOREIGN KEY ("company_id") REFERENCES "public"."companies" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."company_modules" ADD CONSTRAINT "company_modules_module_id_fkey" FOREIGN KEY ("module_id") REFERENCES "public"."modules" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table contracted_services
-- ----------------------------
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_client_id_fkey" FOREIGN KEY ("client_id") REFERENCES "public"."clients" ("user_id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_company_id_fkey" FOREIGN KEY ("company_id") REFERENCES "public"."companies" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_employee_id_fkey" FOREIGN KEY ("employee_id") REFERENCES "public"."employees" ("user_id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_service_catalogo_id_fkey" FOREIGN KEY ("service_catalogo_id") REFERENCES "public"."services_catalogo" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table employees
-- ----------------------------
ALTER TABLE "public"."employees" ADD CONSTRAINT "employees_company_id_fkey" FOREIGN KEY ("company_id") REFERENCES "public"."companies" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."employees" ADD CONSTRAINT "employees_user_id_fkey" FOREIGN KEY ("user_id") REFERENCES "public"."users" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table evidences
-- ----------------------------
ALTER TABLE "public"."evidences" ADD CONSTRAINT "evidences_contracted_service_id_fkey" FOREIGN KEY ("contracted_service_id") REFERENCES "public"."contracted_services" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."evidences" ADD CONSTRAINT "evidences_uploaded_by_fkey" FOREIGN KEY ("uploaded_by") REFERENCES "public"."users" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table services_catalogo
-- ----------------------------
ALTER TABLE "public"."services_catalogo" ADD CONSTRAINT "services_catalogo_company_id_fkey" FOREIGN KEY ("company_id") REFERENCES "public"."companies" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table users
-- ----------------------------
ALTER TABLE "public"."users" ADD CONSTRAINT "users_company_id_fkey" FOREIGN KEY ("company_id") REFERENCES "public"."companies" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION;
