/*
 Navicat Premium Data Transfer

 Source Server         : Poatgres VM
 Source Server Type    : PostgreSQL
 Source Server Version : 170006 (170006)
 Source Host           : 172.16.215.130:5432
 Source Catalog        : keservicios
 Source Schema         : public

 Target Server Type    : PostgreSQL
 Target Server Version : 170006 (170006)
 File Encoding         : 65001

 Date: 16/12/2025 01:23:41
*/


-- ----------------------------
-- Type structure for service_status
-- ----------------------------
DROP TYPE IF EXISTS "public"."service_status";
CREATE TYPE "public"."service_status" AS ENUM (
  'PENDING',
  'IN_PROGRESS',
  'FINISHED',
  'CANCELLED',
  'CERRADO_ADMIN'
);
ALTER TYPE "public"."service_status" OWNER TO "iger";

-- ----------------------------
-- Type structure for user_role
-- ----------------------------
DROP TYPE IF EXISTS "public"."user_role";
CREATE TYPE "public"."user_role" AS ENUM (
  'ADMIN',
  'EMPLOYEE',
  'CLIENT',
  'ROOT'
);
ALTER TYPE "public"."user_role" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for clients_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."clients_id_seq";
CREATE SEQUENCE "public"."clients_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."clients_id_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for companies_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."companies_id_seq";
CREATE SEQUENCE "public"."companies_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."companies_id_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for company_modules_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."company_modules_id_seq";
CREATE SEQUENCE "public"."company_modules_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."company_modules_id_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for contracted_services_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."contracted_services_id_seq";
CREATE SEQUENCE "public"."contracted_services_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."contracted_services_id_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for employees_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."employees_id_seq";
CREATE SEQUENCE "public"."employees_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."employees_id_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for evidences_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."evidences_id_seq";
CREATE SEQUENCE "public"."evidences_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."evidences_id_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for modules_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."modules_id_seq";
CREATE SEQUENCE "public"."modules_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."modules_id_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for services_catalog_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."services_catalog_id_seq";
CREATE SEQUENCE "public"."services_catalog_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."services_catalog_id_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for services_catalogo_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."services_catalogo_id_seq";
CREATE SEQUENCE "public"."services_catalogo_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."services_catalogo_id_seq" OWNER TO "iger";

-- ----------------------------
-- Sequence structure for system_config_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."system_config_id_seq";
CREATE SEQUENCE "public"."system_config_id_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;
ALTER SEQUENCE "public"."system_config_id_seq" OWNER TO "iger";

-- ----------------------------
-- Table structure for clients
-- ----------------------------
DROP TABLE IF EXISTS "public"."clients";
CREATE TABLE "public"."clients" (
  "id" int4 NOT NULL DEFAULT nextval('clients_id_seq'::regclass),
  "user_id" varchar(50) COLLATE "pg_catalog"."default",
  "company_id" int4,
  "client_number" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "phone" varchar(20) COLLATE "pg_catalog"."default",
  "fiscal_name" varchar(255) COLLATE "pg_catalog"."default",
  "rfc" varchar(13) COLLATE "pg_catalog"."default",
  "fiscal_address" text COLLATE "pg_catalog"."default",
  "address" text COLLATE "pg_catalog"."default",
  "alternate_address" text COLLATE "pg_catalog"."default",
  "allow_access_without_service" bool DEFAULT false,
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."clients" OWNER TO "iger";

-- ----------------------------
-- Records of clients
-- ----------------------------
BEGIN;
INSERT INTO "public"."clients" ("id", "user_id", "company_id", "client_number", "name", "phone", "fiscal_name", "rfc", "fiscal_address", "address", "alternate_address", "allow_access_without_service", "created_at", "updated_at") VALUES (2, 'usr-101', 1, 'CLI-2024-002', 'Ana Rodríguez', '8176543210', 'Ana Rodríguez López', 'ROLA920520CD2', 'Blvd. Díaz Ordaz 234, Col. Santa María, Monterrey, NL', 'Calle Hidalgo 567, Col. Del Valle, Monterrey, NL', NULL, 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."clients" ("id", "user_id", "company_id", "client_number", "name", "phone", "fiscal_name", "rfc", "fiscal_address", "address", "alternate_address", "allow_access_without_service", "created_at", "updated_at") VALUES (3, 'usr-102', 2, 'CLI-2024-003', 'Luis Hernández', '3312345678', 'Luis Hernández Pérez', 'HEPL880710EF3', 'Av. Chapultepec 345, Col. Americana, Guadalajara, JAL', 'Calle Independencia 678, Col. Centro, Guadalajara, JAL', NULL, 'f', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."clients" ("id", "user_id", "company_id", "client_number", "name", "phone", "fiscal_name", "rfc", "fiscal_address", "address", "alternate_address", "allow_access_without_service", "created_at", "updated_at") VALUES (1, 'usr-100', 1, 'CLI-2024-001', 'Roberto Martínez', '8187654321', 'Roberto Martínez García', 'MAGR850315AB1', 'Av. Constitución 123, Col. Centro, Monterrey, NL', 'Calle Morelos 456, Col. Obrera, Monterrey, NL', 'Av. Lincoln 789, Col. Residencial, San Pedro, NL', 'f', '2025-12-13 00:44:28.660867', '2025-12-13 23:58:05.856807');
COMMIT;

-- ----------------------------
-- Table structure for companies
-- ----------------------------
DROP TABLE IF EXISTS "public"."companies";
CREATE TABLE "public"."companies" (
  "id" int4 NOT NULL DEFAULT nextval('companies_id_seq'::regclass),
  "name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "logo_url" text COLLATE "pg_catalog"."default",
  "slogan" varchar(500) COLLATE "pg_catalog"."default",
  "street" varchar(255) COLLATE "pg_catalog"."default",
  "exterior_number" varchar(50) COLLATE "pg_catalog"."default",
  "interior_number" varchar(50) COLLATE "pg_catalog"."default",
  "neighborhood" varchar(255) COLLATE "pg_catalog"."default",
  "municipality" varchar(255) COLLATE "pg_catalog"."default",
  "state" varchar(100) COLLATE "pg_catalog"."default",
  "postal_code" varchar(10) COLLATE "pg_catalog"."default",
  "phone" varchar(20) COLLATE "pg_catalog"."default",
  "email" varchar(255) COLLATE "pg_catalog"."default",
  "service_completion_message" text COLLATE "pg_catalog"."default",
  "is_active" bool DEFAULT true,
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."companies" OWNER TO "iger";

-- ----------------------------
-- Records of companies
-- ----------------------------
BEGIN;
INSERT INTO "public"."companies" ("id", "name", "logo_url", "slogan", "street", "exterior_number", "interior_number", "neighborhood", "municipality", "state", "postal_code", "phone", "email", "service_completion_message", "is_active", "created_at", "updated_at") VALUES (1, 'Servicios Técnicos del Norte', 'https://ui-avatars.com/api/?name=STN&background=0EA5E9&color=fff&size=200', 'Soluciones integrales para tu hogar y negocio', 'Av. Revolución', '1234', NULL, 'Centro', 'Monterrey', 'Nuevo León', '64000', '8112345678', 'contacto@serviciosnorte.com', 'Gracias por confiar en nosotros. Su servicio ha sido completado satisfactoriamente.', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."companies" ("id", "name", "logo_url", "slogan", "street", "exterior_number", "interior_number", "neighborhood", "municipality", "state", "postal_code", "phone", "email", "service_completion_message", "is_active", "created_at", "updated_at") VALUES (2, 'Mantenimiento Integral SA', 'https://ui-avatars.com/api/?name=MI&background=10B981&color=fff&size=200', 'Mantenimiento profesional a tu alcance', 'Calle Juárez', '567', NULL, 'Zona Industrial', 'Guadalajara', 'Jalisco', '44100', '3398765432', 'info@mantenimientointegral.com', 'Servicio finalizado. Estamos a sus órdenes para cualquier consulta.', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."companies" ("id", "name", "logo_url", "slogan", "street", "exterior_number", "interior_number", "neighborhood", "municipality", "state", "postal_code", "phone", "email", "service_completion_message", "is_active", "created_at", "updated_at") VALUES (3, 'Construcciones y Servicios del Sur', 'https://ui-avatars.com/api/?name=CSS&background=EF4444&color=fff&size=200', 'Construyendo el futuro juntos', 'Blvd. Kukulcán', '890', NULL, 'Zona Hotelera', 'Cancún', 'Quintana Roo', '77500', '9981234567', 'ventas@construccionessur.com', 'Agradecemos su preferencia.', 't', '2025-12-13 00:44:28.660867', '2025-12-13 23:17:47.375406');
COMMIT;

-- ----------------------------
-- Table structure for company_modules
-- ----------------------------
DROP TABLE IF EXISTS "public"."company_modules";
CREATE TABLE "public"."company_modules" (
  "id" int4 NOT NULL DEFAULT nextval('company_modules_id_seq'::regclass),
  "company_id" int4,
  "module_id" int4,
  "is_enabled" bool DEFAULT true,
  "enabled_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."company_modules" OWNER TO "iger";

-- ----------------------------
-- Records of company_modules
-- ----------------------------
BEGIN;
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (1, 1, 1, 't', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (2, 1, 2, 't', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (3, 1, 3, 't', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (4, 1, 4, 't', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (5, 1, 5, 't', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (6, 2, 1, 't', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (7, 2, 2, 't', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (8, 2, 3, 't', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (9, 2, 4, 'f', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (10, 2, 5, 'f', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (13, 3, 3, 'f', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (14, 3, 4, 'f', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (15, 3, 5, 'f', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (11, 3, 1, 't', '2025-12-13 23:17:52.209426');
INSERT INTO "public"."company_modules" ("id", "company_id", "module_id", "is_enabled", "enabled_at") VALUES (12, 3, 2, 't', '2025-12-13 23:17:56.124546');
COMMIT;

-- ----------------------------
-- Table structure for contracted_services
-- ----------------------------
DROP TABLE IF EXISTS "public"."contracted_services";
CREATE TABLE "public"."contracted_services" (
  "id" int4 NOT NULL DEFAULT nextval('contracted_services_id_seq'::regclass),
  "company_id" int4,
  "client_id" varchar(50) COLLATE "pg_catalog"."default",
  "service_catalogo_id" int4,
  "employee_id" int4,
  "service_number" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "request_date" timestamp(6) NOT NULL,
  "deadline_date" timestamp(6),
  "start_date" timestamp(6),
  "end_date" timestamp(6),
  "closed_at" timestamp(6),
  "warranty_end_date" timestamp(6),
  "status" varchar(20) COLLATE "pg_catalog"."default" NOT NULL,
  "employee_report" text COLLATE "pg_catalog"."default",
  "client_rating" int4,
  "client_comment" text COLLATE "pg_catalog"."default",
  "finalized_by_client" bool DEFAULT false,
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."contracted_services" OWNER TO "iger";

-- ----------------------------
-- Records of contracted_services
-- ----------------------------
BEGIN;
INSERT INTO "public"."contracted_services" ("id", "company_id", "client_id", "service_catalogo_id", "employee_id", "service_number", "request_date", "deadline_date", "start_date", "end_date", "closed_at", "warranty_end_date", "status", "employee_report", "client_rating", "client_comment", "finalized_by_client", "created_at", "updated_at") VALUES (1, 1, 'usr-100', 1, 2, 'SRV-2024-001', '2024-10-15 09:00:00', '2024-10-16 18:00:00', '2024-10-15 10:00:00', '2024-10-15 14:00:00', '2024-11-01 10:00:00', '2025-02-01 10:00:00', 'FINISHED', 'Se reparó cortocircuito en instalación principal. Se reemplazaron 3 contactos dañados.', 5, 'Excelente servicio, muy profesional', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."contracted_services" ("id", "company_id", "client_id", "service_catalogo_id", "employee_id", "service_number", "request_date", "deadline_date", "start_date", "end_date", "closed_at", "warranty_end_date", "status", "employee_report", "client_rating", "client_comment", "finalized_by_client", "created_at", "updated_at") VALUES (2, 1, 'usr-100', 2, 1, 'SRV-2024-002', '2024-11-20 08:00:00', '2024-11-21 17:00:00', '2024-11-20 09:00:00', NULL, NULL, NULL, 'IN_PROGRESS', NULL, NULL, NULL, 'f', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."contracted_services" ("id", "company_id", "client_id", "service_catalogo_id", "employee_id", "service_number", "request_date", "deadline_date", "start_date", "end_date", "closed_at", "warranty_end_date", "status", "employee_report", "client_rating", "client_comment", "finalized_by_client", "created_at", "updated_at") VALUES (3, 1, 'usr-101', 3, 1, 'SRV-2024-003', '2024-12-01 10:00:00', '2024-12-05 18:00:00', NULL, NULL, NULL, NULL, 'PENDING', NULL, NULL, NULL, 'f', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."contracted_services" ("id", "company_id", "client_id", "service_catalogo_id", "employee_id", "service_number", "request_date", "deadline_date", "start_date", "end_date", "closed_at", "warranty_end_date", "status", "employee_report", "client_rating", "client_comment", "finalized_by_client", "created_at", "updated_at") VALUES (4, 1, 'usr-101', 4, 2, 'SRV-2024-004', '2024-09-10 11:00:00', '2024-09-12 17:00:00', '2024-09-10 13:00:00', '2024-09-11 16:00:00', '2024-10-10 09:00:00', '2025-10-10 09:00:00', 'FINISHED', 'Instalación completa de minisplit 1.5 toneladas. Incluye tubería de cobre y cableado.', 5, 'Muy satisfecho con el trabajo', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."contracted_services" ("id", "company_id", "client_id", "service_catalogo_id", "employee_id", "service_number", "request_date", "deadline_date", "start_date", "end_date", "closed_at", "warranty_end_date", "status", "employee_report", "client_rating", "client_comment", "finalized_by_client", "created_at", "updated_at") VALUES (5, 2, 'usr-102', 6, 3, 'SRV-2024-005', '2024-12-05 14:00:00', '2024-12-07 18:00:00', NULL, NULL, NULL, NULL, 'PENDING', NULL, NULL, NULL, 'f', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."contracted_services" ("id", "company_id", "client_id", "service_catalogo_id", "employee_id", "service_number", "request_date", "deadline_date", "start_date", "end_date", "closed_at", "warranty_end_date", "status", "employee_report", "client_rating", "client_comment", "finalized_by_client", "created_at", "updated_at") VALUES (6, 1, 'usr-100', 5, 1, 'SRV-2024-006', '2024-11-10 08:00:00', '2024-11-10 18:00:00', '2024-11-10 09:00:00', '2024-11-10 14:00:00', '2024-11-15 10:00:00', NULL, 'FINISHED', 'Limpieza completa de departamento de 80m2', 4, 'Buen servicio', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."contracted_services" ("id", "company_id", "client_id", "service_catalogo_id", "employee_id", "service_number", "request_date", "deadline_date", "start_date", "end_date", "closed_at", "warranty_end_date", "status", "employee_report", "client_rating", "client_comment", "finalized_by_client", "created_at", "updated_at") VALUES (8, 1, 'usr-100', 2, 1, 'SRV-2025-6', '2025-12-13 06:00:00', '2025-12-16 12:00:00', NULL, NULL, NULL, NULL, 'IN_PROGRESS', NULL, NULL, NULL, NULL, '2025-12-13 23:42:22.11629', '2025-12-13 23:55:29.794045');
COMMIT;

-- ----------------------------
-- Table structure for employees
-- ----------------------------
DROP TABLE IF EXISTS "public"."employees";
CREATE TABLE "public"."employees" (
  "id" int4 NOT NULL DEFAULT nextval('employees_id_seq'::regclass),
  "user_id" varchar(50) COLLATE "pg_catalog"."default",
  "company_id" int4,
  "name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "phone" varchar(20) COLLATE "pg_catalog"."default",
  "specialty" varchar(255) COLLATE "pg_catalog"."default",
  "is_active" bool DEFAULT true,
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."employees" OWNER TO "iger";

-- ----------------------------
-- Records of employees
-- ----------------------------
BEGIN;
INSERT INTO "public"."employees" ("id", "user_id", "company_id", "name", "phone", "specialty", "is_active", "created_at", "updated_at") VALUES (2, 'usr-011', 1, 'María García', '8187654321', 'Electricidad', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."employees" ("id", "user_id", "company_id", "name", "phone", "specialty", "is_active", "created_at", "updated_at") VALUES (3, 'usr-012', 2, 'Carlos López', '3387654321', 'Plomería', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."employees" ("id", "user_id", "company_id", "name", "phone", "specialty", "is_active", "created_at", "updated_at") VALUES (1, 'usr-010', 1, 'Juan Pérez', '8198765432', 'Mantenimiento General', 't', '2025-12-13 00:44:28.660867', '2025-12-13 23:43:41.585249');
COMMIT;

-- ----------------------------
-- Table structure for evidences
-- ----------------------------
DROP TABLE IF EXISTS "public"."evidences";
CREATE TABLE "public"."evidences" (
  "id" int4 NOT NULL DEFAULT nextval('evidences_id_seq'::regclass),
  "contracted_service_id" int4,
  "evidence_type" varchar(20) COLLATE "pg_catalog"."default",
  "file_url" text COLLATE "pg_catalog"."default" NOT NULL,
  "description" text COLLATE "pg_catalog"."default",
  "uploaded_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."evidences" OWNER TO "iger";

-- ----------------------------
-- Records of evidences
-- ----------------------------
BEGIN;
INSERT INTO "public"."evidences" ("id", "contracted_service_id", "evidence_type", "file_url", "description", "uploaded_at") VALUES (1, 1, 'PHOTO', 'https://via.placeholder.com/400x300/0EA5E9/FFFFFF?text=Instalacion+Electrica+Antes', 'Estado inicial de la instalación eléctrica', '2024-10-15 10:15:00');
INSERT INTO "public"."evidences" ("id", "contracted_service_id", "evidence_type", "file_url", "description", "uploaded_at") VALUES (2, 1, 'PHOTO', 'https://via.placeholder.com/400x300/10B981/FFFFFF?text=Instalacion+Electrica+Despues', 'Instalación reparada y funcionando', '2024-10-15 14:00:00');
INSERT INTO "public"."evidences" ("id", "contracted_service_id", "evidence_type", "file_url", "description", "uploaded_at") VALUES (3, 2, 'PHOTO', 'https://via.placeholder.com/400x300/F59E0B/FFFFFF?text=Fuga+de+Agua', 'Fuga detectada en tubería principal', '2024-11-20 09:30:00');
INSERT INTO "public"."evidences" ("id", "contracted_service_id", "evidence_type", "file_url", "description", "uploaded_at") VALUES (4, 4, 'PHOTO', 'https://via.placeholder.com/400x300/8B5CF6/FFFFFF?text=Instalacion+AC+1', 'Unidad exterior instalada', '2024-09-11 12:00:00');
INSERT INTO "public"."evidences" ("id", "contracted_service_id", "evidence_type", "file_url", "description", "uploaded_at") VALUES (5, 4, 'PHOTO', 'https://via.placeholder.com/400x300/EC4899/FFFFFF?text=Instalacion+AC+2', 'Unidad interior instalada', '2024-09-11 14:00:00');
INSERT INTO "public"."evidences" ("id", "contracted_service_id", "evidence_type", "file_url", "description", "uploaded_at") VALUES (6, 4, 'PHOTO', 'https://via.placeholder.com/400x300/06B6D4/FFFFFF?text=Instalacion+AC+3', 'Sistema completo funcionando', '2024-09-11 16:00:00');
INSERT INTO "public"."evidences" ("id", "contracted_service_id", "evidence_type", "file_url", "description", "uploaded_at") VALUES (7, 6, 'PHOTO', 'https://via.placeholder.com/400x300/84CC16/FFFFFF?text=Limpieza+Antes', 'Estado inicial del departamento', '2024-11-10 09:00:00');
INSERT INTO "public"."evidences" ("id", "contracted_service_id", "evidence_type", "file_url", "description", "uploaded_at") VALUES (8, 6, 'PHOTO', 'https://via.placeholder.com/400x300/14B8A6/FFFFFF?text=Limpieza+Despues', 'Departamento limpio', '2024-11-10 14:00:00');
COMMIT;

-- ----------------------------
-- Table structure for modules
-- ----------------------------
DROP TABLE IF EXISTS "public"."modules";
CREATE TABLE "public"."modules" (
  "id" int4 NOT NULL DEFAULT nextval('modules_id_seq'::regclass),
  "name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "description" text COLLATE "pg_catalog"."default",
  "is_active" bool DEFAULT true,
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."modules" OWNER TO "iger";

-- ----------------------------
-- Records of modules
-- ----------------------------
BEGIN;
INSERT INTO "public"."modules" ("id", "name", "description", "is_active", "created_at") VALUES (1, 'Gestión de Clientes', 'Administración de clientes y sus datos', 't', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."modules" ("id", "name", "description", "is_active", "created_at") VALUES (2, 'Catálogo de Servicios', 'Gestión del catálogo de servicios ofrecidos', 't', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."modules" ("id", "name", "description", "is_active", "created_at") VALUES (3, 'Órdenes de Servicio', 'Gestión de órdenes de trabajo', 't', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."modules" ("id", "name", "description", "is_active", "created_at") VALUES (4, 'Gestión de Empleados', 'Administración de personal técnico', 't', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."modules" ("id", "name", "description", "is_active", "created_at") VALUES (5, 'Reportes', 'Generación de reportes y estadísticas', 't', '2025-12-13 00:44:28.660867');
COMMIT;

-- ----------------------------
-- Table structure for services_catalog
-- ----------------------------
DROP TABLE IF EXISTS "public"."services_catalog";
CREATE TABLE "public"."services_catalog" (
  "id" int4 NOT NULL DEFAULT nextval('services_catalog_id_seq'::regclass),
  "company_id" int4,
  "name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "description" text COLLATE "pg_catalog"."default",
  "category" varchar(100) COLLATE "pg_catalog"."default",
  "max_time_hours" int4,
  "has_warranty" bool DEFAULT false,
  "warranty_months" int4,
  "warranty_exceptions" text COLLATE "pg_catalog"."default",
  "is_active" bool DEFAULT true,
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."services_catalog" OWNER TO "iger";

-- ----------------------------
-- Records of services_catalog
-- ----------------------------
BEGIN;
INSERT INTO "public"."services_catalog" ("id", "company_id", "name", "description", "category", "max_time_hours", "has_warranty", "warranty_months", "warranty_exceptions", "is_active", "created_at", "updated_at") VALUES (1, 1, 'Reparación de Instalación Eléctrica', 'Diagnóstico y reparación de fallas eléctricas en instalaciones residenciales y comerciales', 'Electricidad', 4, 't', 3, 'No cubre daños por sobrecarga, cortocircuitos externos o manipulación posterior', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."services_catalog" ("id", "company_id", "name", "description", "category", "max_time_hours", "has_warranty", "warranty_months", "warranty_exceptions", "is_active", "created_at", "updated_at") VALUES (2, 1, 'Mantenimiento de Plomería', 'Reparación de fugas, destapado de drenajes y mantenimiento preventivo', 'Plomería', 3, 't', 6, 'No cubre daños por objetos extraños o uso inadecuado', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."services_catalog" ("id", "company_id", "name", "description", "category", "max_time_hours", "has_warranty", "warranty_months", "warranty_exceptions", "is_active", "created_at", "updated_at") VALUES (3, 1, 'Pintura Interior', 'Aplicación de pintura en interiores con preparación de superficies', 'Pintura', 8, 't', 12, 'No cubre daños por humedad, filtración de agua o golpes', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."services_catalog" ("id", "company_id", "name", "description", "category", "max_time_hours", "has_warranty", "warranty_months", "warranty_exceptions", "is_active", "created_at", "updated_at") VALUES (4, 1, 'Instalación de Aire Acondicionado', 'Instalación profesional de equipos de climatización', 'Climatización', 6, 't', 12, 'Garantía solo sobre instalación, no cubre falta de mantenimiento', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."services_catalog" ("id", "company_id", "name", "description", "category", "max_time_hours", "has_warranty", "warranty_months", "warranty_exceptions", "is_active", "created_at", "updated_at") VALUES (5, 1, 'Limpieza Profunda', 'Limpieza integral de espacios residenciales y comerciales', 'Limpieza', 5, 'f', NULL, NULL, 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."services_catalog" ("id", "company_id", "name", "description", "category", "max_time_hours", "has_warranty", "warranty_months", "warranty_exceptions", "is_active", "created_at", "updated_at") VALUES (6, 2, 'Reparación de Electrodomésticos', 'Diagnóstico y reparación de electrodomésticos de línea blanca', 'Electrodomésticos', 3, 't', 3, 'No cubre piezas de desgaste natural', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."services_catalog" ("id", "company_id", "name", "description", "category", "max_time_hours", "has_warranty", "warranty_months", "warranty_exceptions", "is_active", "created_at", "updated_at") VALUES (7, 2, 'Mantenimiento Preventivo', 'Revisión y mantenimiento de instalaciones generales', 'Mantenimiento', 4, 'f', NULL, NULL, 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
COMMIT;

-- ----------------------------
-- Table structure for services_catalogo
-- ----------------------------
DROP TABLE IF EXISTS "public"."services_catalogo";
CREATE TABLE "public"."services_catalogo" (
  "id" int4 NOT NULL DEFAULT nextval('services_catalogo_id_seq'::regclass),
  "name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "description" text COLLATE "pg_catalog"."default",
  "max_time_hours" int4 NOT NULL,
  "category" varchar(100) COLLATE "pg_catalog"."default",
  "is_active" bool DEFAULT true,
  "company_id" int4,
  "has_warranty" bool DEFAULT false,
  "warranty_months" int4 DEFAULT 0,
  "warranty_exceptions" text COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "public"."services_catalogo" OWNER TO "iger";

-- ----------------------------
-- Records of services_catalogo
-- ----------------------------
BEGIN;
INSERT INTO "public"."services_catalogo" ("id", "name", "description", "max_time_hours", "category", "is_active", "company_id", "has_warranty", "warranty_months", "warranty_exceptions") VALUES (1, 'Mantenimiento Preventivo', 'Limpieza y ajuste general', 48, 'Mantenimiento', 't', 1, 'f', 0, NULL);
COMMIT;

-- ----------------------------
-- Table structure for system_config
-- ----------------------------
DROP TABLE IF EXISTS "public"."system_config";
CREATE TABLE "public"."system_config" (
  "id" int4 NOT NULL DEFAULT nextval('system_config_id_seq'::regclass),
  "config_key" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "config_value" text COLLATE "pg_catalog"."default",
  "description" varchar(500) COLLATE "pg_catalog"."default",
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."system_config" OWNER TO "iger";

-- ----------------------------
-- Records of system_config
-- ----------------------------
BEGIN;
INSERT INTO "public"."system_config" ("id", "config_key", "config_value", "description", "created_at", "updated_at") VALUES (1, 'footer_text', '© 2025 KeSoftware - Sistema de Gestión de Servicios', 'Texto del pie de página global', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."system_config" ("id", "config_key", "config_value", "description", "created_at", "updated_at") VALUES (2, 'footer_link_text', 'Soporte Técnico', 'Texto del enlace en el pie de página', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."system_config" ("id", "config_key", "config_value", "description", "created_at", "updated_at") VALUES (3, 'footer_link_url', 'https://kesoftware.com/soporte', 'URL del enlace en el pie de página', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
COMMIT;

-- ----------------------------
-- Table structure for users
-- ----------------------------
DROP TABLE IF EXISTS "public"."users";
CREATE TABLE "public"."users" (
  "id" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "company_id" int4,
  "email" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "password_hash" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "role" varchar(20) COLLATE "pg_catalog"."default" NOT NULL,
  "is_active" bool DEFAULT true,
  "created_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "updated_at" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
ALTER TABLE "public"."users" OWNER TO "iger";

-- ----------------------------
-- Records of users
-- ----------------------------
BEGIN;
INSERT INTO "public"."users" ("id", "company_id", "email", "password_hash", "role", "is_active", "created_at", "updated_at") VALUES ('usr-002', 2, 'admin@mantenimientointegral.com', '$2a$10$demo123hash', 'ADMIN', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."users" ("id", "company_id", "email", "password_hash", "role", "is_active", "created_at", "updated_at") VALUES ('usr-011', 1, 'maria.garcia@serviciosnorte.com', '$2a$10$demo123hash', 'EMPLOYEE', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."users" ("id", "company_id", "email", "password_hash", "role", "is_active", "created_at", "updated_at") VALUES ('usr-012', 2, 'carlos.lopez@mantenimientointegral.com', '$2a$10$demo123hash', 'EMPLOYEE', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."users" ("id", "company_id", "email", "password_hash", "role", "is_active", "created_at", "updated_at") VALUES ('usr-101', 1, 'ana.rodriguez@email.com', '$2a$10$demo123hash', 'CLIENT', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."users" ("id", "company_id", "email", "password_hash", "role", "is_active", "created_at", "updated_at") VALUES ('usr-102', 2, 'luis.hernandez@email.com', '$2a$10$demo123hash', 'CLIENT', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."users" ("id", "company_id", "email", "password_hash", "role", "is_active", "created_at", "updated_at") VALUES ('usr-root', NULL, 'root@kesoftware.com', '$2b$10$aJHQIY1sEXrTbhEDhtkHmeIzXT4hl/WrGrlwh7xAdRH7qL0ZPxf0e', 'ROOT', 't', '2025-12-13 00:44:28.660867', '2025-12-13 00:44:28.660867');
INSERT INTO "public"."users" ("id", "company_id", "email", "password_hash", "role", "is_active", "created_at", "updated_at") VALUES ('usr-001', 1, 'richie.iriarte@gmail.com', '$2b$10$I3i.7rgQEeg.aSH42VGXVeyQ5UWZtaD8rnbToa5mpdffnMyTxCuz.', 'ADMIN', 't', '2025-12-13 00:44:28.660867', '2025-12-13 22:52:02.567119');
INSERT INTO "public"."users" ("id", "company_id", "email", "password_hash", "role", "is_active", "created_at", "updated_at") VALUES ('usr-003', 3, 'iger@hotmail.com', '$2b$10$gMJrMUuXxdgqeP1Xv0vTOOXp0W5RgAStv0rO2JAFx1yBgJ3YqR1Fy', 'ADMIN', 't', '2025-12-13 00:44:28.660867', '2025-12-13 23:18:26.753042');
INSERT INTO "public"."users" ("id", "company_id", "email", "password_hash", "role", "is_active", "created_at", "updated_at") VALUES ('usr-010', 1, 'juan@gmail.com', '$2b$10$9TocqLcads98cd1n38umae5HRB/LqrX1sHbowzhzQ/moHOWjHgKfy', 'EMPLOYEE', 't', '2025-12-13 00:44:28.660867', '2025-12-13 23:43:41.58028');
INSERT INTO "public"."users" ("id", "company_id", "email", "password_hash", "role", "is_active", "created_at", "updated_at") VALUES ('usr-100', 1, 'roberto@gmail.com', '$2b$10$RBKJ7mO1UmWDaX48bw5wje1agQQGP.wTwNE3nQ91GJ0r/VGCbDjbi', 'CLIENT', 't', '2025-12-13 00:44:28.660867', '2025-12-13 23:58:05.848418');
COMMIT;

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."clients_id_seq"
OWNED BY "public"."clients"."id";
SELECT setval('"public"."clients_id_seq"', 3, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."companies_id_seq"
OWNED BY "public"."companies"."id";
SELECT setval('"public"."companies_id_seq"', 3, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."company_modules_id_seq"
OWNED BY "public"."company_modules"."id";
SELECT setval('"public"."company_modules_id_seq"', 17, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."contracted_services_id_seq"
OWNED BY "public"."contracted_services"."id";
SELECT setval('"public"."contracted_services_id_seq"', 8, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."employees_id_seq"
OWNED BY "public"."employees"."id";
SELECT setval('"public"."employees_id_seq"', 3, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."evidences_id_seq"
OWNED BY "public"."evidences"."id";
SELECT setval('"public"."evidences_id_seq"', 8, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."modules_id_seq"
OWNED BY "public"."modules"."id";
SELECT setval('"public"."modules_id_seq"', 5, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."services_catalog_id_seq"
OWNED BY "public"."services_catalog"."id";
SELECT setval('"public"."services_catalog_id_seq"', 7, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."services_catalogo_id_seq"
OWNED BY "public"."services_catalogo"."id";
SELECT setval('"public"."services_catalogo_id_seq"', 1, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."system_config_id_seq"
OWNED BY "public"."system_config"."id";
SELECT setval('"public"."system_config_id_seq"', 3, true);

-- ----------------------------
-- Indexes structure for table clients
-- ----------------------------
CREATE INDEX "idx_clients_company" ON "public"."clients" USING btree (
  "company_id" "pg_catalog"."int4_ops" ASC NULLS LAST
);
CREATE INDEX "idx_clients_number" ON "public"."clients" USING btree (
  "client_number" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);

-- ----------------------------
-- Uniques structure for table clients
-- ----------------------------
ALTER TABLE "public"."clients" ADD CONSTRAINT "clients_user_id_key" UNIQUE ("user_id");
ALTER TABLE "public"."clients" ADD CONSTRAINT "clients_client_number_key" UNIQUE ("client_number");

-- ----------------------------
-- Primary Key structure for table clients
-- ----------------------------
ALTER TABLE "public"."clients" ADD CONSTRAINT "clients_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table companies
-- ----------------------------
ALTER TABLE "public"."companies" ADD CONSTRAINT "companies_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Uniques structure for table company_modules
-- ----------------------------
ALTER TABLE "public"."company_modules" ADD CONSTRAINT "company_modules_company_id_module_id_key" UNIQUE ("company_id", "module_id");

-- ----------------------------
-- Primary Key structure for table company_modules
-- ----------------------------
ALTER TABLE "public"."company_modules" ADD CONSTRAINT "company_modules_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Indexes structure for table contracted_services
-- ----------------------------
CREATE INDEX "idx_contracted_services_client" ON "public"."contracted_services" USING btree (
  "client_id" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);
CREATE INDEX "idx_contracted_services_company" ON "public"."contracted_services" USING btree (
  "company_id" "pg_catalog"."int4_ops" ASC NULLS LAST
);
CREATE INDEX "idx_contracted_services_employee" ON "public"."contracted_services" USING btree (
  "employee_id" "pg_catalog"."int4_ops" ASC NULLS LAST
);
CREATE INDEX "idx_contracted_services_status" ON "public"."contracted_services" USING btree (
  "status" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);

-- ----------------------------
-- Uniques structure for table contracted_services
-- ----------------------------
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_service_number_key" UNIQUE ("service_number");

-- ----------------------------
-- Checks structure for table contracted_services
-- ----------------------------
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_status_check" CHECK (status::text = ANY (ARRAY['PENDING'::character varying, 'IN_PROGRESS'::character varying, 'FINISHED'::character varying, 'CANCELLED'::character varying, 'CERRADO_ADMIN'::character varying]::text[]));
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_client_rating_check" CHECK (client_rating >= 1 AND client_rating <= 5);

-- ----------------------------
-- Primary Key structure for table contracted_services
-- ----------------------------
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Indexes structure for table employees
-- ----------------------------
CREATE INDEX "idx_employees_company" ON "public"."employees" USING btree (
  "company_id" "pg_catalog"."int4_ops" ASC NULLS LAST
);

-- ----------------------------
-- Uniques structure for table employees
-- ----------------------------
ALTER TABLE "public"."employees" ADD CONSTRAINT "employees_user_id_key" UNIQUE ("user_id");

-- ----------------------------
-- Primary Key structure for table employees
-- ----------------------------
ALTER TABLE "public"."employees" ADD CONSTRAINT "employees_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Indexes structure for table evidences
-- ----------------------------
CREATE INDEX "idx_evidences_service" ON "public"."evidences" USING btree (
  "contracted_service_id" "pg_catalog"."int4_ops" ASC NULLS LAST
);

-- ----------------------------
-- Checks structure for table evidences
-- ----------------------------
ALTER TABLE "public"."evidences" ADD CONSTRAINT "evidences_evidence_type_check" CHECK (evidence_type::text = ANY (ARRAY['PHOTO'::character varying, 'VIDEO'::character varying, 'DOCUMENT'::character varying]::text[]));

-- ----------------------------
-- Primary Key structure for table evidences
-- ----------------------------
ALTER TABLE "public"."evidences" ADD CONSTRAINT "evidences_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table modules
-- ----------------------------
ALTER TABLE "public"."modules" ADD CONSTRAINT "modules_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Indexes structure for table services_catalog
-- ----------------------------
CREATE INDEX "idx_services_catalog_company" ON "public"."services_catalog" USING btree (
  "company_id" "pg_catalog"."int4_ops" ASC NULLS LAST
);

-- ----------------------------
-- Primary Key structure for table services_catalog
-- ----------------------------
ALTER TABLE "public"."services_catalog" ADD CONSTRAINT "services_catalog_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table services_catalogo
-- ----------------------------
ALTER TABLE "public"."services_catalogo" ADD CONSTRAINT "services_catalogo_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Uniques structure for table system_config
-- ----------------------------
ALTER TABLE "public"."system_config" ADD CONSTRAINT "system_config_config_key_key" UNIQUE ("config_key");

-- ----------------------------
-- Primary Key structure for table system_config
-- ----------------------------
ALTER TABLE "public"."system_config" ADD CONSTRAINT "system_config_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Indexes structure for table users
-- ----------------------------
CREATE INDEX "idx_users_company" ON "public"."users" USING btree (
  "company_id" "pg_catalog"."int4_ops" ASC NULLS LAST
);
CREATE INDEX "idx_users_email" ON "public"."users" USING btree (
  "email" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);
CREATE INDEX "idx_users_role" ON "public"."users" USING btree (
  "role" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);

-- ----------------------------
-- Uniques structure for table users
-- ----------------------------
ALTER TABLE "public"."users" ADD CONSTRAINT "users_email_key" UNIQUE ("email");

-- ----------------------------
-- Checks structure for table users
-- ----------------------------
ALTER TABLE "public"."users" ADD CONSTRAINT "users_role_check" CHECK (role::text = ANY (ARRAY['ROOT'::character varying, 'ADMIN'::character varying, 'EMPLOYEE'::character varying, 'CLIENT'::character varying]::text[]));

-- ----------------------------
-- Primary Key structure for table users
-- ----------------------------
ALTER TABLE "public"."users" ADD CONSTRAINT "users_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Foreign Keys structure for table clients
-- ----------------------------
ALTER TABLE "public"."clients" ADD CONSTRAINT "clients_company_id_fkey" FOREIGN KEY ("company_id") REFERENCES "public"."companies" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."clients" ADD CONSTRAINT "clients_user_id_fkey" FOREIGN KEY ("user_id") REFERENCES "public"."users" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table company_modules
-- ----------------------------
ALTER TABLE "public"."company_modules" ADD CONSTRAINT "company_modules_company_id_fkey" FOREIGN KEY ("company_id") REFERENCES "public"."companies" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."company_modules" ADD CONSTRAINT "company_modules_module_id_fkey" FOREIGN KEY ("module_id") REFERENCES "public"."modules" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table contracted_services
-- ----------------------------
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_client_id_fkey" FOREIGN KEY ("client_id") REFERENCES "public"."users" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_company_id_fkey" FOREIGN KEY ("company_id") REFERENCES "public"."companies" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_employee_id_fkey" FOREIGN KEY ("employee_id") REFERENCES "public"."employees" ("id") ON DELETE SET NULL ON UPDATE NO ACTION;
ALTER TABLE "public"."contracted_services" ADD CONSTRAINT "contracted_services_service_catalogo_id_fkey" FOREIGN KEY ("service_catalogo_id") REFERENCES "public"."services_catalog" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table employees
-- ----------------------------
ALTER TABLE "public"."employees" ADD CONSTRAINT "employees_company_id_fkey" FOREIGN KEY ("company_id") REFERENCES "public"."companies" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."employees" ADD CONSTRAINT "employees_user_id_fkey" FOREIGN KEY ("user_id") REFERENCES "public"."users" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table evidences
-- ----------------------------
ALTER TABLE "public"."evidences" ADD CONSTRAINT "evidences_contracted_service_id_fkey" FOREIGN KEY ("contracted_service_id") REFERENCES "public"."contracted_services" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table services_catalog
-- ----------------------------
ALTER TABLE "public"."services_catalog" ADD CONSTRAINT "services_catalog_company_id_fkey" FOREIGN KEY ("company_id") REFERENCES "public"."companies" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table users
-- ----------------------------
ALTER TABLE "public"."users" ADD CONSTRAINT "users_company_id_fkey" FOREIGN KEY ("company_id") REFERENCES "public"."companies" ("id") ON DELETE CASCADE ON UPDATE NO ACTION;
