import { Routes, Route } from 'react-router-dom';
import { Box } from '@chakra-ui/react';

// Login
import LoginPage from './pages/LoginPage';

// Root Module
import RootLayout from './pages/root/RootLayout';
import RootDashboard from './pages/root/RootDashboard';
import GestionEmpresas from './pages/root/GestionEmpresas'; // Will be updated to Institutions
import GestionAdministradores from './pages/root/GestionAdministradores';
import ControlModulos from './pages/root/ControlModulos';
import ConfiguracionFooter from './pages/root/ConfiguracionFooter';
import ReportesEmpresa from './pages/root/ReportesEmpresa';
import MiPerfil from './pages/root/MiPerfil';
import GestionUsuariosRoot from './pages/root/GestionUsuariosRoot';

// Admin
import AdminLayout from './pages/admin/AdminLayout';
import AdminDashboard from './pages/admin/AdminDashboard';
import GestionClientes from './pages/admin/GestionClientes'; // Students
import GestionEmpleados from './pages/admin/GestionEmpleados'; // Professors
import GestionEspecialidades from './pages/admin/GestionEspecialidades';
import ConfiguracionEmpresa from './pages/admin/ConfiguracionEmpresa';
import Reportes from './pages/admin/Reportes';

// Professor (Formerly Employee)
import ProfessorLayout from './pages/professor/ProfessorLayout';
import ProfessorDashboard from './pages/professor/ProfessorDashboard';
import GestionPreguntas from './pages/professor/GestionPreguntas';
import GestionExamenes from './pages/professor/GestionExamenes';
import ExamBuilder from './pages/professor/ExamBuilder';
import LiveMonitor from './pages/professor/LiveMonitor';
import RevisionExamenes from './pages/professor/RevisionExamenes';
import CalendarioTrabajo from './pages/professor/CalendarioTrabajo';
import PerfilProfessor from './pages/professor/PerfilProfessor';

// Student (Formerly Client)
import StudentLayout from './pages/student/StudentLayout';
import StudentDashboard from './pages/student/StudentDashboard';
import AplicarExamen from './pages/student/AplicarExamen';
import ExamenActivo from './pages/student/ExamenActivo';
import HistorialExamenes from './pages/student/HistorialExamenes';

function App() {
  return (
    <Routes>
      <Route path="/" element={<LoginPage />} />
      <Route path="/login" element={<LoginPage />} />

      {/* Rutas ROOT */}
      <Route path="/root" element={<RootLayout />}>
        <Route index element={<RootDashboard />} />
        <Route path="instituciones" element={<GestionEmpresas />} />
        <Route path="empresas" element={<GestionEmpresas />} />
        <Route path="administradores" element={<GestionAdministradores />} />
        <Route path="modulos" element={<ControlModulos />} />
        <Route path="configuracion" element={<ConfiguracionFooter />} />
        <Route path="reporte/:companyId" element={<ReportesEmpresa />} />
        <Route path="perfil" element={<MiPerfil />} />
        <Route path="superusuarios" element={<GestionUsuariosRoot />} />
      </Route>

      {/* Rutas de Admin */}
      <Route path="/admin" element={<AdminLayout />}>
        <Route index element={<AdminDashboard />} />
        <Route path="estudiantes" element={<GestionClientes />} />
        <Route path="clientes" element={<GestionClientes />} />
        <Route path="profesores" element={<GestionEmpleados />} />
        <Route path="empleados" element={<GestionEmpleados />} />
        <Route path="especialidades" element={<GestionEspecialidades />} />
        <Route path="preguntas" element={<GestionPreguntas />} />
        <Route path="servicios" element={<GestionPreguntas />} />
        <Route path="examenes" element={<GestionExamenes />} />
        <Route path="ordenes" element={<GestionExamenes />} />
        <Route path="configuracion" element={<ConfiguracionEmpresa />} />
        <Route path="reportes" element={<Reportes />} />
      </Route>

      {/* Rutas de Professor */}
      <Route path="/professor" element={<ProfessorLayout />}>
        <Route index element={<ProfessorDashboard />} />
        <Route path="preguntas" element={<GestionPreguntas />} />
        <Route path="constructor" element={<ExamBuilder />} />
        <Route path="monitor/:examId" element={<LiveMonitor />} />
        <Route path="examenes" element={<GestionExamenes />} />
        <Route path="revision" element={<RevisionExamenes />} />
        <Route path="calendario" element={<CalendarioTrabajo />} />
        <Route path="perfil" element={<PerfilProfessor />} />
      </Route>

      {/* Rutas de Student */}
      <Route path="/student" element={<StudentLayout />}>
        <Route index element={<StudentDashboard />} />
        <Route path="aplicar" element={<AplicarExamen />} />
        <Route path="examen/:examId" element={<ExamenActivo />} />
        <Route path="historial" element={<HistorialExamenes />} />
        <Route path="notificaciones" element={<Box p={5}>Notificaciones (Pendiente)</Box>} />
      </Route>
    </Routes>
  );
}

export default App;
