import { Box, VStack, Link, Text, HStack, Divider, Flex, Avatar, Icon, Image, IconButton } from '@chakra-ui/react';
import { NavLink } from 'react-router-dom';
import {
  BiTachometer,
  BiUser,
  BiGroup,
  BiBookAlt,
  BiTargetLock,
  BiCalendar,
  BiBook,
  BiCreditCard,
  BiCheckCircle,
  BiBell,
  BiEdit,
  BiTrophy,
  BiBriefcase,
  BiClipboard,
  BiLogOut,
  BiX
} from 'react-icons/bi';

// Mapeo de iconos para cada ruta
const getIcon = (nombre) => {
  const iconMap = {
    'Dashboard': BiTachometer,
    'Usuarios': BiUser,
    'Instituciones': BiBriefcase,
    'Gestionar Usuarios': BiUser,
    'Profesores': BiGroup,
    'Gestión de Profesores': BiGroup,
    'Alumnos': BiGroup,
    'Estudiantes': BiGroup,
    'Gestión de Estudiantes': BiGroup,
    'Materias': BiBookAlt,
    'Banco de Preguntas': BiEdit,
    'Especialidades': BiBookAlt,
    'Exámenes': BiClipboard,
    'Asignar Clases': BiTargetLock,
    'Asignación de Clases': BiTargetLock,
    'Calendario Global': BiCalendar,
    'Calendario': BiCalendar,
    'Consultar Bitácoras': BiBook,
    'Bitácora': BiBook,
    'Bitácoras': BiBook,
    'Calendario Pagos': BiCreditCard,
    'Calendario de Pagos': BiCreditCard,
    'Validar Pagos': BiCheckCircle,
    'Pagos': BiCreditCard,
    'Notificaciones': BiBell,
    'Mis Alumnos': BiGroup,
    'Registrar Bitácora': BiEdit,
    'Mi Calendario': BiCalendar,
    'Avance (Bitácoras)': BiBook,
    'Metas': BiTrophy,
    'Mis Bitácoras': BiBook,
    'Mis Metas': BiTrophy
  };
  const IconComponent = iconMap[nombre] || BiBookAlt;
  return <Icon as={IconComponent} fontSize="16px" />;
};

const Sidebar = ({ links, userType, userName, userPhoto, isOpen = true, onClose }) => {
  // Agrupar links por categorías para mejor organización
  const groupLinks = (links) => {
    const groups = {
      main: [],
      management: [],
      calendar: [],
      reports: [],
      other: []
    };

    links.forEach(link => {
      const nombre = link.nombre.toLowerCase();
      if (nombre.includes('dashboard')) {
        groups.main.push(link);
      } else if (
        nombre.includes('usuario') || 
        nombre.includes('profesor') || 
        nombre.includes('estudiante') || 
        nombre.includes('alumno') || 
        nombre.includes('institucion') || 
        nombre.includes('materia') || 
        nombre.includes('asignar')
      ) {
        groups.management.push(link);
      } else if (nombre.includes('calendario') || nombre.includes('pago')) {
        groups.calendar.push(link);
      } else if (nombre.includes('bitácora') || nombre.includes('bitacora') || nombre.includes('avance') || nombre.includes('meta')) {
        groups.reports.push(link);
      } else {
        groups.other.push(link);
      }
    });

    // Ordenar la sección de gestión: "Gestión de Profesores" antes de "Gestión de Estudiantes"
    groups.management.sort((a, b) => {
      const nombreA = a.nombre.toLowerCase();
      const nombreB = b.nombre.toLowerCase();
      
      // Si uno es "gestión de profesores" y el otro "gestión de estudiantes", ordenar específicamente
      const isProfesoresA = nombreA.includes('gestión de profesores') || nombreA.includes('gestion de profesores');
      const isProfesoresB = nombreB.includes('gestión de profesores') || nombreB.includes('gestion de profesores');
      const isEstudiantesA = nombreA.includes('gestión de estudiantes') || nombreA.includes('gestion de estudiantes');
      const isEstudiantesB = nombreB.includes('gestión de estudiantes') || nombreB.includes('gestion de estudiantes');
      
      if (isProfesoresA && isEstudiantesB) return -1; // Profesores antes
      if (isEstudiantesA && isProfesoresB) return 1;  // Estudiantes después
      
      // Mantener el orden original para otros items
      return 0;
    });

    return groups;
  };

  const groupedLinks = groupLinks(links);

  return (
    <Box
      w={{ base: '100%', md: '260px' }}
      h="100vh"
      bg="rgba(241, 245, 249, 0.95)"
      backdropFilter="blur(20px) saturate(180%)"
      sx={{ WebkitBackdropFilter: "blur(20px) saturate(180%)" }}
      color="gray.800"
      borderRight="1px solid"
      borderColor="rgba(255, 255, 255, 0.3)"
      position="fixed"
      left={isOpen ? "0" : { base: "-100%", md: "-260px" }}
      top="0"
      display="flex"
      flexDirection="column"
      zIndex={1000}
      boxShadow="0 8px 32px 0 rgba(0, 0, 0, 0.1)"
      transition="all 0.3s ease-in-out"
      _before={{
        content: '""',
        position: 'absolute',
        top: 0,
        left: 0,
        right: 0,
        bottom: 0,
        background: 'linear-gradient(135deg, rgba(255, 255, 255, 0.2) 0%, rgba(241, 245, 249, 0.1) 100%)',
        borderRadius: '0',
        zIndex: -1,
        pointerEvents: 'none',
      }}
    >
      {/* Header */}
      <Box
        p={6}
        pb={5}
        borderBottom="1px solid"
        borderColor="rgba(255, 255, 255, 0.3)"
        position="relative"
        _after={{
          content: '""',
          position: 'absolute',
          bottom: 0,
          left: 0,
          right: 0,
          height: '1px',
          background: 'linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.5), transparent)',
        }}
      >
        <Flex align="center" mb={4} justify="space-between">
          <Flex align="center">
            <Box
              w="60px"
              h="60px"
              bg="white"
              borderRadius="12px"
              display="flex"
              alignItems="center"
              justifyContent="center"
              fontSize="22px"
              mr={3}
              flexShrink={0}
              boxShadow="0 4px 6px -1px rgba(14, 165, 233, 0.3)"
              transition="all 0.2s ease-in-out"
              _hover={{
                transform: 'scale(1.05)',
                boxShadow: '0 6px 12px -1px rgba(14, 165, 233, 0.4)',
              }}
              overflow="hidden"
            >
              <Image
                src="/logo.jpeg"
                alt="Ke marketing"
                w="100%"
                h="100%"
                objectFit="contain"
              />
            </Box>
            <Box flex="1" minW={0}>
              <Text
                fontSize="15px"
                fontWeight="700"
                color="gray.800"
                letterSpacing="-0.3px"
                lineHeight="1.2"
                noOfLines={2}
              >
                KeQuiz
              </Text>
              <Text
                fontSize="11px"
                color="gray.600"
                mt={0.5}
                noOfLines={1}
              >
                {userType === 'Administrador' ? 'Admin' : userType}
              </Text>

            </Box>
          </Flex>
          <IconButton
            display={{ base: 'flex', md: 'none' }}
            icon={<Icon as={BiX} />}
            variant="ghost"
            onClick={onClose}
            aria-label="Cerrar menú"
            size="lg"
          />
        </Flex>
      </Box>

      {/* Navigation */}
      <Box flex="1" overflowY="auto" px={3} py={4}>
        <VStack align="stretch" spacing={6}>
          {/* Main Navigation */}
          <VStack align="stretch" spacing={1}>
            {groupedLinks.main.map((link, index) => (
              <Link
                key={index}
                as={NavLink}
                to={link.path}
                px={3}
                py={2.5}
                borderRadius="8px"
                _hover={{
                  bg: 'rgba(255, 255, 255, 0.5)',
                  transform: 'translateX(4px)',
                  backdropFilter: 'blur(10px)',
                }}
                _activeLink={{
                  bg: 'rgba(14, 165, 233, 0.2)',
                  color: 'gray.900',
                  fontWeight: '600',
                  boxShadow: '0 2px 8px rgba(14, 165, 233, 0.3)',
                  backdropFilter: 'blur(10px)',
                  borderLeft: '3px solid',
                  borderColor: 'brand.500',
                }}
                color="gray.700"
                transition="all 0.2s ease-in-out"
                fontSize="14px"
                display="flex"
                alignItems="center"
                position="relative"
                onClick={onClose}
              >
                <HStack spacing={3} flex="1">
                  <Box flexShrink={0} transition="all 0.2s ease-in-out">
                    {link.icon ? <Icon as={link.icon} fontSize="16px" /> : getIcon(link.nombre)}
                  </Box>
                  <Text flex="1" noOfLines={1} fontWeight="500">{link.nombre}</Text>
                </HStack>
              </Link>
            ))}
          </VStack>

          {/* Management Section */}
          {groupedLinks.management.length > 0 && (
            <VStack align="stretch" spacing={1}>
              <Text fontSize="10px" fontWeight="600" color="gray.600" textTransform="uppercase" letterSpacing="0.5px" px={3} mb={1}>
                Gestión
              </Text>
              {groupedLinks.management.map((link, index) => (
                <Link
                  key={index}
                  as={NavLink}
                  to={link.path}
                  px={3}
                  py={2.5}
                  borderRadius="8px"
                  _hover={{
                    bg: 'sidebar.hover',
                    transform: 'translateX(4px)',
                  }}
                  _activeLink={{
                    bg: 'sidebar.active',
                    color: 'white',
                    fontWeight: '600',
                    boxShadow: '0 2px 4px rgba(14, 165, 233, 0.2)',
                  }}
                          color="gray.700"
                          transition="all 0.2s ease-in-out"
                          fontSize="14px"
                          display="flex"
                          alignItems="center"
                          onClick={onClose}
                        >
                          <HStack spacing={3} flex="1">
                            <Box flexShrink={0} transition="all 0.2s ease-in-out">
                              {link.icon ? <Icon as={link.icon} fontSize="16px" /> : getIcon(link.nombre)}
                            </Box>
                            <Text flex="1" noOfLines={1} fontWeight="500">{link.nombre}</Text>
                          </HStack>
                        </Link>
              ))}
            </VStack>
          )}

          {/* Calendar Section */}
          {groupedLinks.calendar.length > 0 && (
            <VStack align="stretch" spacing={1}>
              <Text fontSize="10px" fontWeight="600" color="gray.600" textTransform="uppercase" letterSpacing="0.5px" px={3} mb={1}>
                Calendario
              </Text>
              {groupedLinks.calendar.map((link, index) => (
                <Link
                  key={index}
                  as={NavLink}
                  to={link.path}
                  px={3}
                  py={2.5}
                  borderRadius="8px"
                  _hover={{
                    bg: 'sidebar.hover',
                    transform: 'translateX(4px)',
                  }}
                  _activeLink={{
                    bg: 'sidebar.active',
                    color: 'white',
                    fontWeight: '600',
                    boxShadow: '0 2px 4px rgba(14, 165, 233, 0.2)',
                  }}
                          color="gray.700"
                          transition="all 0.2s ease-in-out"
                          fontSize="14px"
                          display="flex"
                          alignItems="center"
                          onClick={onClose}
                        >
                          <HStack spacing={3} flex="1">
                            <Box flexShrink={0} transition="all 0.2s ease-in-out">
                              {link.icon ? <Icon as={link.icon} fontSize="16px" /> : getIcon(link.nombre)}
                            </Box>
                            <Text flex="1" noOfLines={1} fontWeight="500">{link.nombre}</Text>
                          </HStack>
                        </Link>
              ))}
            </VStack>
          )}

          {/* Reports Section */}
          {groupedLinks.reports.length > 0 && (
            <VStack align="stretch" spacing={1}>
              <Text fontSize="10px" fontWeight="600" color="gray.600" textTransform="uppercase" letterSpacing="0.5px" px={3} mb={1}>
                Reportes
              </Text>
              {groupedLinks.reports.map((link, index) => (
                <Link
                  key={index}
                  as={NavLink}
                  to={link.path}
                  px={3}
                  py={2.5}
                  borderRadius="8px"
                  _hover={{
                    bg: 'sidebar.hover',
                    transform: 'translateX(4px)',
                  }}
                  _activeLink={{
                    bg: 'sidebar.active',
                    color: 'white',
                    fontWeight: '600',
                    boxShadow: '0 2px 4px rgba(14, 165, 233, 0.2)',
                  }}
                          color="gray.700"
                          transition="all 0.2s ease-in-out"
                          fontSize="14px"
                          display="flex"
                          alignItems="center"
                          onClick={onClose}
                        >
                          <HStack spacing={3} flex="1">
                            <Box flexShrink={0} transition="all 0.2s ease-in-out">
                              {link.icon ? <Icon as={link.icon} fontSize="16px" /> : getIcon(link.nombre)}
                            </Box>
                            <Text flex="1" noOfLines={1} fontWeight="500">{link.nombre}</Text>
                          </HStack>
                        </Link>
              ))}
            </VStack>
          )}

          {/* Other Links */}
          {groupedLinks.other.length > 0 && (
            <VStack align="stretch" spacing={1}>
              {groupedLinks.other.map((link, index) => (
                <Link
                  key={index}
                  as={NavLink}
                  to={link.path}
                  px={3}
                  py={2.5}
                  borderRadius="8px"
                  _hover={{
                    bg: 'sidebar.hover',
                    transform: 'translateX(4px)',
                  }}
                  _activeLink={{
                    bg: 'sidebar.active',
                    color: 'white',
                    fontWeight: '600',
                    boxShadow: '0 2px 4px rgba(14, 165, 233, 0.2)',
                  }}
                          color="gray.700"
                          transition="all 0.2s ease-in-out"
                          fontSize="14px"
                          display="flex"
                          alignItems="center"
                          onClick={onClose}
                        >
                          <HStack spacing={3} flex="1">
                            <Box flexShrink={0} transition="all 0.2s ease-in-out">
                              {link.icon ? <Icon as={link.icon} fontSize="16px" /> : getIcon(link.nombre)}
                            </Box>
                            <Text flex="1" noOfLines={1} fontWeight="500">{link.nombre}</Text>
                          </HStack>
                        </Link>
              ))}
            </VStack>
          )}
        </VStack>
      </Box>

      {/* User Profile & Logout */}
      <Box
        p={4}
        borderTop="1px solid"
        borderColor="rgba(255, 255, 255, 0.3)"
        bg="rgba(255, 255, 255, 0.2)"
        backdropFilter="blur(10px)"
        position="relative"
        _before={{
          content: '""',
          position: 'absolute',
          top: 0,
          left: 0,
          right: 0,
          height: '1px',
          background: 'linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.5), transparent)',
        }}
      >
        <Flex align="center" mb={3}>
          <Avatar
            size="sm"
            name={userName}
            src={userPhoto}
            bg="brand.500"
            boxSize="36px"
            mr={3}
            boxShadow="0 2px 4px rgba(14, 165, 233, 0.3)"
            transition="all 0.2s ease-in-out"
            _hover={{
              transform: 'scale(1.05)',
              boxShadow: '0 4px 8px rgba(14, 165, 233, 0.4)',
            }}
          />
          <Box flex="1" minW={0}>
            <Text
              fontSize="14px"
              fontWeight="600"
              color="gray.800"
              noOfLines={1}
            >
              {userName}
            </Text>
            <Text
              fontSize="11px"
              color="gray.600"
              noOfLines={1}
            >
              {userType}
            </Text>
          </Box>
        </Flex>
        <Link
          as={NavLink}
          to="/login"
          px={3}
          py={2.5}
          borderRadius="8px"
          color="brand.400"
          _hover={{
            bg: 'rgba(255, 255, 255, 0.5)',
            color: 'brand.600',
            transform: 'translateX(4px)',
            backdropFilter: 'blur(10px)',
          }}
          display="flex"
          alignItems="center"
          fontSize="14px"
          transition="all 0.2s ease-in-out"
          fontWeight="500"
        >
          <HStack spacing={3}>
            <Icon as={BiLogOut} fontSize="16px" />
            <Text>Cerrar Sesión</Text>
          </HStack>
        </Link>
      </Box>
    </Box >
  );
};

export default Sidebar;

