
import { useState, useEffect } from 'react';
import { getServerTime } from '../services/api';

const useServerTime = () => {
    // Inicializar con la hora local, se ajustará al montar
    const [currentTime, setCurrentTime] = useState(new Date());
    const [offset, setOffset] = useState(0);
    const [loading, setLoading] = useState(true);

    useEffect(() => {
        const syncTime = async () => {
            try {
                const startTime = Date.now();
                const response = await getServerTime();
                const endTime = Date.now();
                const latency = (endTime - startTime) / 2;

                if (response && response.time) {
                    const serverTime = new Date(response.time).getTime();
                    // Calcular diferencia: (Hora Servidor + Latencia) - Hora Local Actual
                    // Offset = Server - Local
                    const calculatedOffset = (serverTime + latency) - endTime;
                    setOffset(calculatedOffset);
                    setCurrentTime(new Date(Date.now() + calculatedOffset));
                }
            } catch (error) {
                console.error('Error syncing server time:', error);
                // Fallback a hora local si falla
            } finally {
                setLoading(false);
            }
        };

        syncTime();

        // Resincronizar cada minuto (opcional, por ahora solo al montar)
        // const interval = setInterval(syncTime, 60000);
        // return () => clearInterval(interval);
    }, []);

    useEffect(() => {
        // Actualizar el reloj local cada segundo usando el offset
        const timer = setInterval(() => {
            setCurrentTime(new Date(Date.now() + offset));
        }, 1000);

        return () => clearInterval(timer);
    }, [offset]);

    return { currentTime, loading };
};

export default useServerTime;
