import { query } from './database.js';

export const ClientModel = {
    async getAll() {
        const res = await query('SELECT * FROM clients');
        return res.rows;
    },

    async getById(id) {
        const res = await query('SELECT * FROM clients WHERE id = $1', [id]);
        return res.rows[0];
    },

    async getByUserId(userId) {
        const res = await query('SELECT * FROM clients WHERE user_id = $1', [userId]);
        return res.rows[0];
    },

    async getByCompanyId(companyId) {
        const res = await query('SELECT c.*, u.email, u.is_active FROM clients c JOIN users u ON c.user_id = u.id WHERE c.company_id = $1', [companyId]);
        return res.rows;
    },

    async create(client) {
        const { user_id, company_id, client_number, name, phone, fiscal_name, rfc, fiscal_address, address, alternate_address, email, is_active, allow_access_without_service } = client;
        const res = await query(
            `INSERT INTO clients (user_id, company_id, client_number, name, phone, fiscal_name, rfc, fiscal_address, address, alternate_address, email, is_active, allow_access_without_service)
       VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13)
       RETURNING *`,
            [user_id, company_id, client_number, name, phone, fiscal_name, rfc, fiscal_address, address, alternate_address, email, is_active, allow_access_without_service]
        );
        return res.rows[0];
    },

    async update(userId, client) {
        const fields = [];
        const values = [];
        let idx = 1;

        for (const [key, value] of Object.entries(client)) {
            if (key !== 'updated_at' && key !== 'created_at' && key !== 'id' && key !== 'user_id' && key !== 'password') {
                fields.push(`${key} = $${idx}`);
                values.push(value);
                idx++;
            }
        }
        values.push(userId);

        const res = await query(
            `UPDATE clients SET ${fields.join(', ')}, updated_at = CURRENT_TIMESTAMP WHERE user_id = $${idx} RETURNING *`,
            values
        );
        return res.rows[0];
    },

    async delete(id) {
        await query('DELETE FROM clients WHERE id = $1', [id]);
        return true;
    }
};
