import { query } from './database.js';

export const CompanyModel = {
    async getAll() {
        const res = await query('SELECT * FROM companies');
        return res.rows;
    },

    async getById(id) {
        const res = await query('SELECT * FROM companies WHERE id = $1', [id]);
        return res.rows[0];
    },

    async create(company) {
        const { name, logo_url, slogan, service_completion_message, is_active, max_clients, max_employees } = company;
        const res = await query(
            `INSERT INTO companies (name, logo_url, slogan, service_completion_message, is_active, max_clients, max_employees)
       VALUES ($1, $2, $3, $4, $5, $6, $7)
       RETURNING *`,
            [name, logo_url, slogan, service_completion_message, is_active, max_clients || 0, max_employees || 0]
        );
        return res.rows[0];
    },


    async update(id, company) {
        const fields = [];
        const values = [];
        let idx = 1;

        for (const [key, value] of Object.entries(company)) {
            if (key !== 'updated_at' && key !== 'created_at' && key !== 'id') {
                fields.push(`${key} = $${idx}`);
                values.push(value);
                idx++;
            }
        }
        values.push(id);

        const res = await query(
            `UPDATE companies SET ${fields.join(', ')}, updated_at = CURRENT_TIMESTAMP WHERE id = $${idx} RETURNING *`,
            values
        );
        return res.rows[0];
    },

    async delete(id) {
        await query('DELETE FROM companies WHERE id = $1', [id]);
        return true;
    }
};
