import { query } from './database.js';

export const EmployeeModel = {
    async getAll() {
        const res = await query('SELECT * FROM employees');
        return res.rows;
    },

    async getById(id) {
        const res = await query('SELECT * FROM employees WHERE id = $1', [id]);
        return res.rows[0];
    },

    async getByUserId(userId) {
        const res = await query('SELECT * FROM employees WHERE user_id = $1', [userId]);
        return res.rows[0];
    },

    async create(employee) {
        const { user_id, company_id, name, phone, specialty, is_active, photo_url } = employee;
        const res = await query(
            `INSERT INTO employees (user_id, company_id, name, phone, specialty, is_active, photo_url)
       VALUES ($1, $2, $3, $4, $5, $6, $7)
       RETURNING *`,
            [user_id, company_id, name, phone, specialty, is_active, photo_url]
        );
        return res.rows[0];
    },

    async update(userId, employee) {
        const fields = [];
        const values = [];
        let idx = 1;

        for (const [key, value] of Object.entries(employee)) {
            if (key !== 'updated_at' && key !== 'created_at' && key !== 'id' && key !== 'user_id' && key !== 'password' && key !== 'email') {
                fields.push(`${key} = $${idx}`);
                values.push(value);
                idx++;
            }
        }
        values.push(userId);

        const res = await query(
            `UPDATE employees SET ${fields.join(', ')}, updated_at = CURRENT_TIMESTAMP WHERE user_id = $${idx} RETURNING *`,
            values
        );
        return res.rows[0];
    },

    async delete(id) {
        await query('DELETE FROM employees WHERE id = $1', [id]);
        return true;
    }
};
