import { query } from './database.js';

export const EvidenceModel = {
    async getByServiceId(serviceId) {
        const res = await query(`
            SELECT e.*, u.role as uploader_role, u.email as uploader_email 
            FROM evidences e 
            JOIN users u ON e.uploaded_by = u.id 
            WHERE e.contracted_service_id = $1
            ORDER BY e.uploaded_at DESC
        `, [serviceId]);
        return res.rows;
    },

    async create(evidence) {
        const { contracted_service_id, uploaded_by, file_url, evidence_type, description } = evidence;
        const res = await query(
            `INSERT INTO evidences (contracted_service_id, uploaded_by, file_url, evidence_type, description)
       VALUES ($1, $2, $3, $4, $5)
       RETURNING *`,
            [contracted_service_id, uploaded_by, file_url, evidence_type, description]
        );
        return res.rows[0];
    },

    async delete(id) {
        await query('DELETE FROM evidences WHERE id = $1', [id]);
        return true;
    }
};
